/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ccs.javafxrefclient.request;

import com.avaya.ccs.api.ClientI;
import com.avaya.ccs.javafxrefclient.Logger;
import javafx.concurrent.Task;

public abstract class Request
extends Task<Object> {
    private static ClientI client;
    private final Logger LOG;

    public Request(Logger LOG) {
        this.LOG = LOG;
        this.setupHandlers();
    }

    private void setupHandlers() {
        this.setFailed();
        this.setSucceeded();
        this.setCancelled();
    }

    public void setFailed() {
        this.setOnFailed(t -> {
            String methodName = "failedHandler() ";
            Throwable f = (Throwable)t.getSource().exceptionProperty().getValue();
            this.LOG.error(methodName, f);
            Exception e = (Exception)t.getSource().exceptionProperty().getValue();
            this.LOG.error(methodName, e);
        });
    }

    public void setSucceeded() {
        this.setOnSucceeded(t -> {
            String methodName = "succeededHandler() ";
            this.LOG.trace(methodName, new Object[0]);
        });
    }

    public void setCancelled() {
        this.setOnCancelled(t -> {
            String methodName = "cancelledHandler() ";
            this.LOG.trace(methodName, new Object[0]);
        });
    }

    public ClientI getClient() {
        return client;
    }

    public void setClient(ClientI client) {
        Request.client = client;
    }
}

