/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ccs.javafxrefclient;

import com.avaya.ccs.javafxrefclient.EmailForm;
import com.avaya.ccs.javafxrefclient.Logger;
import com.avaya.ccs.javafxrefclient.UserExecutor;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.VBox;
import javafx.scene.web.HTMLEditor;
import javafx.stage.Stage;

public class AgentSignatureForm {
    private final Stage signatureForm = new Stage();
    private ScrollPane scrollPane;
    private final Scene signatureScene;
    private static final Logger LOG = Logger.getLogger(EmailForm.class);
    private HTMLEditor htmlEd = new HTMLEditor();
    Button saveButton = new Button("Save");
    VBox vbox = new VBox();
    private UserExecutor userExe;
    private String existingSignature;

    public AgentSignatureForm(String userId, UserExecutor userExe, String existingSignature, String css) {
        String methodName = "AgentSignatureForm";
        LOG.info(methodName, "Agent: " + userId);
        this.existingSignature = existingSignature;
        this.vbox.setPadding(new Insets(10.0));
        this.vbox.getChildren().addAll((Object[])new Node[]{this.htmlEd, this.saveButton});
        this.userExe = userExe;
        this.htmlEd.setPrefHeight(400.0);
        this.htmlEd.setPrefWidth(625.0);
        String htmlSignature = existingSignature;
        this.saveButton.setOnAction(e -> {
            LOG.info("AgentSignatureForm", "setting agent signature for Agent : " + userId + " to: " + htmlSignature);
            userExe.setAgentSignature(userId, this.htmlEd.getHtmlText());
        });
        this.scrollPane = new ScrollPane();
        this.scrollPane.setVbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        this.scrollPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        this.scrollPane.setContent((Node)this.vbox);
        this.signatureScene = new Scene((Parent)this.scrollPane, 700.0, 450.0);
        this.signatureScene.getStylesheets().add((Object)css);
        this.signatureForm.setScene(this.signatureScene);
        this.signatureForm.setTitle("Agent Signature");
    }

    public void show() {
        LOG.debug("show()", new Object[0]);
        this.signatureForm.show();
    }
}

