/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ccs.javafxrefclient;

import com.avaya.ccs.api.ClientI;
import com.avaya.ccs.api.ClientListenerI;
import com.avaya.ccs.api.ErrorI;
import com.avaya.ccs.api.InteractionListenerI;
import com.avaya.ccs.api.NotificationEventI;
import com.avaya.ccs.api.ResourceListenerI;
import com.avaya.ccs.api.SessionI;
import com.avaya.ccs.api.SessionListenerI;
import com.avaya.ccs.api.UserListenerI;
import com.avaya.ccs.api.enums.CodeType;
import com.avaya.ccs.api.enums.Command;
import com.avaya.ccs.api.enums.NotificationType;
import com.avaya.ccs.api.exceptions.InvalidArgumentException;
import com.avaya.ccs.api.exceptions.ObjectInvalidException;
import com.avaya.ccs.javafxrefclient.ClientEventTask;
import com.avaya.ccs.javafxrefclient.ConnectionDetails;
import com.avaya.ccs.javafxrefclient.Executor;
import com.avaya.ccs.javafxrefclient.JavaFXRefClient;
import com.avaya.ccs.javafxrefclient.Logger;
import com.avaya.ccs.javafxrefclient.SessionEventTask;
import com.avaya.ccs.javafxrefclient.request.DisconnectRequest;
import com.avaya.ccs.javafxrefclient.request.GetClientDataRequest;
import com.avaya.ccs.javafxrefclient.request.GetSessionCodesRequest;
import com.avaya.ccs.javafxrefclient.request.GetSessionDataRequest;
import com.avaya.ccs.javafxrefclient.request.SignInRequest;

public class ClientSessionExecutor
extends Executor
implements ClientListenerI,
SessionListenerI {
    private static final Logger LOG = Logger.getLogger(ClientSessionExecutor.class);
    private ClientI client;
    private final JavaFXRefClient gui;

    public ClientSessionExecutor(JavaFXRefClient gui) {
        this.gui = gui;
    }

    public ClientI getClient() {
        return this.client;
    }

    public void setClient(ClientI client) {
        this.client = client;
    }

    public void disconnect() {
        String methodName = "disconnect() ";
        LOG.trace(methodName + "+", new Object[0]);
        this.executeOutgoingRequest(new DisconnectRequest());
        LOG.trace(methodName + "-", new Object[0]);
    }

    public void processNewSession() {
        String methodName = "processNewSession() ";
        try {
            SessionI session = this.client.getSession();
            int numberOfUsers = session.getNumUsers();
            if (numberOfUsers > 0) {
                LOG.debug(methodName + "NumUsers:" + numberOfUsers, new Object[0]);
            } else {
                LOG.error(methodName + "No users in session.", new Object[0]);
            }
            LOG.trace(methodName + "Registering User listener", new Object[0]);
            session.openUsers((UserListenerI)ClientSessionExecutor.getUser());
            LOG.trace(methodName + "Registering Resource listener", new Object[0]);
            session.openResources((ResourceListenerI)ClientSessionExecutor.getResource());
            LOG.trace(methodName + "Registering Interaction listener", new Object[0]);
            session.openInteractions((InteractionListenerI)ClientSessionExecutor.getInteractionExe());
        }
        catch (InvalidArgumentException | ObjectInvalidException e) {
            LOG.error(methodName + "error received " + e, new Object[0]);
        }
    }

    public void signinClient(ConnectionDetails connectionDetails) {
        String methodName = "signinClient() ";
        LOG.debug(methodName + "+", new Object[0]);
        this.executeOutgoingRequest(new SignInRequest(this, connectionDetails));
        LOG.trace(methodName + "-", new Object[0]);
    }

    public void getClientData() {
        String methodName = "getClientData() ";
        LOG.debug(methodName + "+", new Object[0]);
        this.executeOutgoingRequest(new GetClientDataRequest(this.gui));
        LOG.trace(methodName + "-", new Object[0]);
    }

    public void getSessionData() {
        String methodName = "getSessionData() ";
        LOG.debug(methodName + "+", new Object[0]);
        this.executeOutgoingRequest(new GetSessionDataRequest(this.gui));
        LOG.trace(methodName + "-", new Object[0]);
    }

    public void getSessionCodes(CodeType type) {
        String methodName = "getSessionCodes";
        LOG.debug(methodName + "+ CodeType:" + type, new Object[0]);
        this.executeOutgoingRequest(new GetSessionCodesRequest(this.gui.getUserGUI(), type));
        LOG.trace(methodName + "-", new Object[0]);
    }

    public void onClientEvent(NotificationEventI<ClientI> client) {
        String methodName = "onClientEvent() ";
        LOG.info(methodName + "Type:" + client.getNotificationType(), new Object[0]);
        if (client.getNotificationType() == NotificationType.ERROR) {
            ErrorI error = client.getError();
            Command command = error.getCommand();
            LOG.error(methodName + "error = " + error + " command=" + command, new Object[0]);
        }
        ClientEventTask t = new ClientEventTask(client.getNotificationType(), (ClientI)client.getNotificationObject(), this.gui);
        this.executeIncomingEvent(t);
    }

    public void onSessionEvent(NotificationEventI<SessionI> session) {
        String methodName = "onSessionEvent() ";
        LOG.info(methodName + "Type:" + session.getNotificationType() + " SessionI-ID:" + (session.getNotificationObject() != null ? ((SessionI)session.getNotificationObject()).getId() : "null"), new Object[0]);
        SessionEventTask t = new SessionEventTask(session, this, this.gui);
        this.executeIncomingEvent(t);
    }
}

