/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ccs.javafxrefclient;

import com.avaya.ccs.javafxrefclient.Data;
import com.avaya.ccs.javafxrefclient.DetailsForm;
import com.avaya.ccs.javafxrefclient.Logger;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.ComboBox;

public abstract class ComboDataGUI {
    private final Logger LOG;
    private final ObservableList<Data> items = FXCollections.observableArrayList();
    private final ComboBox<String> itemSelection = new ComboBox();
    private DetailsForm detailsForm;

    public ComboDataGUI(final Logger LOG) {
        this.LOG = LOG;
        this.itemSelection.valueProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                String methodName = "itemSelectionChanged() ";
                LOG.trace(methodName + "+", new Object[0]);
                ComboDataGUI.this.redrawControls();
                LOG.trace(methodName + "-", new Object[0]);
            }
        });
    }

    protected Data getCurrentItemSelection() {
        String methodName = "getCurrentItemSelection() ";
        String currentSelection = (String)this.getItemSelection().getValue();
        if (currentSelection != null) {
            this.LOG.trace(methodName + "current selection:" + currentSelection, new Object[0]);
            return this.getItem(currentSelection);
        }
        this.LOG.trace(methodName + "current selection is NULL, returning null", new Object[0]);
        return null;
    }

    public void update(ObservableList<Data> data) {
        String methodName = "update() ";
        this.LOG.info(methodName + " DataSize:" + data.size(), new Object[0]);
        this.items.clear();
        this.items.addAll(data);
        this.refreshListsAndRedraw();
    }

    public void update(Data data) {
        String methodName = "update() ";
        this.LOG.trace(methodName + "DataID:" + data.getId(), new Object[0]);
        Data itemFound = null;
        for (Data item : this.items) {
            if (!item.getId().equals(data.getId())) continue;
            itemFound = item;
            break;
        }
        if (itemFound != null) {
            this.LOG.trace(methodName + "existing entry found", new Object[0]);
            this.items.remove((Object)itemFound);
            if (data.isDeleted()) {
                this.LOG.trace(methodName + "update is a deletion update, not adding new data", new Object[0]);
            } else {
                this.LOG.trace(methodName + "updating entry", new Object[0]);
                this.items.add((Object)data);
            }
        } else if (data.isDeleted()) {
            this.LOG.trace(methodName + "existing entry not found, but update is a delete so NOT adding", new Object[0]);
        } else {
            this.LOG.trace(methodName + "existing entry not found, adding", new Object[0]);
            this.items.add((Object)data);
        }
        this.refreshListsAndRedraw();
    }

    public void clearData() {
        this.items.clear();
        this.refreshListsAndRedraw();
    }

    protected void refreshListsAndRedraw() {
        this.refreshList();
        if (this.getDetailsForm() != null) {
            this.getDetailsForm().refresh();
        }
        this.redrawControls();
    }

    protected void refreshList() {
        String methodName = "refreshList() ";
        String currentSelection = (String)this.getItemSelection().getValue();
        boolean stillExists = false;
        for (Data user : this.items) {
            if (!user.getId().equals(currentSelection)) continue;
            stillExists = true;
        }
        this.getItemSelection().getItems().clear();
        for (Data user : this.items) {
            this.getItemSelection().getItems().add((Object)user.getId());
        }
        if (stillExists) {
            this.LOG.trace(methodName + "existing selection still exists:" + currentSelection, new Object[0]);
            this.getItemSelection().setValue((Object)currentSelection);
        } else if (this.items.size() > 0) {
            this.LOG.trace(methodName + "existing selection does not exists, setting to first element", new Object[0]);
            this.getItemSelection().getSelectionModel().selectFirst();
        } else {
            this.LOG.trace(methodName + "list is empty", new Object[0]);
        }
    }

    public Data getItem(String id) {
        String methodName = "getItem() ";
        this.LOG.trace(methodName + "ID:" + id, new Object[0]);
        for (Data item : this.items) {
            if (!item.getId().equals(id)) continue;
            this.LOG.trace(methodName + "item found", new Object[0]);
            return item;
        }
        return null;
    }

    public ObservableList<Data> getItems() {
        return this.items;
    }

    protected abstract void redrawControls();

    public ComboBox<String> getItemSelection() {
        return this.itemSelection;
    }

    public DetailsForm getDetailsForm() {
        return this.detailsForm;
    }

    public void setDetailsForm(DetailsForm detailsForm) {
        this.detailsForm = detailsForm;
    }
}

