/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ccs.javafxrefclient;

import com.avaya.ccs.core.ContactListItem;
import com.avaya.ccs.core.CustomerData;
import com.avaya.ccs.javafxrefclient.InteractionDataGUI;
import com.avaya.ccs.javafxrefclient.InteractionExecutor;
import java.time.LocalDate;
import java.util.Arrays;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.Tab;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;

public class ContactSearchTab {
    private final Tab tab;
    private InteractionDataGUI gui;
    private InteractionExecutor interactionExe;
    private ObservableList<ContactListItem> searchResults = FXCollections.observableArrayList();
    private ListView<ContactListItem> searchResultsListView = new ListView();

    public ContactSearchTab(InteractionExecutor interactionExe, InteractionDataGUI gui) {
        this.tab = new Tab();
        this.tab.setText("Contact Search");
        this.tab.setClosable(false);
        this.gui = gui;
        this.interactionExe = interactionExe;
        VBox root = new VBox(5.0);
        Label searchCriteriaLabel = new Label("Search Criteria");
        ObservableList subject = FXCollections.observableArrayList();
        subject.addAll(Arrays.asList("Skillset", "Status", "Subject", "ClosedReason", "Type", "DispositionCode", "MailTo", "MailFrom", "ArrivalDate", "LastAction", "Agent", "ID", "ClosedDate"));
        ComboBox subjectCB = new ComboBox(subject);
        String[] operators1 = new String[]{"Is", "IsNot"};
        String[] operators2 = new String[]{"Contains", "BeginsWith", "EndsWith"};
        String[] operators3 = new String[]{"Before", "On", "After"};
        String[] operators4 = new String[]{"LessThan", "EqualTo", "GreaterThan"};
        ObservableList operators = FXCollections.observableArrayList();
        operators.addAll(Arrays.asList(new String[0]));
        ComboBox operatorsCB = new ComboBox(operators);
        ObservableList values = FXCollections.observableArrayList();
        values.addAll(Arrays.asList(new String[0]));
        ComboBox valuesCb = new ComboBox(values);
        TextField valuesTf = new TextField();
        DatePicker valuesDp = new DatePicker();
        HBox searchCriteriaHbox = new HBox(5.0);
        Button addQueryButton = new Button("+");
        searchCriteriaHbox.getChildren().addAll((Object[])new Node[]{subjectCB, operatorsCB, valuesCb, addQueryButton});
        HBox buttonsHbox = new HBox(5.0);
        Button searchBtn = new Button("Search");
        buttonsHbox.getChildren().addAll((Object[])new Node[]{searchBtn});
        subjectCB.setOnAction(event -> {
            switch ((String)subjectCB.getValue()) {
                case "Skillset": 
                case "Status": 
                case "ClosedReason": 
                case "Type": 
                case "DispositionCode": 
                case "LastAction": 
                case "Agent": {
                    operators.clear();
                    operators.addAll(Arrays.asList(operators1));
                    break;
                }
                case "Subject": 
                case "MailTo": 
                case "MailFrom": {
                    operators.clear();
                    operators.addAll(Arrays.asList(operators2));
                    break;
                }
                case "ArrivalDate": 
                case "ClosedDate": {
                    operators.clear();
                    operators.addAll(Arrays.asList(operators3));
                    break;
                }
                case "ID": {
                    operators.clear();
                    operators.addAll(Arrays.asList(operators4));
                    break;
                }
                default: {
                    operators.clear();
                }
            }
            switch ((String)subjectCB.getValue()) {
                case "Subject": 
                case "MailTo": 
                case "MailFrom": 
                case "ID": {
                    valuesTf.clear();
                    if (searchCriteriaHbox.getChildren().contains((Object)valuesCb)) {
                        searchCriteriaHbox.getChildren().remove((Object)valuesCb);
                    }
                    if (searchCriteriaHbox.getChildren().contains((Object)valuesDp)) {
                        searchCriteriaHbox.getChildren().remove((Object)valuesDp);
                    }
                    if (searchCriteriaHbox.getChildren().contains((Object)valuesTf)) break;
                    searchCriteriaHbox.getChildren().add(2, (Object)valuesTf);
                    break;
                }
                case "Skillset": 
                case "Status": 
                case "ClosedReason": 
                case "Type": 
                case "DispositionCode": 
                case "LastAction": 
                case "Agent": {
                    if (searchCriteriaHbox.getChildren().contains((Object)valuesTf)) {
                        searchCriteriaHbox.getChildren().remove((Object)valuesTf);
                    }
                    if (searchCriteriaHbox.getChildren().contains((Object)valuesDp)) {
                        searchCriteriaHbox.getChildren().remove((Object)valuesDp);
                    }
                    if (searchCriteriaHbox.getChildren().contains((Object)valuesCb)) break;
                    searchCriteriaHbox.getChildren().add(2, (Object)valuesCb);
                    break;
                }
                case "ArrivalDate": 
                case "ClosedDate": {
                    if (searchCriteriaHbox.getChildren().contains((Object)valuesTf)) {
                        searchCriteriaHbox.getChildren().remove((Object)valuesTf);
                    }
                    if (searchCriteriaHbox.getChildren().contains((Object)valuesCb)) {
                        searchCriteriaHbox.getChildren().remove((Object)valuesCb);
                    }
                    if (searchCriteriaHbox.getChildren().contains((Object)valuesDp)) break;
                    searchCriteriaHbox.getChildren().add(2, (Object)valuesDp);
                }
            }
            switch ((String)subjectCB.getValue()) {
                case "Skillset": {
                    values.clear();
                    values.addAll((Object[])this.getSkillsets());
                    break;
                }
                case "Status": {
                    values.clear();
                    values.addAll((Object[])this.getStatuses());
                    break;
                }
                case "ClosedReason": {
                    values.clear();
                    values.addAll((Object[])this.getClosedReasons());
                    break;
                }
                case "Type": {
                    values.clear();
                    values.addAll((Object[])this.getTypes());
                    break;
                }
                case "DispositionCode": {
                    values.clear();
                    values.addAll((Object[])this.getDispositionCodes());
                    break;
                }
                case "LastAction": {
                    values.clear();
                    values.addAll((Object[])this.getLastActions());
                    break;
                }
                case "Agent": {
                    values.clear();
                    values.addAll((Object[])this.getAgents());
                }
            }
        });
        searchBtn.setOnAction(t -> {
            String key = (String)subjectCB.getValue();
            String condition = (String)operatorsCB.getValue();
            String value = "";
            if (searchCriteriaHbox.getChildren().contains((Object)valuesCb)) {
                value = (String)valuesCb.getValue();
            } else if (searchCriteriaHbox.getChildren().contains((Object)valuesTf)) {
                value = valuesTf.getText();
            } else if (searchCriteriaHbox.getChildren().contains((Object)valuesDp)) {
                value = ((LocalDate)valuesDp.getValue()).toString();
            }
            this.interactionExe.searchContacts("{\"SearchCriteriaList\":[{\"Key\":\"" + key + "\",\"Condition\":\"" + condition + "\",\"Value\":\"" + value + "\"}]}");
        });
        this.searchResultsListView.setItems(this.searchResults);
        root.getChildren().addAll((Object[])new Node[]{searchCriteriaLabel, searchCriteriaHbox, buttonsHbox, this.searchResultsListView});
        this.tab.setContent((Node)root);
        this.tab.setDisable(false);
    }

    private String[] getAgents() {
        return new String[0];
    }

    private String[] getLastActions() {
        return new String[]{"Agent Created", "Outgoing Call", "Replied", "Rescheduled", "Transferred", "Unknown"};
    }

    private String[] getDispositionCodes() {
        return new String[0];
    }

    private String[] getTypes() {
        return new String[]{"Email", "WebChat"};
    }

    private String[] getClosedReasons() {
        return new String[0];
    }

    private String[] getStatuses() {
        return new String[]{"Closed", "New", "Open", "Waiting"};
    }

    private String[] getSkillsets() {
        return new String[0];
    }

    public void setSearchResults(CustomerData c) {
    }

    public Tab getTab() {
        return this.tab;
    }
}

