/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ccs.javafxrefclient;

import com.avaya.ccs.api.MediaI;
import com.avaya.ccs.api.NotificationEventI;
import com.avaya.ccs.api.ResponseData;
import com.avaya.ccs.api.enums.ContactType;
import com.avaya.ccs.api.enums.NotificationType;
import com.avaya.ccs.core.EmailMedia;
import com.avaya.ccs.core.Media;
import com.avaya.ccs.core.SuggestedResponses;
import com.avaya.ccs.core.WebChatMedia;
import com.avaya.ccs.javafxrefclient.EmailForm;
import com.avaya.ccs.javafxrefclient.InteractionData;
import com.avaya.ccs.javafxrefclient.InteractionDataGUI;
import com.avaya.ccs.javafxrefclient.InteractionExecutor;
import com.avaya.ccs.javafxrefclient.Logger;
import com.avaya.ccs.javafxrefclient.SupervisorDataGUI;
import com.avaya.ccs.javafxrefclient.WebchatForm;
import javafx.application.Platform;
import javafx.concurrent.Task;

public class InteractionMediaEventTask
extends Task<Object> {
    private final NotificationEventI<? extends MediaI> notificationEvent;
    private final InteractionDataGUI gui;
    private final SupervisorDataGUI superGui;
    private ContactType contactType;
    private static final Logger LOG = Logger.getLogger(InteractionMediaEventTask.class);
    Media interactionMedia = null;

    public InteractionMediaEventTask(NotificationEventI<? extends MediaI> nei, InteractionDataGUI interactionDataGUI, SupervisorDataGUI supervisorGUI, ContactType contactType) {
        this.notificationEvent = nei;
        this.gui = interactionDataGUI;
        this.superGui = supervisorGUI;
        this.contactType = contactType;
        LOG.debug("InteractionMediaEventTask constructor set contactType to" + contactType, new Object[0]);
    }

    protected Object call() throws Exception {
        String methodName = "call() ";
        InteractionData data = null;
        NotificationType notificationType = this.notificationEvent.getNotificationType();
        LOG.debug(methodName + "Type:" + notificationType + " ID:" + ((MediaI)this.notificationEvent.getNotificationObject()).getId(), new Object[0]);
        if (this.contactType == ContactType.EMail) {
            this.interactionMedia = (EmailMedia)this.notificationEvent.getNotificationObject();
        } else if (this.contactType == ContactType.Web_Communications) {
            this.interactionMedia = (WebChatMedia)this.notificationEvent.getNotificationObject();
        }
        switch (notificationType) {
            case NEW: {
                Platform.runLater(() -> {
                    if (this.contactType == ContactType.EMail) {
                        EmailForm thisForm = this.gui.getEmailFormForContact(this.interactionMedia.getId());
                        thisForm.setInteractionMedia((EmailMedia)this.interactionMedia);
                        thisForm.show();
                    } else if (this.contactType == ContactType.Web_Communications) {
                        String id = this.interactionMedia.getId();
                        WebchatForm f = null;
                        f = this.gui.getWebChatFormForContact(id);
                        if (f == null) {
                            LOG.info("no form found in GUI with id: " + id, new Object[0]);
                            f = this.superGui.getWebChatFormForContact(id);
                        }
                        try {
                            WebChatMedia media = (WebChatMedia)this.interactionMedia;
                            f.setMedia(media);
                            f.show();
                        }
                        catch (Exception e) {
                            LOG.error("ex ", e);
                        }
                    }
                });
                break;
            }
            case OPEN: {
                Platform.runLater(() -> {
                    if (this.contactType == ContactType.Web_Communications) {
                        WebchatForm f = null;
                        String id = this.interactionMedia.getId();
                        f = this.gui.getWebChatFormForContact(id);
                        if (f == null) {
                            f = this.superGui.getWebChatFormForContact(id);
                        }
                        WebChatMedia p = (WebChatMedia)this.interactionMedia;
                        f.setMedia(p);
                    }
                });
                break;
            }
            case UPDATE: {
                if (this.contactType == ContactType.Web_Communications) {
                    String id = this.interactionMedia.getId();
                    WebchatForm form = null;
                    form = this.gui.getWebChatFormForContact(id);
                    if (form == null) {
                        form = this.superGui.getWebChatFormForContact(id);
                    }
                    WebChatMedia media = (WebChatMedia)this.interactionMedia;
                    form.updateMedia(media);
                    if (!media.getMethod().equals((Object)"customerDisconnect")) break;
                    this.gui.customerDisconnectedWebChat(this.interactionMedia.getId());
                    break;
                }
                LOG.warn(methodName, this.contactType + " is an unexpected contact type for Update. Not Implemented.");
                break;
            }
            case DELETE: {
                data = new InteractionData(((MediaI)this.notificationEvent.getNotificationObject()).getId(), true);
                if (data.getContactType() == ContactType.EMail) {
                    this.gui.deleteEmailFormCorContact(data.getId());
                } else if (data.getContactType() == ContactType.Web_Communications) {
                    this.gui.removeAndCloseWebChatForm(data.getId());
                }
                InteractionExecutor.getTimers().stop(((MediaI)this.notificationEvent.getNotificationObject()).getId());
                break;
            }
            case ERROR: {
                LOG.warn(methodName + "case Error --NOT IMPLEMENTED. interactionMedia: " + this.interactionMedia, new Object[0]);
                break;
            }
            case RESPONSE: {
                ResponseData resp = this.notificationEvent.getResponseData();
                LOG.info(methodName + "case Response. ResponseData: " + resp, new Object[0]);
                if (resp instanceof SuggestedResponses) {
                    this.gui.getEmailFormForContact(((MediaI)this.notificationEvent.getNotificationObject()).getId()).setSuggestedResponses((SuggestedResponses)resp);
                }
                return resp;
            }
            case UNKNOWN: {
                LOG.warn(methodName + "case Unknown --NOT IMPLEMENTED. interactionMedia: " + this.interactionMedia, new Object[0]);
                break;
            }
            default: {
                LOG.info(methodName + "case Default interactionMedia: " + this.interactionMedia, new Object[0]);
                InteractionExecutor.getTimers().stop(((MediaI)this.notificationEvent.getNotificationObject()).getId());
            }
        }
        return data;
    }
}

