/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ccs.javafxrefclient.request;

import com.avaya.ccs.api.DataI;
import com.avaya.ccs.javafxrefclient.Logger;
import com.avaya.ccs.javafxrefclient.request.InteractionRequest;
import java.util.Map;

public class SetDataRequest
extends InteractionRequest {
    private static final Logger LOG = Logger.getLogger(SetDataRequest.class);
    private String newStrValue = null;
    private Map<String, String> map = null;
    private byte[] bytes = null;

    public SetDataRequest(String interactionID, String newValue) {
        super(LOG, interactionID);
        this.newStrValue = newValue;
    }

    public SetDataRequest(String interactionID, Map<String, String> newValue) {
        super(LOG, interactionID);
        this.map = newValue;
    }

    public SetDataRequest(String interactionID, byte[] newValue) {
        super(LOG, interactionID);
        this.bytes = newValue;
    }

    protected Object call() throws Exception {
        String methodName = "call() ";
        String dataType = "NONE";
        LOG.trace(methodName + "+", new Object[0]);
        DataI data = null;
        if (this.newStrValue != null) {
            data = DataI.create((String)this.newStrValue);
            dataType = "String";
        } else if (this.map != null) {
            data = DataI.create(this.map);
            dataType = "KVP";
        } else if (this.bytes != null) {
            data = DataI.create((byte[])this.bytes);
            dataType = "byte[]";
        }
        if (data != null) {
            LOG.info(methodName + "setting data of type:" + dataType, new Object[0]);
            this.getInteraction().setData(data);
        }
        LOG.trace(methodName + "-", new Object[0]);
        return null;
    }
}

