/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ccs.api.enums;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.HashMap;
import java.util.Map;

public enum Command {
    SignIn,
    Login,
    Logout,
    Ready,
    NotReady,
    LoginOffsite,
    RecoverOffsite,
    AfterCallWork,
    GetOffsiteSettings,
    ClearNotification,
    MonitorAgents,
    UnmonitorAgents,
    SetLanguage,
    ForceLogout,
    ForceReady,
    ForceNotReady,
    Originate,
    OriginateEmail,
    CallSupervisor,
    Answer,
    Hold,
    Unhold,
    End,
    InitiateTransfer,
    InitiateConference,
    CompleteTransfer,
    CompleteConference,
    JoinConference,
    PlayDTMF,
    Emergency,
    SetActivityCode,
    GetActivityCodes,
    GetCustomFields,
    SetIntrinsic,
    RemoveIntrinsic,
    SetUUI,
    SetData,
    RemoveData,
    AddToDNC,
    AddAgentNote,
    RefreshAgentNotes,
    AgentNotes,
    PreviewDial,
    PreviewDialFreeForm,
    PreviewCancel,
    Redial,
    CreateCallback,
    GetCallbackDestinations,
    GetConsultDestinationTypes,
    GetConsultDestinations,
    GetSuggestedResponses,
    GetCustomerDetails,
    GetCustomerHistory,
    GetCustomerInteractionMedia,
    EmailReschedule,
    GetDispositionCodes,
    Wrapup,
    WrapupWithCode,
    ExtendWrapup,
    InitiateConferenceToDestination,
    InitiateTransferToDestination,
    TransferToDestination,
    UpdateCustomerName,
    UpdateCustomerEmail,
    UpdateCustomerPhone,
    UpdateCustomerAddress,
    EndConference,
    ChangeConferenceOwner,
    Observe,
    BargeIn,
    Whisper,
    OpenMedia,
    Reply,
    AddAttachments,
    UpdateClosedReasonCode,
    ContactSearch,
    Pull,
    Create,
    GetSkillsets,
    NewMessage,
    IsTyping,
    PagePush,
    Consult,
    GetAutoPhrases,
    GetPagePushUrls,
    GetScreenPops,
    EndConsult,
    ObserveDn,
    Unknown,
    GetConfiguration,
    RequestID,
    Coach,
    EmailReview;

    static Map<String, Command> commandMap;

    @JsonCreator
    static Command get(String commandName) {
        Command command = commandMap.get(commandName);
        if (command == null) {
            command = Unknown;
        }
        return command;
    }

    static {
        commandMap = new HashMap<String, Command>();
        for (Command commands : Command.values()) {
            commandMap.put(commands.toString(), commands);
        }
    }
}

