/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ccs.core;

import com.avaya.ccs.api.SecurityContextI;
import com.avaya.ccs.api.exceptions.InvalidArgumentException;
import com.avaya.ccs.api.exceptions.SecurityException;
import com.avaya.ccs.core.Logger;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.util.Enumeration;

public class SecurityContext
implements SecurityContextI {
    static Logger log = Logger.getLogger(SecurityContext.class);
    private KeyStore keyStore;

    @Override
    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public static SecurityContext create(KeyStore keyStore) throws InvalidArgumentException, SecurityException {
        if (keyStore == null) {
            throw new InvalidArgumentException("mandatory keystore argument is null");
        }
        SecurityContext context = new SecurityContext();
        context.keyStore = keyStore;
        context.isValid();
        return context;
    }

    boolean isValid() throws SecurityException {
        try {
            boolean isValid = false;
            Enumeration<String> certAliases = this.keyStore.aliases();
            while (certAliases.hasMoreElements()) {
                String certAlias = certAliases.nextElement();
                Certificate cert = this.keyStore.getCertificate(certAlias);
                if (cert == null) continue;
                log.info("isValid", certAlias, " certificate found, ", cert.getType());
                isValid = true;
            }
            if (!isValid) {
                log.error("isValid", "ca certificate could not be found in the keystore");
                throw new SecurityException("ca certificate was not found in the keystore");
            }
            return isValid;
        }
        catch (KeyStoreException e) {
            log.error("isValid", e);
            throw new SecurityException("keystore has not been initialized", e);
        }
    }
}

