/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ccs.core;

import com.avaya.ccs.core.CommonResources;
import com.avaya.ccs.core.Logger;
import com.avaya.ccs.core.ProtocolHandler;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.websocket.api.RemoteEndpoint;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WriteCallback;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketError;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketFrame;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.client.WebSocketClient;

@org.eclipse.jetty.websocket.api.annotations.WebSocket
public class WebSocket {
    private static Logger log = Logger.getLogger(WebSocket.class);
    private static WebSocketClient webSocketClient;
    private static Lock lock;
    private String wsUri;
    private RemoteEndpoint remoteEndpoint;
    private ProtocolHandler handler;
    Session session = null;
    Future<Session> connectTask;
    UUID webSocketUuid = UUID.randomUUID();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static WebSocketClient getStartedWebSocketClient(SslContextFactory sslContextFactory) {
        String methodName = "getStartedWebSocketClient";
        Lock lock = WebSocket.lock;
        synchronized (lock) {
            if (webSocketClient == null) {
                webSocketClient = sslContextFactory != null ? new WebSocketClient(sslContextFactory, (Executor)CommonResources.getWsSharedThreadPool()) : new WebSocketClient((Executor)CommonResources.getWsSharedThreadPool());
                log.debug("getStartedWebSocketClient", "created web socket client, secure?", sslContextFactory != null);
                webSocketClient.setMaxIdleTimeout(20000L);
            }
            if (!webSocketClient.isStarted()) {
                try {
                    log.debug("getStartedWebSocketClient", "starting web socket client");
                    webSocketClient.start();
                }
                catch (Exception e) {
                    log.error("getStartedWebSocketClient", e, "failed to start web socket client " + webSocketClient.getState());
                    webSocketClient = null;
                }
            }
        }
        return webSocketClient;
    }

    WebSocket(String wsUri, ProtocolHandler handler, SslContextFactory sslContextFactory) {
        this.wsUri = wsUri + "&Uuid=" + this.webSocketUuid;
        this.handler = handler;
        WebSocket.getStartedWebSocketClient(sslContextFactory);
        log.info("<init>", this);
    }

    void connect() {
        String methodName = "connect";
        try {
            log.info("connect", this);
            if (this.connectTask != null) {
                this.connectTask.cancel(true);
            }
            if (webSocketClient == null || !webSocketClient.isStarted()) {
                throw new Exception("web socket client is null or not started");
            }
            this.connectTask = webSocketClient.connect((Object)this, URI.create(this.wsUri));
        }
        catch (IllegalArgumentException iae) {
            log.error("connect", iae, "URI is not valid " + this.toString());
            this.getHandler().onError(new URISyntaxException(this.wsUri, iae.getMessage()));
        }
        catch (Exception e) {
            log.error("connect", e, this.toString());
            this.getHandler().onError(e);
        }
    }

    void disconnect() {
        try {
            if (this.connectTask != null) {
                this.connectTask.cancel(true);
            }
            if (this.session != null) {
                log.info("disconnect", "closing session ", this);
                this.session.close();
            } else {
                log.info("disconnect", "no web socket session, simulate close event ", this);
                this.onClose(1001, "WebSocket-No-Session-Client-Disconnect");
            }
            log.debug("disconnect", "done ", this);
        }
        catch (Exception e) {
            log.error("disconnect", e, this.toString());
            this.onClose(1001, "WebSocket-Close-Failed");
        }
    }

    void send(String data) {
        log.trace("send", this);
        this.remoteEndpoint.sendString(data, new WriteCallback(){

            public void writeSuccess() {
                log.trace("writeSuccess", this);
            }

            public void writeFailed(Throwable t) {
                log.error("writeFailed", t, this.toString());
            }
        });
        log.trace("send", this, ", done");
    }

    public ProtocolHandler getHandler() {
        return this.handler;
    }

    @OnWebSocketConnect
    public void onConnect(Session session) {
        try {
            this.connectTask = null;
            this.session = session;
            session.getPolicy().setMaxTextMessageSize(1024000);
            log.trace("onConnect", this);
            this.remoteEndpoint = session.getRemote();
            this.getHandler().onConnect();
        }
        catch (Exception e) {
            log.error("onConnect", e);
        }
    }

    @OnWebSocketClose
    public void onClose(int status, String reason) {
        try {
            this.session = null;
            log.trace("onClose", this);
            this.getHandler().onClose(status, reason);
        }
        catch (Exception e) {
            log.error("onClose", e);
        }
    }

    @OnWebSocketMessage
    public void onMessage(String msg) {
        try {
            log.trace("onMessage", this.toString());
            this.getHandler().onMessage(msg);
        }
        catch (Exception e) {
            log.error("onMessage", e);
        }
    }

    @OnWebSocketError
    public void onError(Throwable t) {
        try {
            log.error("onError", this.toString(), " ", t);
            this.getHandler().onError(t);
        }
        catch (Exception e) {
            log.error("onError", e);
        }
    }

    @OnWebSocketFrame
    public void onPing(Frame frame) {
        try {
            if (frame != null && frame.getType() == Frame.Type.PING) {
                log.trace("onPing", this);
            }
        }
        catch (Exception e) {
            log.error("onPing", e);
        }
    }

    public String toString() {
        return "[WebSocket: WsClientState=" + (webSocketClient != null ? webSocketClient.getState() : "null") + " WsSessionOpen?=" + (this.session != null && this.session.isOpen()) + " UUID=" + this.webSocketUuid + (this.handler != null ? " " + this.handler.getChannel() : "") + "]";
    }

    static {
        lock = new ReentrantLock();
    }
}

