/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling;

import java.util.Arrays;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.rolling.RollingFileManager;
import org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;

@Plugin(name="Policies", category="Core", printObject=true)
public final class CompositeTriggeringPolicy
implements TriggeringPolicy {
    private final TriggeringPolicy[] triggeringPolicy;

    private CompositeTriggeringPolicy(TriggeringPolicy ... policies) {
        this.triggeringPolicy = policies;
    }

    public TriggeringPolicy[] getTriggeringPolicies() {
        return this.triggeringPolicy;
    }

    @Override
    public void initialize(RollingFileManager manager) {
        for (TriggeringPolicy policy : this.triggeringPolicy) {
            policy.initialize(manager);
        }
    }

    @Override
    public boolean isTriggeringEvent(LogEvent event) {
        for (TriggeringPolicy policy : this.triggeringPolicy) {
            if (!policy.isTriggeringEvent(event)) continue;
            return true;
        }
        return false;
    }

    @PluginFactory
    public static CompositeTriggeringPolicy createPolicy(TriggeringPolicy ... policies) {
        return new CompositeTriggeringPolicy(policies);
    }

    public String toString() {
        return "CompositeTriggeringPolicy(policies=" + Arrays.toString(this.triggeringPolicy) + ")";
    }
}

