/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ccs.core;

import com.avaya.ccs.api.ContactCenterCodeI;
import com.avaya.ccs.api.DataI;
import com.avaya.ccs.api.IntrinsicI;
import com.avaya.ccs.api.MonitoredInteractionI;
import com.avaya.ccs.api.enums.Command;
import com.avaya.ccs.api.enums.ContactType;
import com.avaya.ccs.api.enums.InteractionState;
import com.avaya.ccs.api.enums.StateReason;
import com.avaya.ccs.api.exceptions.InvalidArgumentException;
import com.avaya.ccs.api.exceptions.ObjectInvalidException;
import com.avaya.ccs.core.BaseInteraction;
import com.avaya.ccs.core.CommandArgs;
import com.avaya.ccs.core.Logger;
import com.avaya.ccs.core.NotificationDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public class MonitoredInteraction
extends BaseInteraction
implements MonitoredInteractionI {
    private static Logger log = Logger.getLogger(MonitoredInteraction.class);
    @JsonProperty(value="SupervisorID")
    String supervisorId;

    @Override
    public synchronized boolean canObserve() throws ObjectInvalidException {
        return this.isCommandAvailable(Command.Observe);
    }

    @Override
    public synchronized boolean canBargeIn() throws ObjectInvalidException {
        return this.isCommandAvailable(Command.BargeIn);
    }

    @Override
    public synchronized boolean canWhisper() throws ObjectInvalidException {
        return this.isCommandAvailable(Command.Whisper);
    }

    @Override
    public synchronized String getAddress() throws ObjectInvalidException {
        return super.getAddress();
    }

    @Override
    public synchronized String getAddressName() throws ObjectInvalidException {
        return super.getAddressName();
    }

    @Override
    public synchronized String getCallingAddress() throws ObjectInvalidException {
        return super.getCallingAddress();
    }

    @Override
    public synchronized String getCallingAddressName() throws ObjectInvalidException {
        return super.getCallingAddressName();
    }

    @Override
    public synchronized String getCalledAddress() throws ObjectInvalidException {
        return super.getCalledAddress();
    }

    @Override
    public synchronized String getCalledAddressName() throws ObjectInvalidException {
        return super.getCalledAddressName();
    }

    @Override
    public synchronized ContactCenterCodeI getActivityCode() throws ObjectInvalidException {
        return super.getActivityCode();
    }

    @Override
    public synchronized String getContactId() throws ObjectInvalidException {
        return super.getContactId();
    }

    @Override
    public synchronized ContactType getContactType() throws ObjectInvalidException {
        return super.getContactType();
    }

    @Override
    public synchronized DataI getData() throws ObjectInvalidException {
        return super.getData();
    }

    @Override
    public synchronized List<IntrinsicI> getIntrinsics() throws ObjectInvalidException {
        return super.getIntrinsics();
    }

    @Override
    public synchronized IntrinsicI getIntrinsic(String name) throws ObjectInvalidException, InvalidArgumentException {
        return super.getIntrinsic(name);
    }

    @Override
    public synchronized boolean isMonitored() throws ObjectInvalidException {
        return super.isMonitored();
    }

    @Override
    public synchronized boolean isMultimedia() throws ObjectInvalidException {
        return super.isMultimedia();
    }

    @Override
    public synchronized String getSkillset() throws ObjectInvalidException {
        return super.getSkillset();
    }

    @Override
    public synchronized InteractionState getState() {
        return super.getState();
    }

    @Override
    public synchronized StateReason getStateReason() {
        return super.getStateReason();
    }

    @Override
    public synchronized String getUUI() throws ObjectInvalidException {
        return super.getUUI();
    }

    @Override
    public synchronized String getMainContactId() throws ObjectInvalidException {
        return super.getMainContactId();
    }

    @Override
    public synchronized String getOriginalDestination() throws ObjectInvalidException {
        return super.getOriginalDestination();
    }

    @Override
    public synchronized String getSupervisorId() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.supervisorId;
    }

    @Override
    public synchronized String getMonitoredUserId() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.userId;
    }

    @Override
    public synchronized void observe() throws ObjectInvalidException {
        this.checkForDeletion();
        this.execute(() -> {
            log.info("observe", this);
            this.post(new CommandArgs(Command.Observe), null);
        }, "MonitoredInteraction.observe()");
    }

    @Override
    public synchronized void bargeIn() throws ObjectInvalidException {
        this.checkForDeletion();
        this.execute(() -> {
            log.info("bargeIn", this);
            this.post(new CommandArgs(Command.BargeIn), null);
        }, "MonitoredInteraction.bargeIn()");
    }

    @Override
    public synchronized void whisper() throws ObjectInvalidException {
        this.checkForDeletion();
        this.execute(() -> {
            log.info("whisper", this);
            this.post(new CommandArgs(Command.Whisper), null);
        }, "MonitoredInteraction.whisper()");
    }

    @Override
    NotificationDescription.ObjectType getObjectType() {
        return NotificationDescription.ObjectType.MonitoredInteraction;
    }

    String toJsonStringMaskSensitive() {
        return "{ID:" + this.id + ",ContactID:" + this.contactId + ",IsMonitored:" + this.isMonitored + ",ContactType:" + (Object)((Object)this.contactType) + ",RemoteParticipants:" + this.remoteParticipants + ",IsMultimedia:" + this.isMultimedia + ",UserID:" + this.userId + ",State:" + (Object)((Object)this.state) + ",StateReason:" + (Object)((Object)this.reason) + ",Address:" + this.address + (this.skillset != null ? ",Skillset:" + this.skillset : "") + ",CallingAddress:" + this.callingAddress + ",CalledAddress:" + this.calledAddress + ",ActivityCode:" + this.activityCode + (this.intrinsics != null ? ",Intrinsics:***sensitive-data[" + this.intrinsics.get().size() + "]***" : "") + (this.originalDestination != null ? ",OriginalDestination:" + this.originalDestination : "") + (this.uui != null ? ",UUI:***sensitive-data[" + this.uui.length() + "]***" : "") + (this.data != null ? ",Data:***sensitive-data[" + (Object)((Object)this.data.getFormat()) + "][" + this.data.length() + "]***" : "") + (this.mainContactId != null ? ",MainContactID:" + this.mainContactId : "") + ",SupervisorID:" + this.supervisorId + ",Functions:" + this.availableCommands + "}";
    }

    public String toString() {
        return "[MonitoredInteraction ID:" + this.id + ",SupervisorID:" + this.supervisorId + ",UserID:" + this.userId + ",State:" + (Object)((Object)this.state) + "]";
    }
}

