/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ccs.javafxrefclient;

import com.avaya.ccs.api.CustomFieldI;
import com.avaya.ccs.api.CustomFieldListI;
import com.avaya.ccs.api.DataI;
import com.avaya.ccs.javafxrefclient.IntrinsicElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class KVPItem {
    private final String name;
    private final String value;
    private final boolean readOnly;

    public KVPItem(String name, String value, boolean readOnly) {
        this.name = name;
        this.value = value;
        this.readOnly = readOnly;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public static List<KVPItem> convertIntrinsicsList(List<IntrinsicElement> intrinsics) {
        ArrayList<KVPItem> newList = new ArrayList<KVPItem>();
        for (IntrinsicElement i : intrinsics) {
            newList.add(new KVPItem(i.getName(), i.getValue(), i.isReadOnly()));
        }
        return newList;
    }

    public static List<KVPItem> convertCustomFieldsList(CustomFieldListI customFields) {
        ArrayList<KVPItem> newList = new ArrayList<KVPItem>();
        for (CustomFieldI i : customFields.getCustomFields()) {
            newList.add(new KVPItem(i.getName(), i.getValue(), true));
        }
        return newList;
    }

    public static List<KVPItem> convertKVPData(DataI data) {
        ArrayList<KVPItem> newList = new ArrayList<KVPItem>();
        if (data == null) {
            return newList;
        }
        Map kvps = data.getKvpData();
        if (kvps == null) {
            return newList;
        }
        for (Map.Entry i : kvps.entrySet()) {
            newList.add(new KVPItem((String)i.getKey(), (String)i.getValue(), false));
        }
        return newList;
    }
}

