/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ccs.javafxrefclient;

import com.avaya.ccs.javafxrefclient.InteractionDataGUI;
import com.avaya.ccs.javafxrefclient.InteractionExecutor;
import com.avaya.ccs.javafxrefclient.KVPItem;
import com.avaya.ccs.javafxrefclient.KVPTabBase;
import com.avaya.ccs.javafxrefclient.Logger;
import java.util.Optional;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.util.Pair;

public abstract class KVPTab
extends KVPTabBase {
    private final Logger LOG;
    protected final InteractionExecutor interactionExe;
    protected final InteractionDataGUI gui;

    public KVPTab(Logger LOG, InteractionExecutor interactionExe, InteractionDataGUI gui, String title) {
        super(title);
        this.LOG = LOG;
        this.interactionExe = interactionExe;
        this.gui = gui;
        HBox buttons = new HBox();
        Button remove = new Button("Remove");
        remove.setDisable(true);
        remove.getStyleClass().add((Object)"kvpButton");
        remove.setOnAction(t -> {
            LOG.info("RemoveButton()", new Object[0]);
            KVPItem currentSelection = (KVPItem)this.getTable().getSelectionModel().getSelectedItem();
            this.removeDialog(currentSelection.getName(), currentSelection.getValue());
        });
        Button add = new Button("Add");
        add.getStyleClass().add((Object)"kvpButton");
        add.setOnAction(t -> {
            LOG.info("AddButton()", new Object[0]);
            this.addDialog();
        });
        Button edit = new Button("Edit");
        edit.setDisable(true);
        edit.getStyleClass().add((Object)"kvpButton");
        edit.setOnAction(t -> {
            LOG.info("EditButton()", new Object[0]);
            KVPItem currentSelection = (KVPItem)this.getTable().getSelectionModel().getSelectedItem();
            this.editDialog(currentSelection.getName(), currentSelection.getValue());
        });
        buttons.getChildren().addAll((Object[])new Node[]{remove, add, edit});
        this.getPane().setBottom((Node)buttons);
        this.getTable().getSelectionModel().selectedItemProperty().addListener((obs, oldSelection, newSelection) -> {
            String methodName = "kvpSelectionChanged() ";
            if (newSelection != null) {
                LOG.trace(methodName + "selection is not null", new Object[0]);
                remove.setDisable(newSelection.isReadOnly());
                edit.setDisable(newSelection.isReadOnly());
            } else {
                LOG.trace(methodName + "selection is null", new Object[0]);
                remove.setDisable(true);
                edit.setDisable(true);
            }
        });
    }

    protected void removeDialog(String key, String value) {
        Dialog dialog = new Dialog();
        dialog.setTitle("Remove " + this.getTitle());
        ButtonType removeButtonType = new ButtonType("Remove", ButtonBar.ButtonData.OK_DONE);
        dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{removeButtonType, ButtonType.CANCEL});
        GridPane grid = new GridPane();
        grid.getStyleClass().add((Object)"dialog");
        grid.add((Node)new Label("Name:"), 0, 0);
        grid.add((Node)new Label(key), 1, 0);
        grid.add((Node)new Label("Value:"), 0, 1);
        grid.add((Node)new Label(value), 1, 1);
        dialog.getDialogPane().setContent((Node)grid);
        dialog.setResultConverter(dialogButton -> {
            if (dialogButton == removeButtonType) {
                return new Pair((Object)key, (Object)value);
            }
            return null;
        });
        Optional result = dialog.showAndWait();
        result.ifPresent(keyValue -> {
            String keyResult = (String)keyValue.getKey();
            String methodName = "removeDialog() ";
            this.LOG.trace(methodName + "Key:" + keyResult + " Value: " + (String)keyValue.getValue(), new Object[0]);
            this.remove(this.gui.getCurrentItemSelection().getId(), keyResult);
        });
    }

    protected void editDialog(String name, String value) {
        Dialog dialog = new Dialog();
        dialog.setTitle("Edit " + this.getTitle());
        ButtonType okButtonType = new ButtonType("Save", ButtonBar.ButtonData.OK_DONE);
        dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{okButtonType, ButtonType.CANCEL});
        GridPane grid = new GridPane();
        grid.getStyleClass().add((Object)"dialog");
        TextField nameTextField = new TextField();
        nameTextField.setText(name);
        nameTextField.setEditable(false);
        TextField valueTextField = new TextField();
        valueTextField.setText(value);
        grid.add((Node)new Label("Name:"), 0, 0);
        grid.add((Node)nameTextField, 1, 0);
        grid.add((Node)new Label("Value:"), 0, 1);
        grid.add((Node)valueTextField, 1, 1);
        dialog.getDialogPane().setContent((Node)grid);
        Platform.runLater(() -> nameTextField.requestFocus());
        dialog.setResultConverter(dialogButton -> {
            if (dialogButton == okButtonType) {
                return new Pair((Object)nameTextField.getText(), (Object)valueTextField.getText());
            }
            return null;
        });
        Optional result = dialog.showAndWait();
        result.ifPresent(resultNameValue -> {
            String methodName = "editDialog() ";
            String resultKey = (String)resultNameValue.getKey();
            String resultValue = (String)resultNameValue.getValue();
            this.LOG.trace(methodName + "Key: " + resultKey + " Value: " + resultValue, new Object[0]);
            this.edit(this.gui.getCurrentItemSelection().getId(), resultKey, resultValue);
        });
    }

    protected void addDialog() {
        Dialog dialog = new Dialog();
        dialog.setTitle("Add " + this.getTitle());
        ButtonType okButtonType = new ButtonType("Save", ButtonBar.ButtonData.OK_DONE);
        dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{okButtonType, ButtonType.CANCEL});
        GridPane grid = new GridPane();
        grid.getStyleClass().add((Object)"dialog");
        TextField nameTextField = new TextField();
        TextField valueTextField = new TextField();
        grid.add((Node)new Label("Name:"), 0, 0);
        grid.add((Node)nameTextField, 1, 0);
        grid.add((Node)new Label("Value:"), 0, 1);
        grid.add((Node)valueTextField, 1, 1);
        dialog.getDialogPane().setContent((Node)grid);
        Platform.runLater(() -> nameTextField.requestFocus());
        dialog.setResultConverter(dialogButton -> {
            if (dialogButton == okButtonType) {
                return new Pair((Object)nameTextField.getText(), (Object)valueTextField.getText());
            }
            return null;
        });
        Optional result = dialog.showAndWait();
        result.ifPresent(resultNameValue -> {
            String methodName = "addDialog() ";
            String resultName = (String)resultNameValue.getKey();
            String resultValue = (String)resultNameValue.getValue();
            this.LOG.trace(methodName + "Add called on name: " + resultName + " with value: " + resultValue, new Object[0]);
            this.add(this.gui.getCurrentItemSelection().getId(), resultName, resultValue);
        });
    }

    abstract void add(String var1, String var2, String var3);

    abstract void edit(String var1, String var2, String var3);

    abstract void remove(String var1, String var2);
}

