/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ccs.javafxrefclient;

import com.avaya.ccs.api.CodeListI;
import com.avaya.ccs.api.MonitoredUserI;
import com.avaya.ccs.api.NotificationEventI;
import com.avaya.ccs.api.ResponseData;
import com.avaya.ccs.api.enums.NotificationType;
import com.avaya.ccs.javafxrefclient.Logger;
import com.avaya.ccs.javafxrefclient.MonitoredUserData;
import com.avaya.ccs.javafxrefclient.SupervisorDataGUI;
import javafx.concurrent.Task;

public class MonitoredUserEventTask
extends Task<MonitoredUserData> {
    private final NotificationEventI<MonitoredUserI> user;
    private final SupervisorDataGUI gui;
    private static final Logger LOG = Logger.getLogger(MonitoredUserEventTask.class);

    public MonitoredUserEventTask(NotificationEventI<MonitoredUserI> user, SupervisorDataGUI gui) {
        this.user = user;
        this.gui = gui;
        this.setupJavaFXApplicationSucceededHandler();
    }

    private void setupJavaFXApplicationSucceededHandler() {
        this.setOnSucceeded(t -> {
            String methodName = "succeededHandler() ";
            MonitoredUserData value = (MonitoredUserData)t.getSource().getValue();
            if (value != null) {
                if (!value.isDeleted()) {
                    LOG.info(methodName + "MonitoredUserData:" + value, new Object[0]);
                } else {
                    LOG.info(methodName + "Deletion of MonitoredUserData-ID:" + value.getId(), new Object[0]);
                }
                this.gui.UpdateMonitoredUserData(value);
            } else {
                LOG.debug(methodName + " NULL", new Object[0]);
            }
        });
    }

    protected MonitoredUserData call() throws Exception {
        String methodName = "call() ";
        MonitoredUserData data = null;
        NotificationType type = this.user.getNotificationType();
        LOG.debug(methodName + "Type:" + type + " ID:" + ((MonitoredUserI)this.user.getNotificationObject()).getId(), new Object[0]);
        switch (type) {
            case UPDATE: {
                data = new MonitoredUserData((MonitoredUserI)this.user.getNotificationObject());
                break;
            }
            case DELETE: {
                data = new MonitoredUserData(((MonitoredUserI)this.user.getNotificationObject()).getId(), true);
                break;
            }
            case ERROR: {
                LOG.errorStatus(this.user.getError());
                break;
            }
            case NEW: {
                data = new MonitoredUserData((MonitoredUserI)this.user.getNotificationObject());
                break;
            }
            case RESPONSE: {
                ResponseData resp = this.user.getResponseData();
                if (!(resp instanceof CodeListI)) break;
                LOG.debug(methodName + " type of codelist", new Object[0]);
                data = new MonitoredUserData(null);
                break;
            }
        }
        return data;
    }
}

