/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ccs.javafxrefclient;

import com.avaya.ccs.api.ContactNumberI;
import com.avaya.ccs.javafxrefclient.CallbackForm;
import com.avaya.ccs.javafxrefclient.InteractionData;
import com.avaya.ccs.javafxrefclient.InteractionExecutor;
import com.avaya.ccs.javafxrefclient.Logger;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.TextField;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.util.Callback;

public class PreviewDialForm {
    private final Stage previewDial = new Stage();
    private final InteractionExecutor interactionExe;
    private static final Logger LOG = Logger.getLogger(PreviewDialForm.class);

    public PreviewDialForm(InteractionExecutor interactionExe, String css) {
        this.interactionExe = interactionExe;
        BorderPane previewDialBorder = new BorderPane();
        Scene previewDialScene = new Scene((Parent)previewDialBorder, 300.0, 400.0);
        previewDialScene.getStylesheets().add((Object)css);
        this.previewDial.setScene(previewDialScene);
        this.previewDial.titleProperty().set((Object)"Preview");
    }

    public void show() {
        this.previewDial.show();
    }

    public void updatePreviewDialForm(final InteractionData interaction, CallbackForm callbackForm) {
        BorderPane bp = (BorderPane)((Scene)this.previewDial.sceneProperty().get()).getRoot();
        ListView list = new ListView();
        ObservableList items = FXCollections.observableArrayList(interaction.getContactNumbers());
        list.setItems(items);
        list.setCellFactory((Callback)new Callback<ListView<ContactNumberI>, ListCell<ContactNumberI>>(){

            public ListCell<ContactNumberI> call(ListView<ContactNumberI> list) {
                return new CodeCell();
            }
        });
        final Button dialButton = new Button("Dial");
        dialButton.setDisable(true);
        list.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<ContactNumberI>(){

            public void changed(ObservableValue<? extends ContactNumberI> observable, ContactNumberI oldValue, ContactNumberI newValue) {
                if (newValue != null) {
                    dialButton.setDisable(false);
                }
            }
        });
        bp.setCenter((Node)list);
        dialButton.getStyleClass().add((Object)"interactionButton");
        dialButton.setOnAction(t -> {
            ContactNumberI toDial = (ContactNumberI)list.getSelectionModel().getSelectedItem();
            String id = interaction.getId();
            LOG.info("DialButton() ID:" + id + " ContactNumber:" + toDial, new Object[0]);
            this.interactionExe.previewDial(id, toDial);
            this.previewDial.close();
        });
        Button cancelButton = new Button("Cancel");
        cancelButton.getStyleClass().add((Object)"interactionButton");
        cancelButton.setOnAction(t -> {
            String id = interaction.getId();
            LOG.info("CancelButton() ID:" + id, new Object[0]);
            this.interactionExe.previewCancel(id);
            this.previewDial.close();
        });
        Button rescheduleButton = new Button("Callback");
        rescheduleButton.getStyleClass().add((Object)"interactionButton");
        rescheduleButton.setOnAction(t -> {
            String id = interaction.getId();
            LOG.info("RescheduleButton() ID:" + id, new Object[0]);
            callbackForm.initializeForm(interaction);
            this.interactionExe.getCallbackDestinations(id);
            callbackForm.show();
            this.previewDial.close();
        });
        HBox hbuttonbox = new HBox();
        hbuttonbox.getChildren().addAll((Object[])new Node[]{dialButton, cancelButton, rescheduleButton});
        HBox freeFormBox = new HBox();
        TextField freeFormNumber = new TextField();
        final Button freeFormDialButton = new Button("Dial");
        freeFormDialButton.getStyleClass().add((Object)"interactionButton");
        freeFormDialButton.setOnAction(t -> {
            String id = interaction.getId();
            String number = freeFormNumber.getText();
            LOG.info("DialButton() ID:" + id + " Number:" + number, new Object[0]);
            this.interactionExe.previewDialFreeForm(id, number);
            this.previewDial.close();
        });
        freeFormNumber.setDisable(!interaction.canPreviewDialFreeForm());
        freeFormDialButton.setDisable(true);
        freeFormNumber.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                freeFormDialButton.setDisable(!interaction.canPreviewDialFreeForm() && newValue.isEmpty());
            }
        });
        freeFormBox.getChildren().addAll((Object[])new Node[]{freeFormNumber, freeFormDialButton});
        cancelButton.setDisable(!interaction.canPreviewCancel());
        VBox v = new VBox();
        v.getChildren().addAll((Object[])new Node[]{freeFormBox, hbuttonbox});
        bp.setBottom((Node)v);
    }

    private static class CodeCell
    extends ListCell<ContactNumberI> {
        private CodeCell() {
        }

        public void updateItem(ContactNumberI item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (item != null) {
                this.setText(item.getName() + ":" + item.getNumber());
            }
        }
    }
}

