/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ccs.javafxrefclient;

import com.avaya.ccs.api.NotificationEventI;
import com.avaya.ccs.api.UserI;
import com.avaya.ccs.api.enums.NotificationType;
import com.avaya.ccs.javafxrefclient.Logger;
import com.avaya.ccs.javafxrefclient.SupervisorDataGUI;
import com.avaya.ccs.javafxrefclient.UserData;
import com.avaya.ccs.javafxrefclient.UserDataGUI;
import javafx.concurrent.Task;

public class UserEventTask
extends Task<UserData> {
    private final NotificationEventI<UserI> user;
    private final UserDataGUI gui;
    private final SupervisorDataGUI superGui;
    private static final Logger LOG = Logger.getLogger(UserEventTask.class);

    public UserEventTask(NotificationEventI<UserI> user, UserDataGUI gui, SupervisorDataGUI gui2) {
        this.user = user;
        this.gui = gui;
        this.superGui = gui2;
        this.setupJavaFXApplicationSucceededHandler();
    }

    private void setupJavaFXApplicationSucceededHandler() {
        this.setOnSucceeded(t -> {
            String methodName = "succeededHandler() ";
            UserData value = (UserData)t.getSource().valueProperty().getValue();
            if (value != null) {
                if (!value.isDeleted()) {
                    LOG.info(methodName + "UserData:" + value, new Object[0]);
                } else {
                    LOG.info(methodName + "Deletion of UserData-ID:" + value.getId(), new Object[0]);
                }
                this.gui.UpdateUserData(value);
                this.superGui.UpdateUserData(value);
            } else {
                LOG.debug(methodName + " NULL", new Object[0]);
            }
        });
    }

    protected UserData call() throws Exception {
        String methodName = "call() ";
        UserData data = null;
        NotificationType type = this.user.getNotificationType();
        LOG.debug(methodName + "Type:" + type + " ID:" + ((UserI)this.user.getNotificationObject()).getId(), new Object[0]);
        switch (type) {
            case UPDATE: {
                data = new UserData((UserI)this.user.getNotificationObject());
                break;
            }
            case DELETE: {
                data = new UserData(((UserI)this.user.getNotificationObject()).getId(), true);
                break;
            }
            case ERROR: {
                LOG.errorStatus(this.user.getError());
                break;
            }
            case NEW: {
                data = new UserData((UserI)this.user.getNotificationObject());
                break;
            }
            case RESPONSE: {
                data = new UserData((UserI)this.user.getNotificationObject());
                break;
            }
        }
        return data;
    }
}

