/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ccs.javafxrefclient.request;

import com.avaya.ccs.api.CodeListI;
import com.avaya.ccs.api.enums.CodeType;
import com.avaya.ccs.javafxrefclient.Logger;
import com.avaya.ccs.javafxrefclient.UserDataGUI;
import com.avaya.ccs.javafxrefclient.request.SessionRequest;

public class GetSessionCodesRequest
extends SessionRequest {
    private static final Logger LOG = Logger.getLogger(GetSessionCodesRequest.class);
    private final CodeType typeRequested;
    private final UserDataGUI gui;

    public GetSessionCodesRequest(UserDataGUI gui, CodeType typeRequested) {
        super(LOG);
        this.gui = gui;
        this.typeRequested = typeRequested;
    }

    protected Object call() throws Exception {
        String methodName = "call() ";
        LOG.trace(methodName + "+", new Object[0]);
        CodeListI codes = null;
        switch (this.typeRequested) {
            case ACW: {
                codes = this.getSession().getAfterCallWorkCodes();
                break;
            }
            case NRRC: {
                codes = this.getSession().getNotReadyReasonCodes();
                break;
            }
        }
        LOG.trace(methodName + "-", new Object[0]);
        return codes;
    }

    @Override
    public void setSucceeded() {
        this.setOnSucceeded(t -> {
            String methodName = "succeededHandler() ";
            CodeListI value = (CodeListI)t.getSource().valueProperty().getValue();
            if (value != null) {
                LOG.debug(methodName + "CodeListI:" + value, new Object[0]);
                this.gui.updateCodeSectionForm(value);
            } else {
                LOG.debug(methodName + " NULL", new Object[0]);
            }
        });
    }
}

