/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ccs.core;

import com.avaya.ccs.api.ContactCenterCodeI;
import com.avaya.ccs.api.enums.ContactType;
import com.avaya.ccs.api.enums.UserState;
import com.avaya.ccs.api.exceptions.InvalidArgumentException;
import com.avaya.ccs.api.exceptions.ObjectInvalidException;
import com.avaya.ccs.core.BaseObject;
import com.avaya.ccs.core.ContactCenterCode;
import com.avaya.ccs.core.NotificationDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;

public class BaseUser
extends BaseObject {
    @JsonProperty(value="LoginID")
    String loginId;
    @JsonProperty(value="FirstName")
    String firstName;
    @JsonProperty(value="LastName")
    String lastName;
    @JsonProperty(value="State")
    UserState state;
    @JsonProperty(value="ContactTypes")
    List<ContactType> contactTypes;
    @JsonProperty(value="Code")
    ContactCenterCode code;

    public ContactCenterCodeI getCode() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.code;
    }

    public String getFirstName() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.firstName;
    }

    public String getLastName() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.lastName;
    }

    public String getFullName() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.firstName + " " + this.lastName;
    }

    public String getLoginId() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.loginId;
    }

    public UserState getState() {
        return this.state;
    }

    public List<ContactType> getContactTypes() throws ObjectInvalidException {
        this.checkForDeletion();
        if (this.contactTypes == null) {
            return new ArrayList<ContactType>();
        }
        return new ArrayList<ContactType>(this.contactTypes);
    }

    public boolean hasContactType(ContactType contactType) throws ObjectInvalidException, InvalidArgumentException {
        this.checkForDeletion();
        if (contactType == null) {
            throw new InvalidArgumentException("contact type argument is null");
        }
        for (ContactType type : this.getContactTypes()) {
            if (type != contactType) continue;
            return true;
        }
        return false;
    }

    @Override
    NotificationDescription.ObjectType getObjectType() {
        return NotificationDescription.ObjectType.User;
    }

    @Override
    void markForDeletion() {
        this.deleted.set(true);
        this.client = null;
        this.parent = null;
        this.state = UserState.Invalid;
    }

    @Override
    void clearOldCachedDataBeforeUpdate() {
        this.code = null;
    }
}

