/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ccs.core;

import com.avaya.ccs.api.EmailMediaI;
import com.avaya.ccs.api.enums.Command;
import com.avaya.ccs.api.enums.ContactType;
import com.avaya.ccs.api.exceptions.ObjectInvalidException;
import com.avaya.ccs.core.CommandArgs;
import com.avaya.ccs.core.EmailAttachmentsArgument;
import com.avaya.ccs.core.EmailReplyResponse;
import com.avaya.ccs.core.InboundAttachment;
import com.avaya.ccs.core.Logger;
import com.avaya.ccs.core.Media;
import com.avaya.ccs.core.NotificationDescription;
import com.avaya.ccs.core.OutboundAttachment;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class EmailMedia
extends Media
implements EmailMediaI {
    private static Logger log = Logger.getLogger(EmailMedia.class);
    @JsonProperty(value="ID")
    private String id;
    @JsonProperty(value="ContactID")
    private String contactId;
    @JsonProperty(value="ContactType")
    private ContactType contactType;
    @JsonProperty(value="Status")
    private String status;
    @JsonProperty(value="ArrivalTime")
    private String arrivalTime;
    @JsonProperty(value="Subject")
    private String subject;
    @JsonProperty(value="From")
    private String from;
    @JsonProperty(value="To")
    private String to;
    @JsonProperty(value="CC")
    private String cc;
    @JsonProperty(value="BCC")
    private String bcc;
    @JsonProperty(value="MailboxAddress")
    private String mailboxAddress;
    @JsonProperty(value="Encoding")
    private String encoding;
    @JsonProperty(value="Attachments")
    private List<InboundAttachment> inboundAttachments;
    @JsonProperty(value="Body")
    private String body;
    @JsonProperty(value="Functions")
    private String[] functions;
    List<File> newAttachments = new ArrayList<File>();
    String uploadAttachmentUrl;
    private EmailReplyResponse emailReplyResponse;

    public void setTo(String to) {
        this.to = to;
    }

    @Override
    public String getUploadAttachmentUrl() {
        return this.uploadAttachmentUrl;
    }

    @Override
    public void setUploadAttachmentUrl(String attachmentUrl) {
        this.uploadAttachmentUrl = attachmentUrl;
    }

    public List<File> getNewAttachments() {
        return this.newAttachments;
    }

    @Override
    public NotificationDescription.ObjectType getObjectType() {
        return NotificationDescription.ObjectType.Media;
    }

    @Override
    void clearOldCachedDataBeforeUpdate() {
    }

    @Override
    void markForDeletion() {
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getContactId() {
        return this.contactId;
    }

    @Override
    public ContactType getContactType() {
        return this.contactType;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public String getArrivalTime() {
        return this.arrivalTime;
    }

    @Override
    public String getSubject() {
        return this.subject;
    }

    @Override
    public String getFrom() {
        return this.from;
    }

    @Override
    public String getTo() {
        return this.to;
    }

    @Override
    public String getCc() {
        return this.cc;
    }

    @Override
    public String getBcc() {
        return this.bcc;
    }

    @Override
    public String getMailboxAddress() {
        return this.mailboxAddress;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public String getBody() {
        return this.body;
    }

    @Override
    public List<InboundAttachment> getInboundAttachments() {
        return this.inboundAttachments;
    }

    @Override
    public void addNewAttachment(File file) {
        this.newAttachments.add(file);
    }

    public String toString() {
        return "EmailMedia [id=" + this.id + ", contactId=" + this.contactId + ", contactType=" + (Object)((Object)this.contactType) + ", status=" + this.status + ", arrivalTime=" + this.arrivalTime + ", subject=" + this.subject + ", from=" + this.from + ", to=" + this.to + ", cc=" + this.cc + ", bcc=" + this.bcc + ", mailboxAddress=" + this.mailboxAddress + ", encoding=" + this.encoding + ", body=" + this.body + ", attachments: " + this.printAttachments() + ", functionsStr=" + this.functions + "]";
    }

    @Override
    public String toJsonStringMaskSensitive() {
        String subjectMaskSensitive = "...";
        String fromMaskSensitive = "...";
        String bodyMaskSensitive = "...";
        return "EmailMedia [id=" + this.id + ", contactId=" + this.contactId + ", contactType=" + (Object)((Object)this.contactType) + ", status=" + this.status + ", arrivalTime=" + this.arrivalTime + ", subject=" + subjectMaskSensitive + ", from=" + fromMaskSensitive + ", to=" + this.to + ", cc=" + this.cc + ", bcc=" + this.bcc + ", mailboxAddress=" + this.mailboxAddress + ", encoding=" + this.encoding + ", body=" + bodyMaskSensitive + ", attachments: " + this.printAttachments() + ", functionsStr=" + this.functions + "]";
    }

    private String printAttachments() {
        if (this.inboundAttachments == null) {
            return "";
        }
        StringBuilder atts = new StringBuilder();
        for (InboundAttachment a : this.inboundAttachments) {
            atts.append(a);
        }
        return atts.toString();
    }

    @Override
    public void create(String to, String cc, String bcc, String subject, String body, String note, boolean hasAttachments, Integer skillsetId, boolean isHtml) {
        StringBuilder sb = new StringBuilder("{");
        sb.append("\"To\":" + this.inQuotes(this.escapeForJson(to)));
        sb.append(", \"CC\": " + this.inQuotes(this.escapeForJson(cc)));
        sb.append(", \"Subject\": " + this.inQuotes(this.escapeForJson(subject)));
        sb.append(", \"Body\": " + this.inQuotes(this.escapeForJson(body)));
        sb.append(", \"Note\": " + this.inQuotes(this.escapeForJson(note)));
        sb.append(", \"Attachments\": " + this.inQuotes(String.valueOf(hasAttachments)));
        sb.append(", \"BCC\": " + this.inQuotes(this.escapeForJson(bcc)));
        sb.append(", \"Skillset\": " + skillsetId);
        sb.append(", \"IsHtml\": " + isHtml);
        sb.append("}");
        this.postEmailCreate(new CommandArgs(Command.Create), sb.toString(), this.id);
    }

    @Override
    public void reply(String to, String cc, String bcc, String subject, String body, String note, boolean hasAttachments, boolean isHtml) {
        StringBuilder sb = new StringBuilder("{");
        sb.append("\"To\":" + this.inQuotes(this.escapeForJson(to)));
        sb.append(", \"CC\": " + this.inQuotes(this.escapeForJson(cc)));
        sb.append(", \"Subject\": " + this.inQuotes(this.escapeForJson(subject)));
        sb.append(", \"Body\": " + this.inQuotes(this.escapeForJson(body)));
        sb.append(", \"Note\": " + this.inQuotes(this.escapeForJson(note)));
        sb.append(", \"Attachments\": " + this.inQuotes(String.valueOf(hasAttachments)));
        sb.append(", \"BCC\": " + this.inQuotes(this.escapeForJson(bcc)));
        sb.append(", \"IsHtml\": " + isHtml);
        sb.append("}");
        this.postEmailReply(new CommandArgs(Command.Reply), sb.toString(), this.id);
    }

    @Override
    public synchronized void requestSuggestedResponses() {
        this.execute(() -> {
            log.info("requestSuggestedResponses", this);
            this.getSuggestedResponses(new CommandArgs(Command.GetSuggestedResponses), this.id);
        }, "EmailMedia.requestSuggestedResponses");
    }

    @Override
    public void setReplyResponse(EmailReplyResponse emailReplyResponse) {
        log.info("setReplyResponse. setting uploadURI: " + emailReplyResponse.getEmailAttachmentUploadUri(), new Object[0]);
        this.emailReplyResponse = emailReplyResponse;
        this.uploadAttachmentUrl = emailReplyResponse.getEmailAttachmentUploadUri();
    }

    private String inQuotes(String content) {
        return "\"" + content + "\"";
    }

    @Override
    public void reschedule(String callbackDate, String callbackTime, String callbackNote) {
        CommandArgs args = new CommandArgs(Command.EmailReschedule);
        args.appendArg(CommandArgs.Argument.CallbackDate, callbackDate);
        args.appendArg(CommandArgs.Argument.CallbackTime, callbackTime);
        args.appendArg(CommandArgs.Argument.CallbackNote, callbackNote);
        this.postEmailReschedule(args, null, this.id);
    }

    @Override
    @Deprecated
    public void linkOutboundAttachments(OutboundAttachment[] attachments) {
        EmailAttachmentsArgument emarg = new EmailAttachmentsArgument();
        emarg.emailOutboundAttachments = attachments;
        log.info("linkOutboundAttachments() " + emarg.toJson(), new Object[0]);
        this.postEmailAddAttachments(new CommandArgs(Command.AddAttachments), emarg.toJson(), this.id);
    }

    @Override
    public void completeAttachmentsUpload(OutboundAttachment[] attachments) throws ObjectInvalidException {
        EmailAttachmentsArgument emarg = new EmailAttachmentsArgument();
        emarg.emailOutboundAttachments = attachments;
        log.info("completeAttachmentsUpload() " + emarg.toJson(), new Object[0]);
        this.postEmailAddAttachments(new CommandArgs(Command.AddAttachments), emarg.toJson(), this.id);
    }
}

