/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ccs.api.enums;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.HashMap;
import java.util.Map;

public enum InteractionState {
    Idle,
    Ringing,
    Active,
    Held,
    Dropped,
    Dialing,
    Preview,
    Wrapup,
    Pending,
    Established,
    Initiated,
    Unknown;

    static Map<String, InteractionState> stateMap;

    @JsonCreator
    static InteractionState get(String stateName) {
        InteractionState state = stateMap.get(stateName);
        if (state == null) {
            state = Unknown;
        }
        return state;
    }

    static {
        stateMap = new HashMap<String, InteractionState>();
        for (InteractionState state : InteractionState.values()) {
            stateMap.put(state.toString(), state);
        }
    }
}

