/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ccs.core;

import com.avaya.ccs.api.ClientI;
import com.avaya.ccs.api.ClientListenerI;
import com.avaya.ccs.api.ResponseData;
import com.avaya.ccs.api.SecurityContextI;
import com.avaya.ccs.api.ServiceConfigI;
import com.avaya.ccs.api.SessionI;
import com.avaya.ccs.api.SessionListenerI;
import com.avaya.ccs.api.enums.ClientState;
import com.avaya.ccs.api.enums.Command;
import com.avaya.ccs.api.enums.ErrorCode;
import com.avaya.ccs.api.enums.NotificationType;
import com.avaya.ccs.api.enums.Profile;
import com.avaya.ccs.api.exceptions.InvalidArgumentException;
import com.avaya.ccs.api.exceptions.InvalidStateException;
import com.avaya.ccs.core.BaseObject;
import com.avaya.ccs.core.Channel;
import com.avaya.ccs.core.CommandArgs;
import com.avaya.ccs.core.CommonResources;
import com.avaya.ccs.core.Error;
import com.avaya.ccs.core.Logger;
import com.avaya.ccs.core.NotificationDescription;
import com.avaya.ccs.core.NotificationEvent;
import com.avaya.ccs.core.ProtocolHandler;
import com.avaya.ccs.core.Session;
import com.avaya.ccs.core.Utils;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.channels.UnresolvedAddressException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLHandshakeException;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public final class Client
extends BaseObject
implements ClientI,
Channel.ChannelListener {
    private static Logger log = Logger.getLogger(Client.class);
    private final ScheduledExecutorService executor = CommonResources.getClientExecutorService();
    private final ProcessingQueue tasks;
    private String clientId = CommonResources.getClientThreadPoolName() + "-" + CommonResources.getNextClientId();
    private Channel activeChannel;
    private Channel standbyChannel;
    private ClientListenerI clientListener;
    private SessionListenerI sessionListener;
    private String server;
    private String connectedServer;
    private boolean isConnected;
    private boolean isHa;
    private boolean isHaOperational;
    private boolean isSecure = true;
    private Session session;
    private static String sdkVersion = "7.x.x.x";
    private static String sdkBuild = "b";
    private static final boolean sslDisable;
    static final boolean labEnvironment;
    static final String operatingSystemName;
    static final String operatingSystemVersion;
    static final String operatingSystemArchitecture;
    static final String jreVersion;
    static final String jreVendor;
    private SslContextFactory sslContextFactory = null;
    private final Profile profile;
    final String applicationName;
    private String userId;
    private String password;
    private boolean hasAppRequestedDisconnect = false;
    private boolean autoReconnect = true;
    private boolean authenticationFailure = false;
    private static long reconnectShortDelayMs;
    private static long reconnectLongDelayMs;
    private static long connectAttemptsLongDelayThreshold;
    private static long connectAttemptsGiveUpThreshold;
    private long activeChannelConnectAttempts = 0L;
    private long standbyChannelConnectAttempts = 0L;
    static final List<ErrorCode> authErrors;
    private AtomicReference<ClientState> state = new AtomicReference<ClientState>(ClientState.DISCONNECTED);
    private static String propertiesFilePath;
    static Properties props;

    Client(String server, Profile profile, String applicationName, SecurityContextI securityContext) {
        this.server = server;
        this.profile = profile;
        this.applicationName = applicationName;
        this.tasks = new ProcessingQueue();
        log.info("<init>", this);
        this.createSslContextFactory(securityContext);
    }

    public static Client create(String server, Profile profile, String applicationName, SecurityContextI securityContext) {
        return new Client(server, profile, applicationName, securityContext);
    }

    static void loadProperties() {
        Throwable throwable;
        String methodName = "loadProperties";
        try {
            throwable = null;
            try (FileInputStream apiPropsInputStream = new FileInputStream(propertiesFilePath);){
                props.load(apiPropsInputStream);
                log.debug("loadProperties", "properties loaded from ", propertiesFilePath);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (FileNotFoundException e) {
            log.warn("loadProperties", "properties file not found");
        }
        catch (IOException e1) {
            log.error("loadProperties", e1, "i/o exception reading property file");
        }
        catch (Exception e2) {
            log.error("loadProperties", "ex: ", e2);
        }
        try {
            throwable = null;
            try (InputStream versionPropsInputStream = Client.class.getResourceAsStream("/version.properties");){
                props.load(versionPropsInputStream);
                sdkVersion = props.getProperty("version");
                sdkBuild = props.getProperty("build");
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (Exception e) {
            log.error("loadProperties", e, "version.properties could not be loaded");
        }
    }

    private boolean setState(ClientState newState) {
        ClientState lastState = this.state.get();
        this.state.set(newState);
        if (lastState == this.state.get()) {
            return false;
        }
        switch (newState) {
            case CONNECTED: {
                this.isConnected = true;
                break;
            }
            case CONNECTING: 
            case DISCONNECTED: {
                this.isConnected = false;
                break;
            }
        }
        return true;
    }

    void createSslContextFactory(SecurityContextI securityContext) {
        String methodName = "createSslContextFactory";
        if (sslDisable) {
            this.isSecure = false;
            log.info(methodName, "unsecure, ssl is disabled by dev property");
        } else {
            this.sslContextFactory = new SslContextFactory();
            if (securityContext != null) {
                this.sslContextFactory.setTrustStore(securityContext.getKeyStore());
                this.isSecure = true;
            } else {
                this.sslContextFactory.setTrustAll(true);
                this.isSecure = false;
                log.info(methodName, "no security context provided, setting trust all certificates");
            }
        }
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    private ScheduledExecutorService getExecutor() {
        return this.executor;
    }

    ProtocolHandler getProtocolHandler() {
        if (this.activeChannel != null) {
            return this.activeChannel.getProtocolHandler();
        }
        return null;
    }

    boolean canSignIn() {
        ClientState currentState = this.state.get();
        return currentState != ClientState.CONNECTING && currentState != ClientState.AUTHENTICATED;
    }

    @Override
    public void disconnect() {
        this.execute(() -> {
            this.hasAppRequestedDisconnect = true;
            log.info("disconnect", this);
            if (this.activeChannel != null) {
                this.activeChannel.disconnect();
            } else {
                log.warn("disconnect", "No active Channel, ", this);
            }
            if (this.standbyChannel != null) {
                this.standbyChannel.disconnect();
            }
        }, "Client.disconnect()");
    }

    @Override
    public void signin(String userId, String password, SessionListenerI sessionListener, ClientListenerI clientListener) throws InvalidArgumentException, InvalidStateException {
        String methodName = "signin";
        if (sessionListener == null) {
            log.error("signin", "session listener argument is null!");
            throw new InvalidArgumentException("the mandatory session listener argument is null");
        }
        if (clientListener == null) {
            log.error("signin", "client listener argument is null!");
            throw new InvalidArgumentException("the mandatory client listener argument is null");
        }
        if (Utils.isNullOrEmpty(userId)) {
            log.error("signin", "user id argument is null or empty!");
            throw new InvalidArgumentException("the mandatory user id argument is null or empty");
        }
        if (Utils.isNullOrEmpty(password)) {
            log.error("signin", "password argument is null or empty!");
            throw new InvalidArgumentException("the mandatory password argument is null or empty");
        }
        this.sessionListener = sessionListener;
        this.clientListener = clientListener;
        if (!this.canSignIn()) {
            throw new InvalidStateException("unable to signin from current state, disconnect and re-attempt signin");
        }
        this.execute(() -> {
            this.userId = userId;
            this.password = password;
            this.authenticationFailure = false;
            this.hasAppRequestedDisconnect = false;
            this.standbyChannel = null;
            this.activeChannel = null;
            log.info("signin", "About to create Active channel and connect");
            this.createAndConnectActiveChannel(this.server);
        }, "Client.signin()");
    }

    private void signin(Channel channel, String userId, String password) {
        String methodName = "signin";
        String jsonPassword = null;
        try {
            jsonPassword = ProtocolHandler.getJsonObjectMapper().writeValueAsString((Object)password);
        }
        catch (JsonProcessingException e) {
            log.warn("signin", new Object[]{"exception parsing serializing password ", e});
        }
        log.info("signin", "Send request, domain/user:***sensitive-data[", userId.length(), "]***, password:***sensitive-data[", password.length(), "]***");
        channel.sendRequest(ProtocolHandler.ProtocolRequestType.POST, "/" + (Object)((Object)NotificationDescription.ObjectType.Session), new CommandArgs(Command.SignIn, userId, true), jsonPassword);
    }

    @Override
    public String getServer() {
        return this.server;
    }

    @Override
    public void setServer(String server) {
        this.server = server;
    }

    @Override
    public boolean isConnected() {
        return this.isConnected;
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    @Override
    public String getVersion() {
        return sdkVersion;
    }

    protected String getSdkBuild() {
        return sdkBuild;
    }

    @Override
    public ClientState getState() {
        return this.state.get();
    }

    public ServiceConfigI getServiceConfig() {
        return this.activeChannel == null ? null : this.activeChannel.getServiceConfig();
    }

    @Override
    public void setAutoReconnect(boolean autoReconnect) {
        this.autoReconnect = autoReconnect;
    }

    @Override
    public boolean getAutoReconnect() {
        return this.autoReconnect;
    }

    @Override
    public boolean isHa() {
        return this.isHa;
    }

    @Override
    public boolean isSecure() {
        return this.isSecure;
    }

    @Override
    public boolean isHaOperational() {
        return this.isHaOperational;
    }

    @Override
    public String getConnectedServer() {
        return this.connectedServer;
    }

    void deleteSessionAndNotify() {
        String methodName = "deleteSessionAndNotify";
        log.debug("deleteSessionAndNotify", new Object[0]);
        if (this.session != null) {
            log.info("deleteSessionAndNotify", this.session);
            this.session.markForDeletion();
            this.notify(NotificationType.DELETE, this.session, null, null);
            this.session = null;
        }
    }

    Profile getProfile() {
        return this.profile;
    }

    void notify(NotificationType type, BaseObject object, Error error, ResponseData response) {
        log.info("notify", new Object[]{type, " ", object, error != null ? " " + error : "", response != null ? " " + response : ""});
        try {
            if (object instanceof ClientI) {
                if (this.clientListener != null) {
                    this.clientListener.onClientEvent(new NotificationEvent<ClientI>(type, (ClientI)((Object)object), error, response));
                }
            } else if (object instanceof SessionI && this.sessionListener != null) {
                this.sessionListener.onSessionEvent(new NotificationEvent<SessionI>(type, (SessionI)((Object)object), error, response));
            }
        }
        catch (Exception e) {
            log.error("notify", e, "Executing event listener for " + object + ", exception thrown from Application");
        }
    }

    private void onSessionNotification(Channel channel, Session session, NotificationType type, NotificationDescription desc, String payload) {
        String methodName = "onSessionNotification";
        log.info(methodName, new Object[]{"\n\n", type, desc.toJsonString(), payload != null ? "-" + payload : "", "\n"});
        try {
            switch (type) {
                case NEW: 
                case UPDATE: {
                    this.session = session;
                    this.notify(type, this.session, null, null);
                    break;
                }
                case RESPONSE: {
                    break;
                }
                case ERROR: {
                    if (!(desc instanceof Error)) break;
                    Error error = (Error)desc;
                    if (this.isAuthenticationError(error)) {
                        this.authenticationFailure = true;
                        try {
                            if (this.sessionListener != null) {
                                this.sessionListener.onSessionEvent(new NotificationEvent<Object>(type, null, error));
                            }
                        }
                        catch (Exception e) {
                            log.error(methodName, e, "Executing event listener for Session, exception thrown from Application");
                        }
                        break;
                    }
                    this.notify(type, this.session, error, null);
                    break;
                }
                default: {
                    log.warn(methodName, "unhandled notification type " + (Object)((Object)type));
                }
            }
        }
        catch (Exception e) {
            log.error(methodName, e);
        }
    }

    private boolean isAuthenticationError(Error error) {
        if (error == null) {
            log.warn("isAuthenticationError", "The reported Error was null... returning false (no authentication error");
            return false;
        }
        if (this.session == null) {
            return true;
        }
        return authErrors.contains((Object)error.getErrorCode());
    }

    Channel getActiveChannel() {
        return this.activeChannel;
    }

    void setActiveChannel(Channel channel) {
        log.info("setActiveChannel", channel);
        this.activeChannel = channel;
        this.activeChannel.setRole(Channel.ChannelRole.ACTIVE);
    }

    Channel getStandbyChannel() {
        return this.standbyChannel;
    }

    void createAndConnectStandbyChannel(String server) {
        log.debug("createAndConnectStandbyChannel", "to ", server);
        this.standbyChannel = new Channel(this, Channel.ChannelRole.STANDBY, server, this.sslContextFactory);
        this.standbyChannel.connect();
    }

    void createAndConnectActiveChannel(String server) {
        log.debug("createAndConnectActiveChannel", "to ", server);
        this.activeChannel = new Channel(this, Channel.ChannelRole.ACTIVE, server, this.sslContextFactory);
        this.activeChannel.connect();
    }

    void disconnectAndClearActiveChannel() {
        log.info("disconnectAndClearActiveChannel", this.activeChannel);
        if (this.activeChannel != null) {
            this.activeChannel.disconnect();
            this.activeChannel = null;
        }
    }

    @Override
    public void onChannelStateChanged(Channel channel, ClientState state, ClientState lastState, Channel.ChannelStateInfo stateInfo) {
        if (channel == this.getActiveChannel()) {
            this.onActiveChannelStateChanged(channel, state, lastState, stateInfo);
        } else if (channel == this.getStandbyChannel()) {
            this.onStandbyChannelStateChanged(channel, state, lastState, stateInfo);
        } else {
            log.warn("onChannelStateChanged", "Not active or standby channel ", channel);
        }
    }

    public void onActiveChannelStateChanged(Channel channel, ClientState state, ClientState lastState, Channel.ChannelStateInfo stateInfo) {
        String methodName = "onActiveChannelStateChanged";
        log.info("onActiveChannelStateChanged", new Object[]{channel, " LastState=", lastState, " State=", state, " ", this});
        switch (state) {
            case CONNECTING: {
                this.updateCheckAndNotify(ClientState.CONNECTING, null);
                ++this.activeChannelConnectAttempts;
                break;
            }
            case CONNECTED: {
                this.updateCheckAndNotify(ClientState.CONNECTED, null);
                this.isHa = Utils.isNotNullAndNotEmpty(channel.getServiceConfig().remoteServer);
                if (!Utils.isNotNullAndNotEmpty(this.userId) || !Utils.isNotNullAndNotEmpty(this.password)) break;
                this.signin(channel, this.userId, this.password);
                break;
            }
            case AUTHENTICATED: {
                this.activeChannelConnectAttempts = 0L;
                if (this.isHa) {
                    if (channel.isActive()) {
                        if (this.standbyChannel == null) {
                            this.createAndConnectStandbyChannel(channel.getServiceConfig().remoteServer);
                        }
                    } else {
                        log.info("onActiveChannelStateChanged", "Authenticated ", channel, " is to the Standby server, creating active channel to remote server");
                        this.disconnectAndClearActiveChannel();
                        this.createAndConnectActiveChannel(channel.getServiceConfig().remoteServer);
                        return;
                    }
                }
                this.connectedServer = channel.getServiceConfig().localServer;
                this.updateCheckAndNotify(ClientState.AUTHENTICATED, this.calculateIsHaOperational());
                break;
            }
            case DISCONNECTED: {
                boolean sslHandshakeFailure = stateInfo.getThrowable() instanceof SSLHandshakeException;
                boolean unresolvedHost = stateInfo.getThrowable() instanceof UnresolvedAddressException;
                boolean illegalUri = stateInfo.getThrowable() instanceof URISyntaxException;
                boolean tooManyReconnectAttempts = this.activeChannelConnectAttempts > connectAttemptsGiveUpThreshold;
                boolean reconnect = (this.isHa || this.autoReconnect) && !this.hasAppRequestedDisconnect && !this.authenticationFailure && !sslHandshakeFailure && !unresolvedHost && !illegalUri && !tooManyReconnectAttempts;
                log.warn("onActiveChannelStateChanged", new Object[]{state, "Active Channel disconnected. autoReconnect?=", this.autoReconnect, " applicationRequestedDisconnect?=", this.hasAppRequestedDisconnect, " authenticationFailure?=", this.authenticationFailure, " isHa?=", this.isHa, " sslHandshakeFailure?=", sslHandshakeFailure, " unresolvedAddress?=", unresolvedHost, " illegalUri?=", illegalUri, " has exceeded maximum number of reconnect attempts?=", tooManyReconnectAttempts, " will attempt to reconnect?=", reconnect});
                this.connectedServer = null;
                if (reconnect) {
                    channel.setServerToLocalServer();
                    long reconnectDelayMillis = this.calculateReconnectDelay(this.activeChannelConnectAttempts);
                    channel.scheduleConnect(reconnectDelayMillis);
                    if (!this.isHa) {
                        this.deleteSessionAndNotify();
                    }
                    this.updateCheckAndNotify(null, this.calculateIsHaOperational());
                    break;
                }
                this.setState(ClientState.DISCONNECTED);
                this.isHaOperational = this.calculateIsHaOperational();
                this.deleteSessionAndNotify();
                ErrorCode errorCode = ErrorCode.NetworkError;
                if (this.authenticationFailure) {
                    errorCode = ErrorCode.AuthenticationFailure;
                } else if (this.hasAppRequestedDisconnect) {
                    errorCode = ErrorCode.DisconnectedByApplication;
                } else if (sslHandshakeFailure) {
                    errorCode = ErrorCode.SecureCommunicationFailure;
                } else if (unresolvedHost) {
                    errorCode = ErrorCode.UnresolvedHost;
                } else if (illegalUri) {
                    errorCode = ErrorCode.IllegalUri;
                }
                this.notify(NotificationType.ERROR, this, new Error(NotificationDescription.ObjectType.Client, errorCode, stateInfo.getMessage(), stateInfo.getCode()), null);
                this.activeChannel = null;
                break;
            }
        }
    }

    private long calculateReconnectDelay(long channelConnectsSinceLastAuthentication) {
        String methodName = "calculateReconnectDelay";
        log.debug("calculateReconnectDelay", "channelConnectsSinceLastAuthentication:", channelConnectsSinceLastAuthentication, " channelReconnectRetriesBeforeSwitchToProlongedOutageDelay:", connectAttemptsLongDelayThreshold, " channelReconnectRetriesBeforeGiveUp", connectAttemptsGiveUpThreshold);
        long reconnectDelay = 0L;
        if (channelConnectsSinceLastAuthentication < connectAttemptsLongDelayThreshold) {
            reconnectDelay = reconnectShortDelayMs;
        } else if (channelConnectsSinceLastAuthentication <= connectAttemptsGiveUpThreshold) {
            reconnectDelay = reconnectLongDelayMs;
        } else {
            log.warn("calculateReconnectDelay", "There was an issue setting the channel reconnect delay. Setting connect delay to 5000 milliseconds");
            reconnectDelay = 5000L;
        }
        log.trace("calculateReconnectDelay", "setting reconnect delay to: ", reconnectDelay);
        return reconnectDelay;
    }

    public void onStandbyChannelStateChanged(Channel channel, ClientState state, ClientState lastState, Channel.ChannelStateInfo stateInfo) {
        String methodName = "onStandbyChannelStateChanged";
        log.info("onStandbyChannelStateChanged", new Object[]{channel, " LastState=", lastState, " State=", state, " ", this});
        switch (state) {
            case CONNECTING: {
                ++this.standbyChannelConnectAttempts;
                break;
            }
            case CONNECTED: {
                if (!Utils.isNotNullAndNotEmpty(this.userId) || !Utils.isNotNullAndNotEmpty(this.password)) break;
                this.signin(channel, this.userId, this.password);
                break;
            }
            case AUTHENTICATED: {
                this.standbyChannelConnectAttempts = 0L;
                if (channel.isActive()) {
                    log.info("onStandbyChannelStateChanged", "High Availability switchover detected, transitioning ", channel, " to Active");
                    this.disconnectAndClearActiveChannel();
                    this.setActiveChannel(channel);
                    this.createAndConnectStandbyChannel(channel.getServiceConfig().remoteServer);
                    this.onActiveChannelStateChanged(channel, state, lastState, stateInfo);
                }
                this.updateCheckAndNotify(null, this.calculateIsHaOperational());
                break;
            }
            case DISCONNECTED: {
                boolean sslHandshakeFailure = stateInfo.getThrowable() instanceof SSLHandshakeException;
                boolean unresolvedHost = stateInfo.getThrowable() instanceof UnresolvedAddressException;
                boolean illegalUri = stateInfo.getThrowable() instanceof URISyntaxException;
                boolean tooManyReconnectAttempts = this.standbyChannelConnectAttempts > connectAttemptsGiveUpThreshold;
                log.debug("onStandbyChannelStateChanged", "connect attempts since auth (standby): " + this.standbyChannelConnectAttempts);
                boolean reconnect = !this.hasAppRequestedDisconnect && !this.authenticationFailure && !illegalUri && !tooManyReconnectAttempts;
                log.warn("onStandbyChannelStateChanged", new Object[]{state, "Standby channel disconnected. applicationRequestedDisconnect?=", this.hasAppRequestedDisconnect, " authenticationFailure?=", this.authenticationFailure, " sslHandshakeFailure?=", sslHandshakeFailure, " illegalUri?=", illegalUri, " unresolvedHost?=", unresolvedHost, " has Exceeded Max Number of Reconnect Attempts?=", tooManyReconnectAttempts, " will attempt to reconnect?=", reconnect});
                if (sslHandshakeFailure) {
                    log.warn("onStandbyChannelStateChanged", channel, " SSL handshake failed, verify required CA certificates are in keystore");
                }
                if (reconnect) {
                    long reconnectDelayMillis = this.calculateReconnectDelay(this.standbyChannelConnectAttempts);
                    channel.scheduleConnect(reconnectDelayMillis);
                    this.updateCheckAndNotify(null, this.calculateIsHaOperational());
                    break;
                }
                this.standbyChannel = null;
                break;
            }
        }
    }

    @Override
    public void onChannelNotification(Channel channel, Session session, NotificationType type, NotificationDescription desc, String payload) {
        String methodName = "onChannelNotification";
        if (channel != this.getActiveChannel()) {
            log.debug(methodName, channel, " not active channel, returning");
            return;
        }
        switch (desc.getObjectType()) {
            case Session: {
                this.onSessionNotification(channel, session, type, desc, payload);
                break;
            }
            case User: {
                session.onUserNotification(type, desc, payload);
                break;
            }
            case MonitoredUser: {
                session.onMonitoredUserNotification(type, desc, payload);
                break;
            }
            case Interaction: {
                session.onInteractionNotification(type, desc, payload);
                break;
            }
            case Media: {
                session.onInteractionMediaNotification(type, desc, payload);
                break;
            }
            case MonitoredInteraction: {
                session.onMonitoredInteractionNotification(type, desc, payload);
                break;
            }
            case Resource: {
                session.onResourceNotification(type, desc, payload);
                break;
            }
            case Customer: {
                session.onCustomerNotification(type, desc, payload);
                break;
            }
            default: {
                log.warn(methodName, new Object[]{"Unhandled notification, ", type, desc.toJsonString()});
            }
        }
    }

    Boolean calculateIsHaOperational() {
        return this.isHa && this.activeChannel != null && this.activeChannel.getState() == ClientState.AUTHENTICATED && this.standbyChannel != null && this.standbyChannel.getState() == ClientState.AUTHENTICATED;
    }

    void updateCheckAndNotify(ClientState state, Boolean isHaOperational) {
        boolean updated = false;
        if (state != null) {
            updated |= this.setState(state);
        }
        if (isHaOperational != null) {
            updated |= this.isHaOperational != isHaOperational;
            this.isHaOperational = isHaOperational;
        }
        if (updated) {
            this.notify(NotificationType.UPDATE, this, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void execute(Runnable task, String taskName) {
        int tasksCount = 0;
        ProcessingQueue processingQueue = this.tasks;
        synchronized (processingQueue) {
            if (Thread.currentThread().getName() == this.tasks.getName()) {
                this.tasks.add(1, new NamedRunnable(task, taskName));
            } else {
                this.tasks.add(new NamedRunnable(task, taskName));
            }
            tasksCount = this.tasks.size();
        }
        if (tasksCount == 1) {
            this.getExecutor().execute(this.tasks);
        }
    }

    @Override
    NotificationDescription.ObjectType getObjectType() {
        return NotificationDescription.ObjectType.Client;
    }

    @Override
    void markForDeletion() {
    }

    @Override
    void clearOldCachedDataBeforeUpdate() {
    }

    public String toString() {
        return "[Client ID:" + this.clientId + ",Server:" + this.server + ",IsConnected:" + this.isConnected + ",AutoReconnect:" + this.autoReconnect + ",State:" + (Object)((Object)this.state.get()) + ",IsHa:" + this.isHa + ",IsHaOperational:" + this.isHaOperational + "]";
    }

    static {
        reconnectShortDelayMs = 2000L;
        reconnectLongDelayMs = 20000L;
        connectAttemptsLongDelayThreshold = 50L;
        connectAttemptsGiveUpThreshold = 500L;
        authErrors = Collections.unmodifiableList(Arrays.asList(ErrorCode.AuthenticationFailure, ErrorCode.InvalidCredentials, ErrorCode.WorkspacesLicenseLimitExceeded, ErrorCode.WorkspacesLicenseNotGranted, ErrorCode.Unauthorized));
        propertiesFilePath = "ccs-api.properties";
        props = new Properties();
        log.info("**", "========== CCS-SDK Startup ========== ()**");
        Client.loadProperties();
        operatingSystemName = System.getProperty("os.name").replaceAll(" ", "");
        operatingSystemVersion = System.getProperty("os.version");
        operatingSystemArchitecture = System.getProperty("os.arch");
        jreVersion = System.getProperty("java.runtime.version");
        jreVendor = System.getProperty("java.vendor").replaceAll(" ", "");
        log.info("<clinit>", "[SDK Version: ", sdkVersion, "-", sdkBuild, "] [Operating System: ", operatingSystemName, " ", operatingSystemVersion, " ", operatingSystemArchitecture, "] [JRE: ", jreVersion, " ", jreVendor, "]");
        sslDisable = "true".equalsIgnoreCase(props.getProperty("ssl.disable", "false"));
        labEnvironment = "true".equalsIgnoreCase(props.getProperty("lab.environment", "false"));
        try {
            reconnectShortDelayMs = Long.parseLong(props.getProperty("channel.reconnect.short_outage_delay", "2000"));
            reconnectLongDelayMs = Long.parseLong(props.getProperty("channel.reconnect.long_outage_delay", "20000"));
            connectAttemptsLongDelayThreshold = Long.parseLong(props.getProperty("channel.reconnect.long_delay_retries_threshold", "50"));
            connectAttemptsGiveUpThreshold = Long.parseLong(props.getProperty("channel.reconnect.giveup_retries_threshold", "500"));
            log.info("<clinit>", "Initial channel reconnect time: ", reconnectShortDelayMs, "prolonged outage reconnect time: ", reconnectLongDelayMs, ". Number of channel retries before switching over to prolonged outage reconnect delay: ", connectAttemptsLongDelayThreshold, ". Number of connect retries before giving up: {}", connectAttemptsGiveUpThreshold);
        }
        catch (Exception e) {
            log.error("<clinit>", e);
        }
    }

    private class NamedRunnable {
        final String taskName;
        final Runnable task;

        NamedRunnable(Runnable task, String taskName) {
            this.task = task;
            this.taskName = taskName;
        }

        public void run() {
            try {
                this.task.run();
            }
            catch (Exception e) {
                log.error("NamedRunnable.run", e, "exception running task " + this.taskName);
            }
        }
    }

    class ProcessingQueue
    extends LinkedList<NamedRunnable>
    implements Runnable {
        private static final long serialVersionUID = 7314744282450168248L;
        private final String name;

        public ProcessingQueue() {
            this.name = Client.this.clientId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            NamedRunnable taskToRun;
            String existingThreadName = Thread.currentThread().getName();
            log.trace("ProcessingQueue.run", "executing queue ", this.name);
            ProcessingQueue processingQueue = this;
            synchronized (processingQueue) {
                taskToRun = (NamedRunnable)this.peek();
                Thread.currentThread().setName(this.name);
            }
            while (taskToRun != null) {
                String currentTaskName = taskToRun.taskName;
                log.trace("ProcessingQueue.run", "running task ", currentTaskName);
                taskToRun.run();
                ProcessingQueue processingQueue2 = this;
                synchronized (processingQueue2) {
                    this.poll();
                    taskToRun = (NamedRunnable)this.peek();
                    if (taskToRun == null) {
                        Thread.currentThread().setName(existingThreadName);
                    }
                    log.trace("ProcessingQueue.run", "task execution complete ", currentTaskName, ", ", this.name, taskToRun == null ? ", all tasks completed!" : ", tasks are remaining in queue");
                }
            }
        }

        public String getName() {
            return this.name;
        }
    }
}

