/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ccs.core;

import org.apache.logging.log4j.LogManager;

public class Logger {
    Class<?> clazz;
    org.apache.logging.log4j.Logger log;

    private Logger(Class<?> clazz) {
        this.clazz = clazz;
        this.log = LogManager.getLogger(clazz);
    }

    public static Logger getLogger(Class<?> clazz) {
        return new Logger(clazz);
    }

    private String buildMessage(String methodName, Object ... args) {
        StringBuilder builder = new StringBuilder(methodName + "() ");
        for (Object arg : args) {
            builder.append(arg);
        }
        return builder.toString();
    }

    public void trace(String methodName, Object ... args) {
        if (this.log.isTraceEnabled()) {
            this.log.trace(this.buildMessage(methodName, args));
        }
    }

    public void info(String methodName, Object ... args) {
        if (this.log.isInfoEnabled()) {
            this.log.info(this.buildMessage(methodName, args));
        }
    }

    public void debug(String methodName, Object ... args) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.buildMessage(methodName, args));
        }
    }

    public void warn(String methodName, Object ... args) {
        if (this.log.isWarnEnabled()) {
            this.log.warn(this.buildMessage(methodName, args));
        }
    }

    public void error(String methodName, Throwable t, String msg) {
        this.log.error(methodName + "() " + msg, t);
    }

    public void error(String methodName, Throwable t) {
        this.log.error(methodName + "() ", t);
    }

    public void error(String methodName, Object ... args) {
        this.log.error(this.buildMessage(methodName, args));
    }
}

