/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ccs.core;

import com.avaya.ccs.api.MonitoredInteractionI;
import com.avaya.ccs.api.MonitoredInteractionListenerI;
import com.avaya.ccs.api.MonitoredUserI;
import com.avaya.ccs.api.UserI;
import com.avaya.ccs.api.enums.Command;
import com.avaya.ccs.api.enums.ContactType;
import com.avaya.ccs.api.enums.NotificationType;
import com.avaya.ccs.api.enums.UserState;
import com.avaya.ccs.api.exceptions.InvalidArgumentException;
import com.avaya.ccs.api.exceptions.ObjectInvalidException;
import com.avaya.ccs.core.BaseUser;
import com.avaya.ccs.core.CommandArgs;
import com.avaya.ccs.core.Logger;
import com.avaya.ccs.core.MonitoredInteraction;
import com.avaya.ccs.core.NotificationDescription;
import com.avaya.ccs.core.NotificationEvent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MonitoredUser
extends BaseUser
implements MonitoredUserI {
    static Logger log = Logger.getLogger(MonitoredUser.class);
    @JsonProperty(value="SupervisorID")
    private String supervisorId;
    private Map<String, MonitoredInteraction> monitoredInteractions = Collections.synchronizedMap(new HashMap());
    private MonitoredInteractionListenerI monitoredInteractionListener;

    @Override
    public synchronized boolean canForceLogout() throws ObjectInvalidException {
        return this.isCommandAvailable(Command.ForceLogout);
    }

    @Override
    public synchronized boolean canForceNotReady() throws ObjectInvalidException {
        return this.isCommandAvailable(Command.ForceNotReady);
    }

    @Override
    public synchronized boolean canForceReady() throws ObjectInvalidException {
        return this.isCommandAvailable(Command.ForceReady);
    }

    @Override
    public synchronized List<ContactType> getContactTypes() throws ObjectInvalidException {
        return super.getContactTypes();
    }

    @Override
    public synchronized boolean hasContactType(ContactType contactType) throws ObjectInvalidException, InvalidArgumentException {
        return super.hasContactType(contactType);
    }

    @Override
    public synchronized String getSupervisorId() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.supervisorId;
    }

    @Override
    public synchronized UserI getSupervisorUser() throws ObjectInvalidException {
        this.checkForDeletion();
        return (UserI)((Object)this.parent);
    }

    @Override
    public synchronized String getFirstName() throws ObjectInvalidException {
        return super.getFirstName();
    }

    @Override
    public synchronized String getLastName() throws ObjectInvalidException {
        return super.getLastName();
    }

    @Override
    public synchronized String getFullName() throws ObjectInvalidException {
        return super.getFullName();
    }

    @Override
    public synchronized UserState getState() {
        return super.getState();
    }

    @Override
    public synchronized void forceLogout() throws ObjectInvalidException {
        this.checkForDeletion();
        this.execute(() -> {
            log.info("forceLogout", this);
            this.post(new CommandArgs(Command.ForceLogout), null);
        }, "MonitoredUser.forceLogout()");
    }

    @Override
    public synchronized void forceNotReady() throws ObjectInvalidException {
        this.checkForDeletion();
        this.execute(() -> {
            log.info("forceNotReady", this);
            this.post(new CommandArgs(Command.ForceNotReady), null);
        }, "MonitoredUser.forceNotReady()");
    }

    @Override
    public synchronized void forceReady() throws ObjectInvalidException {
        this.checkForDeletion();
        this.execute(() -> {
            log.info("forceReady", this);
            this.post(new CommandArgs(Command.ForceReady), null);
        }, "MonitoredUser.forceReady()");
    }

    @Override
    public synchronized List<MonitoredInteractionI> getMonitoredInteractions() throws ObjectInvalidException {
        this.checkForDeletion();
        if (this.monitoredInteractions == null) {
            return new ArrayList<MonitoredInteractionI>();
        }
        return new ArrayList<MonitoredInteractionI>(this.monitoredInteractions.values());
    }

    @Override
    public synchronized void monitorInteractions(MonitoredInteractionListenerI listener) throws ObjectInvalidException, InvalidArgumentException {
        this.checkForDeletion();
        if (listener == null) {
            throw new InvalidArgumentException("mandatory listener argument is null");
        }
        this.execute(() -> {
            this.monitoredInteractionListener = listener;
            log.info("monitorInteractions", this);
            this.open("/" + (Object)((Object)NotificationDescription.ObjectType.MonitoredInteraction));
        }, "MonitoredUser.monitorInteractions()");
    }

    @Override
    public synchronized void unmonitorInteractions() throws ObjectInvalidException {
        this.checkForDeletion();
        this.execute(() -> {
            this.monitoredInteractionListener = null;
            log.info("unmonitorInteractions", this);
            this.close("/" + (Object)((Object)NotificationDescription.ObjectType.MonitoredInteraction), null);
            for (MonitoredInteraction monitoredInteraction : this.monitoredInteractions.values()) {
                monitoredInteraction.markForDeletion();
                this.notify(NotificationType.DELETE, monitoredInteraction);
            }
            this.monitoredInteractions.clear();
        }, "MonitoredUser.unmonitorInteractions()");
    }

    void notify(NotificationType type, MonitoredInteraction monitoredInteraction) {
        String methodName = "notify";
        if (monitoredInteraction == null) {
            log.warn(methodName, new Object[]{type, ", MonitoredInteraction is null!"});
            return;
        }
        try {
            if (this.monitoredInteractionListener != null) {
                log.info(methodName, new Object[]{type, " ", monitoredInteraction});
                this.monitoredInteractionListener.onMonitoredInteractionEvent(new NotificationEvent<MonitoredInteractionI>(type, monitoredInteraction));
            } else {
                log.warn(methodName, new Object[]{type, " ", monitoredInteraction, ", listener is null!"});
            }
        }
        catch (Exception e) {
            log.error(methodName, e, "Executing event listener for " + monitoredInteraction + ", exception thrown from Application");
        }
    }

    void onMonitoredInteractionNotification(NotificationType type, NotificationDescription desc, String payload) {
        String methodName = "onMonitoredInteractionNotification";
        MonitoredInteraction monitoredInteraction = this.monitoredInteractions.get(desc.getObjectId());
        switch (type) {
            case NEW: 
            case UPDATE: 
            case DELETE: {
                monitoredInteraction = this.createOrUpdate(monitoredInteraction, MonitoredInteraction.class, payload, this.monitoredInteractions, this, this.client);
                log.info(methodName, new Object[]{this.client.getSession(), "\n\n", type, desc.toJsonString(), "-", monitoredInteraction.toJsonStringMaskSensitive(), "\n"});
                if (type != NotificationType.DELETE) break;
                this.delete(monitoredInteraction, this.monitoredInteractions);
                break;
            }
            default: {
                log.warn(methodName, new Object[]{this.client.getSession(), ", unhandled notification type ", type, desc.toJsonString()});
            }
        }
        this.notify(type, monitoredInteraction);
    }

    @Override
    public void markForDeletion() {
        super.markForDeletion();
        for (MonitoredInteraction monitoredInteraction : this.monitoredInteractions.values()) {
            this.delete(monitoredInteraction, this.monitoredInteractions);
            this.notify(NotificationType.DELETE, monitoredInteraction);
        }
        this.monitoredInteractions.clear();
    }

    @Override
    NotificationDescription.ObjectType getObjectType() {
        return NotificationDescription.ObjectType.MonitoredUser;
    }

    public String toString() {
        return "[MonitoredUser ID:" + this.id + ",LoginID:" + this.loginId + ",Name:" + this.firstName + " " + this.lastName + ",State:" + (Object)((Object)this.state) + ",ContactTypes:" + this.contactTypes + "]";
    }
}

