/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ccs.javafxrefclient;

import com.avaya.ccs.javafxrefclient.InteractionData;
import com.avaya.ccs.javafxrefclient.InteractionDataGUI;
import com.avaya.ccs.javafxrefclient.Logger;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class InteractionTimer {
    private static final Logger LOG = Logger.getLogger(InteractionTimer.class);
    private int timerLength = 0;
    private int currentTime = 0;
    private final Timer timer;
    private final AtomicBoolean stopping = new AtomicBoolean(false);
    private final String interactionID;
    private final InteractionDataGUI gui;

    public InteractionTimer(int timerLength, String name, String interactionID, InteractionDataGUI gui) {
        this.timerLength = timerLength;
        this.currentTime = timerLength;
        this.interactionID = interactionID;
        this.gui = gui;
        this.timer = new Timer(name + "-" + interactionID);
        this.timer.scheduleAtFixedRate((TimerTask)new InteractionTimerTask(), 100L, 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean restartTimer() {
        String methodName = "restartTimer() ";
        InteractionTimer interactionTimer = this;
        synchronized (interactionTimer) {
            if (!this.stopping.equals(true)) {
                LOG.trace(methodName + " restarting timer", new Object[0]);
                this.currentTime = this.timerLength;
                return true;
            }
            LOG.trace(methodName + " timer already stopping, don't restart", new Object[0]);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean extendTimer() {
        String methodName = "extendTimer() ";
        InteractionTimer interactionTimer = this;
        synchronized (interactionTimer) {
            if (!this.stopping.equals(true)) {
                LOG.trace(methodName + " extending timer", new Object[0]);
                this.currentTime += this.timerLength;
                return true;
            }
            LOG.trace(methodName + " timer already stopping, don't extend", new Object[0]);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopTimer() {
        String methodName = "stopTimer() ";
        LOG.trace(methodName, new Object[0]);
        InteractionTimer interactionTimer = this;
        synchronized (interactionTimer) {
            this.timer.cancel();
            this.stopping.set(true);
        }
    }

    public String getInteractionID() {
        return this.interactionID;
    }

    public abstract void executeExpiryAction();

    private class InteractionTimerTask
    extends TimerTask {
        private InteractionTimerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String methodName = "run() ";
            LOG.trace(methodName + " currentTime:" + InteractionTimer.this.currentTime, new Object[0]);
            InteractionTimerTask interactionTimerTask = this;
            synchronized (interactionTimerTask) {
                if (!InteractionTimer.this.stopping.equals(true)) {
                    InteractionData interaction = (InteractionData)InteractionTimer.this.gui.getItem(InteractionTimer.this.getInteractionID());
                    interaction.setTimeLeft(InteractionTimer.this.currentTime);
                    InteractionTimer.this.gui.UpdateInteractionData(interaction);
                    if (InteractionTimer.this.currentTime <= 0) {
                        LOG.trace(methodName + " timer expired", new Object[0]);
                        InteractionTimer.this.executeExpiryAction();
                        InteractionTimer.this.timer.cancel();
                        InteractionTimer.this.stopping.set(true);
                    }
                }
                InteractionTimer.this.currentTime--;
            }
        }
    }
}

