/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ccs.javafxrefclient;

import com.avaya.ccs.api.NotificationEventI;
import com.avaya.ccs.api.ResourceI;
import com.avaya.ccs.api.enums.NotificationType;
import com.avaya.ccs.javafxrefclient.InteractionDataGUI;
import com.avaya.ccs.javafxrefclient.Logger;
import com.avaya.ccs.javafxrefclient.ResourceData;
import com.avaya.ccs.javafxrefclient.ResourceDataGUI;
import javafx.concurrent.Task;

public class ResourceEventTask
extends Task<ResourceData> {
    private final NotificationEventI<ResourceI> resource;
    private final ResourceDataGUI gui;
    private final InteractionDataGUI interactionGui;
    private static final Logger LOG = Logger.getLogger(ResourceEventTask.class);

    public ResourceEventTask(NotificationEventI<ResourceI> resource, ResourceDataGUI gui, InteractionDataGUI interactionGui) {
        this.resource = resource;
        this.gui = gui;
        this.interactionGui = interactionGui;
        this.setupJavaFXApplicationSucceededHandler();
    }

    private void setupJavaFXApplicationSucceededHandler() {
        this.setOnSucceeded(t -> {
            String methodName = "succeededHandler() ";
            ResourceData value = (ResourceData)t.getSource().getValue();
            t.getEventType();
            if (value != null) {
                if (!value.isDeleted()) {
                    LOG.info(methodName + "ResourceData:" + value, new Object[0]);
                } else {
                    LOG.info(methodName + "Deletion of ResourceData-ID:" + value.getId(), new Object[0]);
                }
                this.gui.UpdateResourceData(value);
                this.interactionGui.handleAddressStateEvent(value);
            } else {
                LOG.debug(methodName + " NULL", new Object[0]);
            }
        });
    }

    protected ResourceData call() throws Exception {
        String methodName = "call() ";
        ResourceData data = null;
        NotificationType type = this.resource.getNotificationType();
        LOG.debug(methodName + "Type:" + type + " ID:" + ((ResourceI)this.resource.getNotificationObject()).getId(), new Object[0]);
        switch (type) {
            case UPDATE: {
                data = new ResourceData((ResourceI)this.resource.getNotificationObject());
                break;
            }
            case DELETE: {
                data = new ResourceData(null);
                break;
            }
            case ERROR: {
                LOG.errorStatus(this.resource.getError());
                break;
            }
            case NEW: {
                data = new ResourceData((ResourceI)this.resource.getNotificationObject());
                break;
            }
            case RESPONSE: {
                break;
            }
        }
        return data;
    }
}

