/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ccs.javafxrefclient;

import com.avaya.ccs.api.ContactCenterCodeI;
import com.avaya.ccs.api.MonitoredUserI;
import com.avaya.ccs.api.OffsiteStatusI;
import com.avaya.ccs.api.UserI;
import com.avaya.ccs.api.enums.ContactType;
import com.avaya.ccs.api.enums.Role;
import com.avaya.ccs.api.enums.UserState;
import com.avaya.ccs.api.enums.UserSyncStatus;
import com.avaya.ccs.api.exceptions.ObjectInvalidException;
import com.avaya.ccs.javafxrefclient.Data;
import com.avaya.ccs.javafxrefclient.Logger;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javafx.util.Pair;

public class UserData
extends Data {
    private String id = "0";
    private List<ContactType> contactTypes = new ArrayList<ContactType>();
    private List<MonitoredUserI> monitoredUsers = new ArrayList<MonitoredUserI>();
    private ContactCenterCodeI code;
    private String firstName = "";
    private String lastName = "";
    private String fullName = "";
    private String loginId = "";
    private UserState state = UserState.Unknown;
    private String supervisorName = "";
    private boolean isMultimedia = false;
    private List<Role> role = new ArrayList<Role>();
    private String voiceResource = "";
    private OffsiteStatusI offSiteStatus;
    private UserSyncStatus userSyncStatus = UserSyncStatus.Unknown;
    private String userSyncMessage = "";
    private boolean pomNailedUp = false;
    private List<String> pomZones = new ArrayList<String>();
    private boolean canAfterCallWork = false;
    private boolean canLogin = false;
    private boolean canLoginOffsite = false;
    private boolean canLogout = false;
    private boolean canMonitorUsers = false;
    private boolean canNotReady = false;
    private boolean canOriginateEmail = false;
    private boolean canReady = false;
    private boolean canRecoverOffsite = false;
    private boolean canUnmonitorUsers = false;
    private String agentSignature = null;
    private static final Logger LOG = Logger.getLogger(UserData.class);

    public UserData(UserI user) {
        String methodName = "UserData() ";
        this.role.add(Role.Unknown);
        if (user != null) {
            try {
                this.id = user.getId();
                this.contactTypes = user.getContactTypes();
                this.monitoredUsers = user.getMonitoredUsers();
                this.code = user.getCode();
                this.firstName = user.getFirstName();
                this.lastName = user.getLastName();
                this.fullName = user.getFullName();
                this.loginId = user.getLoginId();
                this.state = user.getState();
                this.supervisorName = user.getSupervisorName();
                this.isMultimedia = user.isMultimedia();
                this.role = user.getRoles();
                this.voiceResource = user.getVoiceResource();
                this.offSiteStatus = user.getOffsiteStatus();
                this.userSyncStatus = user.getUserSyncStatus();
                if (this.userSyncStatus != UserSyncStatus.NotApplicable && this.userSyncStatus != UserSyncStatus.Synchronised && this.userSyncStatus != UserSyncStatus.Unknown) {
                    this.userSyncMessage = user.getUserSyncMessage();
                }
                this.pomNailedUp = user.isPomNailedUp();
                this.pomZones = user.getPomZones();
                this.canAfterCallWork = user.canAfterCallWork();
                this.canLogin = user.canLogin();
                this.canLoginOffsite = user.canLoginOffsite();
                this.canLogout = user.canLogout();
                this.canMonitorUsers = user.canMonitorUsers();
                this.canNotReady = user.canNotReady();
                this.canOriginateEmail = user.canOriginateEmail();
                this.canReady = user.canReady();
                this.canRecoverOffsite = user.canRecoverOffsite();
                this.canUnmonitorUsers = user.canUnmonitorUsers();
            }
            catch (ObjectInvalidException ex) {
                LOG.error(methodName, new Object[]{"ObjectInvalidException while accessing user", ex});
                this.id = "0";
                this.contactTypes = new ArrayList<ContactType>();
                this.monitoredUsers = new ArrayList<MonitoredUserI>();
                this.code = null;
                this.firstName = "";
                this.lastName = "";
                this.fullName = "";
                this.loginId = "";
                this.state = UserState.Unknown;
                this.supervisorName = "";
                this.isMultimedia = false;
                this.role = new ArrayList<Role>();
                this.role.add(Role.Unknown);
                this.voiceResource = "";
                this.pomNailedUp = false;
                this.pomZones = new ArrayList<String>();
                this.userSyncStatus = UserSyncStatus.Unknown;
                this.userSyncMessage = "";
                this.canAfterCallWork = false;
                this.canLogin = false;
                this.canLoginOffsite = false;
                this.canLogout = false;
                this.canMonitorUsers = false;
                this.canNotReady = false;
                this.canReady = false;
                this.canRecoverOffsite = false;
                this.canUnmonitorUsers = false;
            }
        }
    }

    public UserData(String id, boolean deleted) {
        this.id = id;
        this.setDeleted(deleted);
    }

    @Override
    public String toString() {
        String str = "ID:" + this.id;
        str = str + " contactTypes:" + this.contactTypes + " monitoredUsers:" + this.monitoredUsers + " code:" + this.code + " firstName:" + this.firstName + " lastName:" + this.lastName + " fullName:" + this.fullName + " loginId:" + this.loginId + " state:" + this.state + " supervisorName: isMultimedia:" + this.isMultimedia + " role: voiceResource:" + this.voiceResource + " offSiteStatus:" + this.offSiteStatus + " userSyncStatus:" + this.userSyncStatus + " userSyncMessage:" + this.userSyncMessage;
        str = str + " pomNailedUp:" + this.pomNailedUp + " pomZones:";
        str = str + " canAfterCallWork:" + this.canAfterCallWork + " canLogin:" + this.canLogin + " canLoginOffsite:" + this.canLoginOffsite + " canLogout:" + this.canLogout + " canMonitorUsers:" + this.canMonitorUsers + " canNotReady:" + this.canNotReady + " canOriginateEmail: " + this.canOriginateEmail + " canReady:" + this.canReady + " canRecoverOffsite:" + this.canRecoverOffsite + " canUnmonitorUsers:" + this.canUnmonitorUsers;
        return str;
    }

    @Override
    public List<Pair<String, String>> getProperties() {
        LinkedList<Pair<String, String>> properties = new LinkedList<Pair<String, String>>();
        properties.add(new Pair((Object)"ID", (Object)this.getId()));
        properties.add(new Pair((Object)"Contact Types", (Object)this.typesToString()));
        properties.add(new Pair((Object)"Agents", (Object)this.agentsToString()));
        properties.add(new Pair((Object)"Code", (Object)this.codeToString()));
        properties.add(new Pair((Object)"First Name", (Object)this.getFirstName()));
        properties.add(new Pair((Object)"Last Name", (Object)this.getLastName()));
        properties.add(new Pair((Object)"Full Name", (Object)this.getFullName()));
        properties.add(new Pair((Object)"Login ID", (Object)this.getLoginId()));
        properties.add(new Pair((Object)"State", (Object)this.stateToString()));
        properties.add(new Pair((Object)"Multimedia", (Object)Boolean.toString(this.isMultimedia())));
        properties.add(new Pair((Object)"Roles ", (Object)this.rolesToString()));
        properties.add(new Pair((Object)"Voice Resource ", (Object)this.getVoiceResource()));
        properties.add(new Pair((Object)"POM NailedUp ", (Object)Boolean.toString(this.isPomNailedUp())));
        properties.add(new Pair((Object)"POM Zones ", (Object)this.zonesToString()));
        properties.add(new Pair((Object)"UserSyncStatus ", (Object)this.getUserSyncStatus().name()));
        properties.add(new Pair((Object)"UserSyncMessage ", (Object)this.getUserSyncMessage()));
        return properties;
    }

    @Override
    public List<Pair<String, Boolean>> getCaps() {
        LinkedList<Pair<String, Boolean>> caps = new LinkedList<Pair<String, Boolean>>();
        caps.add(new Pair((Object)"CanAfterCallWork", (Object)this.canAfterCallWork()));
        caps.add(new Pair((Object)"CanLogin", (Object)this.canLogin()));
        caps.add(new Pair((Object)"CanLoginOffsite", (Object)this.canLoginOffsite()));
        caps.add(new Pair((Object)"CanLogout", (Object)this.canLogout()));
        caps.add(new Pair((Object)"CanMonitorUsers", (Object)this.canMonitorUsers()));
        caps.add(new Pair((Object)"CanNotReady", (Object)this.canNotReady()));
        caps.add(new Pair((Object)"CanOriginateEmail", (Object)this.canOriginateEmail));
        caps.add(new Pair((Object)"CanReady", (Object)this.canReady()));
        caps.add(new Pair((Object)"CanRecoverOffsite", (Object)this.canRecoverOffsite()));
        caps.add(new Pair((Object)"CanUnmonitorUsers", (Object)this.canUnmonitorUsers()));
        return caps;
    }

    private String typesToString() {
        if (this.getContactTypes().isEmpty()) {
            return "NONE";
        }
        String types = "";
        for (ContactType type : this.getContactTypes()) {
            types = types + type.name() + " ";
        }
        return types;
    }

    private String agentsToString() {
        if (this.getMonitoredUsers().isEmpty()) {
            return "NONE";
        }
        String agentsAsString = "";
        for (MonitoredUserI agent : this.getMonitoredUsers()) {
            agentsAsString = agentsAsString + agent.toString() + " ";
        }
        return agentsAsString;
    }

    private String codeToString() {
        if (this.getCode() == null) {
            return "<NULL>";
        }
        return this.getCode().getName() + " " + this.getCode().getNumber();
    }

    private String stateToString() {
        if (this.state == null) {
            return "<NULL>";
        }
        return this.state.name();
    }

    private String rolesToString() {
        String ret = "";
        for (Role r : this.role) {
            ret = ret + r.name() + " ";
        }
        return ret;
    }

    private String zonesToString() {
        String ret = "";
        for (String zone : this.getPomZones()) {
            ret = ret + zone;
        }
        return ret;
    }

    public UserState getState() {
        return this.state;
    }

    public OffsiteStatusI getOffSiteStatus() {
        return this.offSiteStatus;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public List<ContactType> getContactTypes() {
        return this.contactTypes;
    }

    public List<MonitoredUserI> getMonitoredUsers() {
        return this.monitoredUsers;
    }

    public ContactCenterCodeI getCode() {
        return this.code;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getLoginId() {
        return this.loginId;
    }

    public String getSupervisorName() {
        return this.supervisorName;
    }

    public boolean isMultimedia() {
        return this.isMultimedia;
    }

    public boolean canAfterCallWork() {
        return this.canAfterCallWork;
    }

    public boolean canLogin() {
        return this.canLogin;
    }

    public boolean canLoginOffsite() {
        return this.canLoginOffsite;
    }

    public boolean canLogout() {
        return this.canLogout;
    }

    public boolean canMonitorUsers() {
        return this.canMonitorUsers;
    }

    public boolean canNotReady() {
        return this.canNotReady;
    }

    public boolean canOriginateEmail() {
        return this.canOriginateEmail;
    }

    public boolean canReady() {
        return this.canReady;
    }

    public boolean canRecoverOffsite() {
        return this.canRecoverOffsite;
    }

    public boolean canUnmonitorUsers() {
        return this.canUnmonitorUsers;
    }

    public boolean isPomNailedUp() {
        return this.pomNailedUp;
    }

    public List<String> getPomZones() {
        return this.pomZones;
    }

    public String getVoiceResource() {
        return this.voiceResource;
    }

    public UserSyncStatus getUserSyncStatus() {
        return this.userSyncStatus;
    }

    public String getUserSyncMessage() {
        return this.userSyncMessage;
    }

    @Override
    public void update(Data newData) {
        UserData newUserData = (UserData)newData;
        this.id = newUserData.getId();
        this.contactTypes = newUserData.getContactTypes();
        this.monitoredUsers = newUserData.getMonitoredUsers();
        this.code = newUserData.getCode();
        this.firstName = newUserData.getFirstName();
        this.lastName = newUserData.getLastName();
        this.fullName = newUserData.getFullName();
        this.loginId = newUserData.getLoginId();
        this.state = newUserData.getState();
        this.supervisorName = newUserData.getSupervisorName();
        this.isMultimedia = newUserData.isMultimedia();
        this.role = newUserData.role;
        this.voiceResource = newUserData.getVoiceResource();
        this.offSiteStatus = newUserData.getOffSiteStatus();
        this.userSyncStatus = newUserData.getUserSyncStatus();
        if (this.userSyncStatus != UserSyncStatus.NotApplicable && this.userSyncStatus != UserSyncStatus.Synchronised && this.userSyncStatus != UserSyncStatus.Unknown) {
            this.userSyncMessage = newUserData.getUserSyncMessage();
        }
        this.pomNailedUp = newUserData.isPomNailedUp();
        this.pomZones = newUserData.getPomZones();
        this.canAfterCallWork = newUserData.canAfterCallWork();
        this.canLogin = newUserData.canLogin();
        this.canLoginOffsite = newUserData.canLoginOffsite();
        this.canLogout = newUserData.canLogout();
        this.canMonitorUsers = newUserData.canMonitorUsers();
        this.canNotReady = newUserData.canNotReady();
        this.canOriginateEmail = newUserData.canOriginateEmail();
        this.canReady = newUserData.canReady();
        this.canRecoverOffsite = newUserData.canRecoverOffsite();
        this.canUnmonitorUsers = newUserData.canUnmonitorUsers();
    }

    public String getAgentSignature() {
        return this.agentSignature;
    }

    public void setAgentSignature(String agentSignature) {
        this.agentSignature = agentSignature;
    }
}

