/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ccs.core;

import com.avaya.ccs.api.ResourceI;
import com.avaya.ccs.api.SessionI;
import com.avaya.ccs.api.enums.Command;
import com.avaya.ccs.api.enums.ContactType;
import com.avaya.ccs.api.enums.ResourceState;
import com.avaya.ccs.api.enums.StateReason;
import com.avaya.ccs.api.exceptions.InvalidArgumentException;
import com.avaya.ccs.api.exceptions.ObjectInvalidException;
import com.avaya.ccs.core.BaseObject;
import com.avaya.ccs.core.CommandArgs;
import com.avaya.ccs.core.Logger;
import com.avaya.ccs.core.NotificationDescription;
import com.avaya.ccs.core.Utils;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;

public class Resource
extends BaseObject
implements ResourceI {
    private static Logger log = Logger.getLogger(Resource.class);
    @JsonProperty(value="ContactTypes")
    private List<ContactType> contactTypes;
    @JsonProperty(value="Address")
    private String address;
    @JsonProperty(value="State")
    private ResourceState state;
    @JsonProperty(value="StateReason")
    private StateReason stateReason = StateReason.Default;
    @JsonProperty(value="StateReasonMessage")
    private String stateReasonMessage;

    @Override
    public synchronized boolean canCallSupervisor() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.isCommandAvailable(Command.CallSupervisor);
    }

    @Override
    public synchronized boolean canOriginate() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.isCommandAvailable(Command.Originate);
    }

    @Override
    public synchronized String getAddress() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.address;
    }

    @Override
    public synchronized String getAddressName() throws ObjectInvalidException {
        this.checkForDeletion();
        return Utils.getUserFromUri(this.address);
    }

    @Override
    public synchronized List<ContactType> getContactTypes() throws ObjectInvalidException {
        this.checkForDeletion();
        if (this.contactTypes == null) {
            return new ArrayList<ContactType>();
        }
        return new ArrayList<ContactType>(this.contactTypes);
    }

    @Override
    public synchronized ContactType getDefaultContactType() throws ObjectInvalidException {
        this.checkForDeletion();
        List<ContactType> types = this.getContactTypes();
        if (types.isEmpty()) {
            return ContactType.Unknown;
        }
        return types.get(0);
    }

    @Override
    public synchronized SessionI getSession() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.client != null ? this.client.getSession() : null;
    }

    @Override
    public synchronized ResourceState getState() {
        return this.state;
    }

    @Override
    public synchronized StateReason getStateReason() {
        return this.stateReason;
    }

    @Override
    public synchronized String getStateReasonMessage() {
        return this.stateReasonMessage;
    }

    @Override
    public synchronized boolean hasContactType(ContactType contactType) throws ObjectInvalidException, InvalidArgumentException {
        this.checkForDeletion();
        if (contactType == null) {
            throw new InvalidArgumentException("contact type argument is null");
        }
        for (ContactType type : this.getContactTypes()) {
            if (type != contactType) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized void callSupervisor() throws ObjectInvalidException {
        this.checkForDeletion();
        this.execute(() -> {
            log.info("callSupervisor", this);
            this.post(new CommandArgs(Command.CallSupervisor), null);
        }, "Resource.callSupervisor()");
    }

    @Override
    public synchronized void originateVoiceCall(String destinationAddress, ContactType contactType) throws ObjectInvalidException, InvalidArgumentException {
        this.checkForDeletion();
        if (destinationAddress == null || destinationAddress.isEmpty()) {
            throw new InvalidArgumentException("destination address is null");
        }
        this.execute(() -> {
            log.info("originate", new Object[]{this, " dest:", destinationAddress, ", contact-type:", contactType});
            CommandArgs args = new CommandArgs(Command.Originate, destinationAddress);
            if (contactType != null) {
                args.appendArg(CommandArgs.Argument.ContactType, contactType.toString());
            }
            this.post(args, null);
        }, "Resource.originate()");
    }

    @Override
    NotificationDescription.ObjectType getObjectType() {
        return NotificationDescription.ObjectType.Resource;
    }

    @Override
    void markForDeletion() {
        this.deleted.set(true);
        this.client = null;
        this.state = ResourceState.Invalid;
    }

    @Override
    void clearOldCachedDataBeforeUpdate() {
        this.stateReason = StateReason.Default;
        this.stateReasonMessage = null;
    }

    public String toString() {
        return "[Resource ID:" + this.id + ",ContactTypes:" + this.contactTypes + ",Address:" + this.address + ",State:" + (Object)((Object)this.state) + ",Reason:" + (Object)((Object)this.stateReason) + ",ReasonMessage:" + this.stateReasonMessage + "]";
    }
}

