/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ccs.core;

import com.avaya.ccs.api.CodeListI;
import com.avaya.ccs.api.CustomerListenerI;
import com.avaya.ccs.api.EmailMediaI;
import com.avaya.ccs.api.InteractionI;
import com.avaya.ccs.api.InteractionListenerI;
import com.avaya.ccs.api.ResourceI;
import com.avaya.ccs.api.ResourceListenerI;
import com.avaya.ccs.api.ResponseData;
import com.avaya.ccs.api.SessionI;
import com.avaya.ccs.api.UserI;
import com.avaya.ccs.api.UserListenerI;
import com.avaya.ccs.api.WebChatMediaI;
import com.avaya.ccs.api.enums.CodeType;
import com.avaya.ccs.api.enums.ContactType;
import com.avaya.ccs.api.enums.NotificationType;
import com.avaya.ccs.api.exceptions.InvalidArgumentException;
import com.avaya.ccs.api.exceptions.ObjectInvalidException;
import com.avaya.ccs.core.ApprovalAuditInformation;
import com.avaya.ccs.core.ApprovalInformation;
import com.avaya.ccs.core.AutoPhrases;
import com.avaya.ccs.core.BaseObject;
import com.avaya.ccs.core.Client;
import com.avaya.ccs.core.CodeList;
import com.avaya.ccs.core.CustomFieldList;
import com.avaya.ccs.core.CustomerData;
import com.avaya.ccs.core.CustomerHistory;
import com.avaya.ccs.core.CustomerInteractionMediaList;
import com.avaya.ccs.core.CustomerList;
import com.avaya.ccs.core.DestinationList;
import com.avaya.ccs.core.EmailMedia;
import com.avaya.ccs.core.EmailReplyResponse;
import com.avaya.ccs.core.Error;
import com.avaya.ccs.core.Interaction;
import com.avaya.ccs.core.Logger;
import com.avaya.ccs.core.Media;
import com.avaya.ccs.core.NotificationDescription;
import com.avaya.ccs.core.NotificationEvent;
import com.avaya.ccs.core.OffsiteSettings;
import com.avaya.ccs.core.PagePushUrlList;
import com.avaya.ccs.core.ProtocolHandler;
import com.avaya.ccs.core.Resource;
import com.avaya.ccs.core.SuggestedResponses;
import com.avaya.ccs.core.User;
import com.avaya.ccs.core.Utils;
import com.avaya.ccs.core.WebChatMedia;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Session
extends BaseObject
implements SessionI {
    private static Logger log = Logger.getLogger(Session.class);
    @JsonProperty(value="Version")
    private String version;
    @JsonProperty(value="Active")
    private boolean isActive;
    @JsonProperty(value="NumUsers")
    private int numUsers;
    @JsonProperty(value="LastLoginTime")
    private String lastLoginTime;
    @JsonProperty(value="ACWCodes")
    private CodeList acwCodes;
    @JsonProperty(value="NRRCCodes")
    private CodeList nrrcCodes;
    private Map<String, User> users = Collections.synchronizedMap(new HashMap());
    private Map<String, Resource> resources = Collections.synchronizedMap(new HashMap());
    private Map<String, Interaction> interactions = Collections.synchronizedMap(new HashMap());
    private UserListenerI userListener;
    private ResourceListenerI resourceListener;
    private InteractionListenerI interactionListener;
    private CustomerListenerI customerListener;

    @Override
    public synchronized int getNumUsers() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.numUsers;
    }

    @Override
    public synchronized String getVersion() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.version;
    }

    @Override
    public synchronized String getLastLoginTime() throws ObjectInvalidException {
        this.checkForDeletion();
        return this.lastLoginTime;
    }

    @Override
    public synchronized CodeListI getAfterCallWorkCodes() throws ObjectInvalidException {
        this.checkForDeletion();
        if (this.acwCodes == null) {
            return new CodeList(CodeType.ACW, new HashMap<String, String>());
        }
        return this.acwCodes;
    }

    @Override
    public synchronized CodeListI getNotReadyReasonCodes() throws ObjectInvalidException {
        this.checkForDeletion();
        if (this.nrrcCodes == null) {
            return new CodeList(CodeType.NRRC, new HashMap<String, String>());
        }
        return this.nrrcCodes;
    }

    @Override
    public synchronized void openUsers(UserListenerI listener) throws InvalidArgumentException, ObjectInvalidException {
        this.checkForDeletion();
        if (listener == null) {
            throw new InvalidArgumentException("mandatory user listener argument is null");
        }
        this.execute(() -> {
            log.info("openUsers", "listener=", listener);
            this.userListener = listener;
            this.open("/" + (Object)((Object)NotificationDescription.ObjectType.User));
        }, "Session.openUsers()");
    }

    @Override
    public synchronized List<UserI> getUsers() throws ObjectInvalidException {
        this.checkForDeletion();
        if (this.users == null) {
            return new ArrayList<UserI>();
        }
        return new ArrayList<UserI>(this.users.values());
    }

    @Override
    public synchronized UserI findUser(String id) throws InvalidArgumentException, ObjectInvalidException {
        this.checkForDeletion();
        if (Utils.isNullOrEmpty(id)) {
            throw new InvalidArgumentException("id argument is null or empty");
        }
        return this.users.get(id);
    }

    @Override
    public synchronized void openResources(ResourceListenerI listener) throws ObjectInvalidException, InvalidArgumentException {
        this.checkForDeletion();
        if (listener == null) {
            throw new InvalidArgumentException("mandatory resource listener argument is null");
        }
        this.execute(() -> {
            log.debug("openResources", "listener=", listener);
            this.resourceListener = listener;
            this.open("/" + (Object)((Object)NotificationDescription.ObjectType.Resource));
        }, "Session.openResources()");
    }

    @Override
    public synchronized List<ResourceI> getResources() throws ObjectInvalidException {
        this.checkForDeletion();
        if (this.resources == null) {
            return new ArrayList<ResourceI>();
        }
        return new ArrayList<ResourceI>(this.resources.values());
    }

    @Override
    public synchronized ResourceI findResource(String id) throws ObjectInvalidException, InvalidArgumentException {
        this.checkForDeletion();
        if (Utils.isNullOrEmpty(id)) {
            throw new InvalidArgumentException("id argument is null or empty");
        }
        return this.resources.get(id);
    }

    @Override
    public synchronized void openInteractions(InteractionListenerI listener) throws ObjectInvalidException, InvalidArgumentException {
        this.checkForDeletion();
        if (listener == null) {
            throw new InvalidArgumentException("mandatory interaction listener argument is null");
        }
        this.execute(() -> {
            log.debug("openInteractions", "listener=", listener);
            this.interactionListener = listener;
            this.open("/" + (Object)((Object)NotificationDescription.ObjectType.Interaction));
        }, "Session.openInteractions()");
    }

    @Override
    public synchronized List<InteractionI> getInteractions() throws ObjectInvalidException {
        this.checkForDeletion();
        if (this.interactions == null) {
            return new ArrayList<InteractionI>();
        }
        return new ArrayList<InteractionI>(this.interactions.values());
    }

    @Override
    public synchronized InteractionI findInteraction(String id) throws ObjectInvalidException, InvalidArgumentException {
        this.checkForDeletion();
        log.debug("findInteraction(): " + id, new Object[0]);
        if (Utils.isNullOrEmpty(id)) {
            throw new InvalidArgumentException("id argument is null or empty");
        }
        return this.interactions.get(id);
    }

    @Override
    public Client getClient() {
        return this.client;
    }

    /*
     * Unable to fully structure code
     */
    void onUserNotification(NotificationType type, NotificationDescription desc, String payload) {
        methodName = "onUserNotification";
        error = null;
        responseData = null;
        user = this.users.get(desc.getObjectId());
        switch (1.$SwitchMap$com$avaya$ccs$api$enums$NotificationType[type.ordinal()]) {
            case 1: {
                user = this.createOrUpdate(user, User.class, payload, this.users, null, this.client);
            }
            case 2: 
            case 3: {
                user = this.createOrUpdate(user, User.class, payload, this.users, null, this.client);
                Session.log.debug(methodName, new Object[]{this, "\n\n", type, desc.toJsonString(), "-", user.toJsonStringMaskSensitive(), "\n"});
                if (type != NotificationType.DELETE) break;
                this.delete(user, this.users);
                break;
            }
            case 4: {
                Session.log.debug(methodName, new Object[]{this, "\n\n", type, desc.toJsonString(), payload != null ? "-" + payload : "", "\n"});
                try {
                    if (desc.getPayloadType() == NotificationDescription.PayloadType.CodeList) {
                        responseData = (ResponseData)ProtocolHandler.getJsonObjectMapper().readValue(payload, CodeList.class);
                        ** break;
                    }
                    if (desc.getPayloadType() == NotificationDescription.PayloadType.OffsiteSettings) {
                        responseData = (ResponseData)ProtocolHandler.getJsonObjectMapper().readValue(payload, OffsiteSettings.class);
                        ** break;
                    }
                    return;
lbl24:
                    // 2 sources

                }
                catch (IOException e) {
                    Session.log.error(methodName, e, "unable to deserialize json response data object");
                }
                break;
            }
            case 5: {
                if (!(desc instanceof Error)) break;
                error = (Error)desc;
                Session.log.warn(methodName, new Object[]{this, "\n\n", type, error.toJsonString(), "\n"});
                break;
            }
            default: {
                Session.log.warn(methodName, new Object[]{this, ", unhandled notification type ", type});
                return;
            }
        }
        this.notify(type, user, error, responseData);
    }

    void onMonitoredUserNotification(NotificationType type, NotificationDescription desc, String payload) {
        User supervisorUser = this.users.get(desc.getIdFromTypeInPath(NotificationDescription.ObjectType.User));
        if (supervisorUser != null) {
            supervisorUser.onMonitoredUserNotification(type, desc, payload);
        } else {
            log.error("onMonitoredUserNotification", "Unable to find User using id ", desc.getIdFromTypeInPath(NotificationDescription.ObjectType.User));
        }
    }

    void onResourceNotification(NotificationType type, NotificationDescription desc, String payload) {
        String methodName = "onResourceNotification";
        log.info(methodName, new Object[]{this, "\n\n", type, desc.toJsonString(), payload != null ? "-" + payload : "", "\n"});
        Resource resource = this.resources.get(desc.getObjectId());
        Error error = null;
        switch (type) {
            case NEW: 
            case UPDATE: 
            case DELETE: {
                resource = this.createOrUpdate(resource, Resource.class, payload, this.resources, null, this.client);
                if (type != NotificationType.DELETE) break;
                this.delete(resource, this.resources);
                break;
            }
            case RESPONSE: {
                try {
                    resource = this.createOrUpdate(resource, Resource.class, payload, this.resources, null, this.client);
                }
                catch (Exception e) {
                    log.error(methodName, e, "Unable to deserialize json response, payload: " + payload);
                }
                break;
            }
            case ERROR: {
                if (!(desc instanceof Error)) break;
                error = (Error)desc;
                break;
            }
            default: {
                log.warn(methodName, new Object[]{this, ", unhandled notification type ", type});
                return;
            }
        }
        this.notify(type, resource, error, null);
    }

    public void onCustomerNotification(NotificationType type, NotificationDescription desc, String payload) {
        String methodName = "onCustomerNotification";
        log.debug(methodName, new Object[]{this, "\n\n", type, desc.toJsonString(), payload != null ? "-" + payload : "", "\n"});
        Error error = null;
        CustomerData customer = new CustomerData();
        switch (type) {
            case NEW: 
            case UPDATE: 
            case DELETE: {
                log.warn(methodName, "unimplemented");
                break;
            }
            case RESPONSE: {
                try {
                    CustomerList customerList = (CustomerList)ProtocolHandler.getJsonObjectMapper().readValue(payload, CustomerList.class);
                    customer.setCustomerList(customerList);
                }
                catch (Exception e) {
                    log.error(methodName, e, "Unable to deserialize json response, payload: " + payload);
                }
                break;
            }
            case ERROR: {
                if (!(desc instanceof Error)) break;
                error = (Error)desc;
                break;
            }
            default: {
                log.warn(methodName, new Object[]{this, ", unhandled notification type ", type});
                return;
            }
        }
        this.notify(type, customer, error, null);
    }

    void onInteractionNotification(NotificationType type, NotificationDescription desc, String payload) {
        String methodName = "onInteractionNotification";
        Error error = null;
        ResponseData responseData = null;
        Interaction interaction = this.interactions.get(desc.getObjectId());
        switch (type) {
            case NEW: 
            case UPDATE: 
            case DELETE: {
                interaction = this.createOrUpdate(interaction, Interaction.class, payload, this.interactions, null, this.client);
                log.debug(methodName, new Object[]{this, "\n\n", type, desc.toJsonString(), "-", interaction.toJsonStringMaskSensitive(), "\n"});
                if (type != NotificationType.DELETE) break;
                this.delete(interaction, this.interactions);
                break;
            }
            case ERROR: {
                if (!(desc instanceof Error)) break;
                error = (Error)desc;
                log.warn(methodName, new Object[]{this, "\n\n", type, error.toJsonString(), "\n"});
                break;
            }
            case RESPONSE: {
                try {
                    log.debug(methodName, new Object[]{this, "\n\n", type, desc.toJsonString(), payload != null ? "-" + payload : "", "\n"});
                    if (desc.getPayloadType() == NotificationDescription.PayloadType.CodeList) {
                        CodeList codes;
                        responseData = codes = (CodeList)ProtocolHandler.getJsonObjectMapper().readValue(payload, CodeList.class);
                        if (codes.getCodeType() == CodeType.Activity) {
                            interaction.activityCodes = codes;
                            break;
                        }
                        if (codes.getCodeType() != CodeType.Disposition) break;
                        interaction.setDispositionCodes(codes);
                        break;
                    }
                    if (desc.getPayloadType() == NotificationDescription.PayloadType.DestinationList) {
                        responseData = (ResponseData)ProtocolHandler.getJsonObjectMapper().readValue(payload, DestinationList.class);
                        break;
                    }
                    if (desc.getPayloadType() == NotificationDescription.PayloadType.CustomerHistory) {
                        responseData = (ResponseData)ProtocolHandler.getJsonObjectMapper().readValue(payload, CustomerHistory.class);
                        break;
                    }
                    if (desc.getPayloadType() == NotificationDescription.PayloadType.AutoPhraseList) {
                        responseData = (ResponseData)ProtocolHandler.getJsonObjectMapper().readValue(payload, AutoPhrases.class);
                        break;
                    }
                    if (desc.getPayloadType() == NotificationDescription.PayloadType.PagePushUrlList) {
                        responseData = (ResponseData)ProtocolHandler.getJsonObjectMapper().readValue(payload, PagePushUrlList.class);
                        break;
                    }
                    if (desc.getPayloadType() == NotificationDescription.PayloadType.CustomerInteractionMediaList) {
                        responseData = (ResponseData)ProtocolHandler.getJsonObjectMapper().readValue(payload, CustomerInteractionMediaList.class);
                        break;
                    }
                    if (desc.getPayloadType() == NotificationDescription.PayloadType.CustomFieldList) {
                        responseData = (ResponseData)ProtocolHandler.getJsonObjectMapper().readValue(payload, CustomFieldList.class);
                        break;
                    }
                    if (desc.getPayloadType() == NotificationDescription.PayloadType.ApprovalInformation) {
                        responseData = (ResponseData)ProtocolHandler.getJsonObjectMapper().readValue(payload, ApprovalInformation.class);
                        break;
                    }
                    if (desc.getPayloadType() != NotificationDescription.PayloadType.ApprovalAuditInformation) break;
                    responseData = (ResponseData)ProtocolHandler.getJsonObjectMapper().readValue(payload, ApprovalAuditInformation.class);
                }
                catch (Exception e) {
                    log.error(methodName, e, "Unable to deserialize json response, payload: " + payload);
                }
                break;
            }
            default: {
                log.warn(methodName, this, ", unhandled notification type " + (Object)((Object)type));
                return;
            }
        }
        this.notify(type, interaction, error, responseData);
    }

    void onInteractionMediaNotification(NotificationType type, NotificationDescription desc, String payload) {
        String methodName = "onInteractionMediaNotification";
        Error error = null;
        ResponseData responseData = null;
        Interaction correspondingInteraction = null;
        try {
            correspondingInteraction = (Interaction)this.findInteraction(desc.getObjectId());
        }
        catch (InvalidArgumentException | ObjectInvalidException e) {
            log.error(methodName, e);
        }
        Media interactionMedia = null;
        EmailReplyResponse emailReplyResponse = null;
        switch (type) {
            case NEW: 
            case UPDATE: 
            case DELETE: {
                try {
                    if (type == NotificationType.DELETE) {
                        correspondingInteraction.setMedia(null);
                    } else {
                        if (correspondingInteraction.getContactType() == ContactType.EMail) {
                            interactionMedia = this.createOrUpdate(interactionMedia, EmailMedia.class, payload, null, null, this.client);
                        } else if (correspondingInteraction.getContactType() == ContactType.Web_Communications) {
                            interactionMedia = this.createOrUpdate(interactionMedia, WebChatMedia.class, payload, null, null, this.client);
                        }
                        correspondingInteraction.setMedia(interactionMedia);
                    }
                }
                catch (ObjectInvalidException e1) {
                    log.error(methodName, e1);
                }
                log.debug(methodName, new Object[]{this, "\n\n", type, desc.toJsonString(), "-", interactionMedia.toJsonStringMaskSensitive(), "\n"});
                break;
            }
            case ERROR: {
                if (!(desc instanceof Error)) break;
                error = (Error)desc;
                log.warn(methodName, new Object[]{this, "\n\n", type, error.toJsonString(), "\n"});
                break;
            }
            case RESPONSE: {
                try {
                    log.debug(methodName, new Object[]{this, "\n\n", type, desc.toJsonString(), payload != null ? "-" + payload : "", "\n"});
                    if (desc.getPayloadType() == NotificationDescription.PayloadType.DestinationList) {
                        responseData = (ResponseData)ProtocolHandler.getJsonObjectMapper().readValue(payload, DestinationList.class);
                        interactionMedia = (EmailMedia)correspondingInteraction.getMedia();
                        break;
                    }
                    if (desc.getPayloadType() == NotificationDescription.PayloadType.EmailReplyResponse) {
                        emailReplyResponse = (EmailReplyResponse)ProtocolHandler.getJsonObjectMapper().readValue(payload, EmailReplyResponse.class);
                        interactionMedia = (EmailMedia)correspondingInteraction.getMedia();
                        ((EmailMedia)interactionMedia).setReplyResponse(emailReplyResponse);
                        break;
                    }
                    if (desc.getPayloadType() != NotificationDescription.PayloadType.SuggestedResponseList) break;
                    interactionMedia = (EmailMedia)correspondingInteraction.getMedia();
                    responseData = (ResponseData)ProtocolHandler.getJsonObjectMapper().readValue(payload, SuggestedResponses.class);
                }
                catch (Exception e) {
                    log.error(methodName, e, "" + payload);
                }
                break;
            }
            default: {
                log.warn(methodName, this, ", unhandled notification type " + (Object)((Object)type));
                return;
            }
        }
        this.notify(type, interactionMedia, error, responseData);
    }

    void onMonitoredInteractionNotification(NotificationType type, NotificationDescription desc, String payload) {
        User supervisorUser = this.users.get(desc.getIdFromTypeInPath(NotificationDescription.ObjectType.User));
        if (supervisorUser != null) {
            supervisorUser.onMonitoredInteractionNotification(type, desc, payload);
        } else {
            log.error("onMonitoredInteractionNotification", "Unable to find User using id ", desc.getIdFromTypeInPath(NotificationDescription.ObjectType.User));
        }
    }

    ProtocolHandler getProtocolHandler() {
        return this.client.getProtocolHandler();
    }

    InteractionListenerI getInteractionListener() {
        return this.interactionListener;
    }

    void notify(NotificationType type, BaseObject object, Error error, ResponseData response) {
        String methodName = "notify";
        if (object == null) {
            log.warn(methodName, new Object[]{type, ", BaseObject is null!"});
            return;
        }
        log.debug(methodName, new Object[]{type, " ", object, error != null ? " " + error : "", response != null ? " " + response : ""});
        try {
            if (object instanceof InteractionI) {
                if (this.interactionListener != null) {
                    this.interactionListener.onInteractionEvent(new NotificationEvent<InteractionI>(type, (InteractionI)((Object)object), error, response));
                } else {
                    log.warn(methodName, "InteractionListenerI reference is null ", this);
                }
            } else if (object instanceof EmailMediaI) {
                this.interactionListener.onInteractionMediaEvent(new NotificationEvent<EmailMediaI>(type, (EmailMediaI)((Object)object), error, response));
            } else if (object instanceof WebChatMediaI) {
                this.interactionListener.onInteractionMediaEvent(new NotificationEvent<WebChatMediaI>(type, (WebChatMediaI)((Object)object), error, response));
            } else if (object instanceof UserI) {
                if (this.userListener != null) {
                    this.userListener.onUserEvent(new NotificationEvent<UserI>(type, (UserI)((Object)object), error, response));
                } else {
                    log.warn(methodName, "UserListenerI reference is null ", this);
                }
            } else if (object instanceof ResourceI) {
                if (this.resourceListener != null) {
                    this.resourceListener.onResourceEvent(new NotificationEvent<ResourceI>(type, (ResourceI)((Object)object), error, response));
                } else {
                    log.warn(methodName, "ResourceListenerI reference is null ", this);
                }
            } else {
                log.warn(methodName, this);
            }
        }
        catch (Exception e) {
            log.error("notify", e, "Executing event listener for " + object + ", exception thrown from Application");
        }
    }

    boolean isActive() {
        return this.isActive;
    }

    @Override
    void open(String targetPath) {
        if (this.client != null) {
            this.client.getProtocolHandler().send(ProtocolHandler.ProtocolRequestType.OPEN, targetPath, null, null);
        } else {
            log.warn("open", "client object is null");
        }
    }

    @Override
    public void markForDeletion() {
        this.deleted.set(true);
        this.isActive = false;
        this.client = null;
        for (User user : new ArrayList<User>(this.users.values())) {
            this.delete(user, this.users);
            this.notify(NotificationType.DELETE, user, null, null);
        }
        this.users.clear();
        for (Resource resource : new ArrayList<Resource>(this.resources.values())) {
            this.delete(resource, this.resources);
            this.notify(NotificationType.DELETE, resource, null, null);
        }
        this.resources.clear();
        for (Interaction interaction : new ArrayList<Interaction>(this.interactions.values())) {
            this.delete(interaction, this.interactions);
            this.notify(NotificationType.DELETE, interaction, null, null);
        }
        this.interactions.clear();
    }

    @Override
    void clearOldCachedDataBeforeUpdate() {
    }

    @Override
    NotificationDescription.ObjectType getObjectType() {
        return NotificationDescription.ObjectType.Session;
    }

    public String toString() {
        return "[Session ID:" + this.id + ",Version:" + this.version + ",IsActive:" + this.isActive + ",NumUsers:" + this.numUsers + ",LastLoginTime:" + this.lastLoginTime + "]";
    }
}

