/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ccs.core;

import com.avaya.ccs.api.enums.ClientState;
import com.avaya.ccs.api.enums.Command;
import com.avaya.ccs.api.enums.NotificationType;
import com.avaya.ccs.core.Client;
import com.avaya.ccs.core.CommandArgs;
import com.avaya.ccs.core.CommonResources;
import com.avaya.ccs.core.Logger;
import com.avaya.ccs.core.NotificationDescription;
import com.avaya.ccs.core.ProtocolHandler;
import com.avaya.ccs.core.ServiceConfig;
import com.avaya.ccs.core.Session;
import com.avaya.ccs.core.Utils;
import java.io.IOException;
import java.util.Locale;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class Channel {
    private static Logger log = Logger.getLogger(Channel.class);
    private ChannelRole role;
    private Client client;
    private String server;
    private SslContextFactory sslContextFactory = null;
    private ServiceConfig serviceConfig;
    private ProtocolHandler protocolHandler;
    private ClientState state = ClientState.DISCONNECTED;
    private ClientState lastState = ClientState.DISCONNECTED;
    private Session session;
    ScheduledFuture<?> scheduledConnectTask = null;

    protected Channel(Client client, ChannelRole role, String server, SslContextFactory sslContextFactory) {
        this.client = client;
        this.role = role;
        this.server = server;
        this.sslContextFactory = sslContextFactory;
        log.info("<init>", this);
    }

    protected void execute(Runnable task, String taskName) {
        this.client.execute(task, taskName);
    }

    private void setState(ClientState newState, ChannelStateInfo stateInfo) {
        if (this.state == newState) {
            return;
        }
        this.lastState = this.state;
        this.state = newState;
        if (this.state == ClientState.DISCONNECTED) {
            this.session = null;
        }
        this.getListener().onChannelStateChanged(this, this.state, this.lastState, stateInfo);
    }

    ClientState getState() {
        return this.state;
    }

    protected void setServiceConfig(ServiceConfig serviceConfig) {
        this.serviceConfig = serviceConfig;
    }

    public ServiceConfig getServiceConfig() {
        return this.serviceConfig;
    }

    private ChannelListener getListener() {
        return this.client;
    }

    ChannelRole getRole() {
        return this.role;
    }

    void setRole(ChannelRole role) {
        this.role = role;
    }

    void setServerToLocalServer() {
        if (this.serviceConfig != null && Utils.isNotNullAndNotEmpty(this.serviceConfig.localServer) && !this.serviceConfig.localServer.equalsIgnoreCase(this.server)) {
            this.server = this.serviceConfig.localServer;
            log.trace("setServerToLocalServer", this.server);
        }
    }

    protected void connect() {
        this.setState(ClientState.CONNECTING, null);
        this.protocolHandler = new ProtocolHandler(this.server, this, this.sslContextFactory);
        this.protocolHandler.connect();
    }

    protected void scheduleConnect(long delayMs) {
        String methodName = "scheduleConnect";
        log.info("scheduleConnect", new Object[]{"For ", delayMs, "ms, State=", this.state, " ", this});
        this.setState(ClientState.CONNECTING, null);
        this.scheduledConnectTask = CommonResources.getClientExecutorService().schedule(() -> {
            log.info("scheduleConnect", "Executing connect for ", this, " ", this.client);
            this.connect();
        }, delayMs, TimeUnit.MILLISECONDS);
    }

    protected void disconnect() {
        if (this.scheduledConnectTask != null) {
            log.trace("disconnect", "connect scheduled, cancelling ", this);
            this.scheduledConnectTask.cancel(true);
            this.onSocketClosed(0, "WebSocket-Simulate-Disconnect");
        } else {
            this.protocolHandler.disconnect();
        }
    }

    protected void sendRequest(ProtocolHandler.ProtocolRequestType reqType, String path, CommandArgs commandArgs, String data) {
        this.getProtocolHandler().send(reqType, path, commandArgs, data);
    }

    private void createOrUpdateSession(String payload) {
        try {
            if (this.session != null) {
                this.session = (Session)ProtocolHandler.getJsonObjectMapper().readerForUpdating((Object)this.session).readValue(payload);
            } else {
                this.session = (Session)ProtocolHandler.getJsonObjectMapper().readValue(payload, Session.class);
                this.session.setClient(this.client);
            }
        }
        catch (IOException e) {
            log.error("createOrUpdateSession", e, "Unable to deserialize session from json payload: " + payload + " " + this.toString());
        }
    }

    void deserializeAndSetServiceConfig(String payload) {
        String methodName = "deserializeAndSetServiceConfig";
        try {
            ServiceConfig config = (ServiceConfig)ProtocolHandler.getJsonObjectMapper().readValue(payload, ServiceConfig.class);
            this.setServiceConfig(config);
        }
        catch (Exception e) {
            log.error("deserializeAndSetServiceConfig", e, "Unable to deserialize service config from json payload: " + payload + " " + this.toString());
        }
    }

    void requestServiceConfig() {
        log.trace("requestServiceConfig", this, ", requesting service configuration");
        CommandArgs commandArgs = new CommandArgs(Command.GetConfiguration);
        commandArgs.appendArg(CommandArgs.Argument.Profile, this.client.getProfile().toString());
        commandArgs.appendArg(CommandArgs.Argument.Application, this.client.applicationName);
        commandArgs.appendArg(CommandArgs.Argument.SDK, "Java");
        commandArgs.appendArg(CommandArgs.Argument.Version, this.client.getVersion());
        commandArgs.appendArg(CommandArgs.Argument.Build, this.client.getSdkBuild());
        commandArgs.appendArg(CommandArgs.Argument.Platform, Client.operatingSystemName + "_v" + Client.operatingSystemVersion);
        commandArgs.appendArg(CommandArgs.Argument.Runtime, Client.jreVersion + "_" + Client.operatingSystemArchitecture + "_" + Client.jreVendor);
        commandArgs.appendArg(CommandArgs.Argument.Language, Locale.getDefault().getLanguage() + "-" + Locale.getDefault().getCountry());
        this.sendRequest(ProtocolHandler.ProtocolRequestType.GET, "/" + (Object)((Object)NotificationDescription.ObjectType.Session), commandArgs, null);
    }

    boolean isActive() {
        return this.session != null ? this.session.isActive() : false;
    }

    protected ProtocolHandler getProtocolHandler() {
        return this.protocolHandler;
    }

    public void onNotification(NotificationType type, NotificationDescription desc, String payload) {
        String methodName = "onNotification";
        log.debug(methodName, this);
        boolean notifyListeners = true;
        switch (desc.getObjectType()) {
            case Session: {
                boolean wasActive = this.isActive();
                if (type == NotificationType.NEW || type == NotificationType.UPDATE) {
                    this.createOrUpdateSession(payload);
                }
                if (type == NotificationType.NEW) {
                    this.setState(ClientState.AUTHENTICATED, null);
                    break;
                }
                if (this.state == ClientState.AUTHENTICATED && !wasActive && this.isActive()) {
                    this.getListener().onChannelStateChanged(this, ClientState.AUTHENTICATED, this.lastState, null);
                    type = NotificationType.NEW;
                    break;
                }
                if (type != NotificationType.RESPONSE || desc.getPayloadType() != NotificationDescription.PayloadType.ServiceConfig) break;
                notifyListeners = false;
                this.deserializeAndSetServiceConfig(payload);
                log.info(methodName, new Object[]{this, "\n\n", type, desc.toJsonString(), payload != null ? "-" + payload : "", "\n"});
                this.setState(ClientState.CONNECTED, null);
                break;
            }
        }
        if (notifyListeners) {
            this.getListener().onChannelNotification(this, this.session, type, desc, payload);
        }
    }

    public void onSocketConnect() {
        String methodName = "onSocketConnect";
        log.trace(methodName, this);
        this.scheduledConnectTask = null;
        this.requestServiceConfig();
    }

    public void onSocketClosed(int code, String reason) {
        String methodName = "onSocketClosed";
        log.trace(methodName, this);
        this.scheduledConnectTask = null;
        this.setState(ClientState.DISCONNECTED, new ChannelStateInfo(code, reason, null));
        this.session = null;
        this.protocolHandler = null;
    }

    public void onSocketError(Throwable t) {
        String methodName = "onSocketError";
        log.trace(methodName, this);
        this.scheduledConnectTask = null;
        if (this.getState() == ClientState.CONNECTING) {
            this.setState(ClientState.DISCONNECTED, new ChannelStateInfo(0, t.getMessage(), t));
        }
    }

    public String toString() {
        return "[Channel: " + this.server + " Role=" + (Object)((Object)this.role) + " State=" + (Object)((Object)this.state) + "]";
    }

    protected static interface ChannelListener {
        public void onChannelStateChanged(Channel var1, ClientState var2, ClientState var3, ChannelStateInfo var4);

        public void onChannelNotification(Channel var1, Session var2, NotificationType var3, NotificationDescription var4, String var5);
    }

    class ChannelStateInfo {
        int code;
        String message;
        Throwable throwable;

        ChannelStateInfo(int code, String message, Throwable throwable) {
            this.code = code;
            this.message = message;
            this.throwable = throwable;
        }

        int getCode() {
            return this.code;
        }

        String getMessage() {
            return this.message;
        }

        Throwable getThrowable() {
            return this.throwable;
        }

        public String toString() {
            return "[ChannelStateInfo: Code=" + this.code + " Message=" + this.message + "]";
        }
    }

    public static enum ChannelRole {
        ACTIVE,
        STANDBY;

    }
}

