/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ccs.core;

import com.avaya.ccs.api.WebChatMediaI;
import com.avaya.ccs.api.enums.ChatMessageType;
import com.avaya.ccs.api.enums.Command;
import com.avaya.ccs.api.enums.ContactType;
import com.avaya.ccs.api.enums.WebChatMethod;
import com.avaya.ccs.api.enums.WebChatSenderType;
import com.avaya.ccs.api.exceptions.ObjectInvalidException;
import com.avaya.ccs.core.AutoPhrases;
import com.avaya.ccs.core.ChatTranscript;
import com.avaya.ccs.core.CommandArgs;
import com.avaya.ccs.core.Media;
import com.fasterxml.jackson.annotation.JsonProperty;

public class WebChatMedia
extends Media
implements WebChatMediaI {
    @JsonProperty(value="ID")
    private String id;
    @JsonProperty(value="ContactType")
    private ContactType contactType;
    @JsonProperty(value="AgentLabel")
    private String agentLabel;
    @JsonProperty(value="CustomerLabel")
    private String customerLabel;
    @JsonProperty(value="URL")
    private String url;
    @JsonProperty(value="Method")
    private WebChatMethod method;
    @JsonProperty(value="Transcript")
    private ChatTranscript transcript;
    @JsonProperty(value="DisplayName")
    private String displayName;
    @JsonProperty(value="Message")
    private String message;
    @JsonProperty(value="MessageType")
    private ChatMessageType messageType;
    @JsonProperty(value="SenderID")
    private String senderID;
    @JsonProperty(value="SenderType")
    private WebChatSenderType senderType;
    @JsonProperty(value="Timestamp")
    private long timestamp;
    @JsonProperty(value="IsCustomerConnected")
    private boolean isCustomerConnected;
    private AutoPhrases autoPhrases;

    public AutoPhrases getAutoPhrases() {
        return this.autoPhrases;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String getAgentLabel() {
        return this.agentLabel;
    }

    public String getCustomerLabel() {
        return this.customerLabel;
    }

    public String getUrl() {
        return this.url;
    }

    public WebChatMethod getMethod() {
        return this.method;
    }

    public ChatTranscript getTranscript() {
        return this.transcript;
    }

    @Override
    public ContactType getContactType() {
        return this.contactType;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getMessage() {
        return this.message;
    }

    public ChatMessageType getMessageType() {
        return this.messageType;
    }

    public String getSenderID() {
        return this.senderID;
    }

    public WebChatSenderType getSenderType() {
        return this.senderType;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public boolean getIsCustomerConnected() {
        return this.isCustomerConnected;
    }

    public void setAutoPhrases(AutoPhrases autoPhrases) {
        this.autoPhrases = autoPhrases;
    }

    @Override
    public void sendMessage(String message, boolean isWhisper) throws ObjectInvalidException {
        this.checkForDeletion();
        String data = "{\"Message\":\"" + this.escapeForJson(message) + "\",\"IsWhisper\":" + isWhisper + "}";
        this.execute(() -> {
            log.info("sendMessage", this);
            this.postWebChatMessage(new CommandArgs(Command.NewMessage), data, this.getId());
        }, "WebChatMedia.sendMessage()");
    }

    public String toString() {
        return "WebChatMedia [id=" + this.id + ", contactType=" + (Object)((Object)this.contactType) + ", agentLabel=" + this.agentLabel + ", customerLabel=" + this.customerLabel + ", url=" + this.url + ", method=" + (Object)((Object)this.method) + ", transcript=" + this.transcript + ", displayName=" + this.displayName + ", message=" + this.message + ", messageType=" + (Object)((Object)this.messageType) + ", senderID=" + this.senderID + ", senderType=" + (Object)((Object)this.senderType) + ", timestamp=" + this.timestamp + ", autoPhrases=" + this.autoPhrases + "]";
    }

    @Override
    public String toJsonStringMaskSensitive() {
        String maskedMessage = "...";
        return "WebChatMedia [id=" + this.id + ", contactType=" + (Object)((Object)this.contactType) + ", agentLabel=" + this.agentLabel + ", customerLabel=" + this.customerLabel + ", url=" + this.url + ", method=" + (Object)((Object)this.method) + ", transcript=" + this.transcript + ", displayName=" + this.displayName + ", message=" + maskedMessage + ", messageType=" + (Object)((Object)this.messageType) + ", senderID=" + this.senderID + ", senderType=" + (Object)((Object)this.senderType) + ", timestamp=" + this.timestamp + ", autoPhrases=" + this.autoPhrases + "]";
    }

    @Override
    public void sendIsTypingRequest() throws ObjectInvalidException {
        this.checkForDeletion();
        String data = "{}";
        this.execute(() -> {
            log.info("sendIsTypingRequest", this);
            this.postWebChatMessage(new CommandArgs(Command.IsTyping), data, this.getId());
        }, "WebChatMedia.sendIsTypingRequest()");
    }

    @Override
    public void sendPagePushUrl(String url) throws ObjectInvalidException {
        this.checkForDeletion();
        String data = "{\"Url\":\"" + this.escapeForJson(url) + "\"}";
        this.execute(() -> {
            log.info("sendPagePushUrl", this);
            this.postWebChatMessage(new CommandArgs(Command.PagePush), data, this.getId());
        }, "WebChatMedia.sendPagePushUrl()");
    }
}

