/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ccs.javafxrefclient;

import com.avaya.ccs.api.ContactCenterCodeI;
import com.avaya.ccs.api.ContactNumberI;
import com.avaya.ccs.api.CustomerDetailsI;
import com.avaya.ccs.api.DataI;
import com.avaya.ccs.api.InteractionI;
import com.avaya.ccs.api.IntrinsicI;
import com.avaya.ccs.api.RemoteParticipantI;
import com.avaya.ccs.api.enums.ContactType;
import com.avaya.ccs.api.enums.DestinationType;
import com.avaya.ccs.api.enums.InteractionState;
import com.avaya.ccs.api.enums.StateReason;
import com.avaya.ccs.api.exceptions.ObjectInvalidException;
import com.avaya.ccs.core.CodeList;
import com.avaya.ccs.core.CustomFieldList;
import com.avaya.ccs.core.ScreenPop;
import com.avaya.ccs.javafxrefclient.Data;
import com.avaya.ccs.javafxrefclient.InteractionDataI;
import com.avaya.ccs.javafxrefclient.IntrinsicElement;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javafx.util.Pair;

public class InteractionData
extends Data
implements InteractionDataI {
    private boolean canAnswer = false;
    private boolean canCompleteConference = false;
    private boolean canCompleteTransfer = false;
    private boolean canEmergency = false;
    private boolean canEnd = false;
    private boolean canHold = false;
    private boolean canInitiateConference = false;
    private boolean canInitiateTransfer = false;
    private boolean canJoinConference = false;
    private boolean canPlayDTMF = false;
    private boolean canSetActivityCode = false;
    private boolean canSetUUI = false;
    private boolean canUnhold = false;
    private boolean canTransferToDestination = false;
    private boolean canAddAgentNote = false;
    private boolean canRefreshAgentNotes = false;
    private boolean canGetCallbackDestinations = false;
    private boolean canGetConsultDestinations = false;
    private boolean canGetDispositionCodes = false;
    private boolean canWrapupCall = false;
    private boolean canWrapupCallWithCode = false;
    private boolean canExtendWrapup = false;
    private boolean canCreateCallback = false;
    private boolean canPreviewDialFreeForm = false;
    private boolean canPreviewDial = false;
    private boolean canPreviewCancel = false;
    private boolean canRedial = false;
    private boolean canInitiateTransferToDestination = false;
    private boolean canInitiateConferenceToDestination = false;
    private boolean canChangeConferenceOwner = false;
    private boolean canEndConference = false;
    private boolean canEndConsult = false;
    private boolean canUpdateCustomerName = false;
    private boolean canUpdateCustomerAddress = false;
    private boolean canUpdateCustomerPhone = false;
    private boolean canUpdateCustomerEmail = false;
    private boolean canAddToDnc = false;
    private boolean canOpenMedia = false;
    private boolean canGetAutoPhrases = false;
    private boolean canGetPagePushUrls = false;
    private boolean canGetCustomerHistory = false;
    private boolean canGetActivityCodes = false;
    private ContactCenterCodeI activityCode = null;
    private String activityCodeNumber = null;
    private String address = "";
    private String addressName = "";
    private String calledAddress = "";
    private String calledAddressName = "";
    private String callingAddress = "";
    private String callingAddressName = "";
    private String contactID = "";
    private ContactType contactType = ContactType.Unknown;
    private DataI data = null;
    private String id = "";
    private List<IntrinsicElement> intrinsicsElements = new LinkedList<IntrinsicElement>();
    private String mainContactID = "";
    private String originalDestination = "";
    private String resourceID = "";
    private String skillset = "";
    private InteractionState state = InteractionState.Unknown;
    private StateReason stateReason = StateReason.Unknown;
    private String uui = "";
    private String userID = "";
    private boolean monitored = false;
    private boolean multimedia = false;
    private boolean isConsult;
    private boolean isConference;
    private StateReason participationReason = StateReason.Unknown;
    private List<RemoteParticipantI> remoteParticipants = new LinkedList<RemoteParticipantI>();
    private CustomerDetailsI customerDetails = null;
    private List<String> agentNotes = new LinkedList<String>();
    private int wrapupTimer = 0;
    private int previewTimer = 0;
    private String campaignName = "";
    private String agentScriptUrl = "";
    private List<ContactNumberI> contactNumbers = new LinkedList<ContactNumberI>();
    private List<DestinationType> consultDestinationTypes = new LinkedList<DestinationType>();
    private List<DestinationType> callbackDestinationTypes = new LinkedList<DestinationType>();
    private List<ScreenPop> screenPops = new ArrayList<ScreenPop>();
    CodeList dispositionCodes;
    CustomFieldList customFields;
    private int timeLeft = 0;

    public InteractionData(InteractionI interaction) {
        if (interaction != null) {
            try {
                this.canAnswer = interaction.canAnswer();
                this.canEmergency = interaction.canEmergency();
                this.canEnd = interaction.canEnd();
                this.canHold = interaction.canHold();
                this.canUnhold = interaction.canUnhold();
                this.canInitiateConference = interaction.canInitiateConference();
                this.canCompleteConference = interaction.canCompleteConference();
                this.canInitiateTransfer = interaction.canInitiateTransfer();
                this.canCompleteTransfer = interaction.canCompleteTransfer();
                this.canJoinConference = interaction.canJoinConference();
                this.canPlayDTMF = interaction.canPlayDTMF();
                this.canSetActivityCode = interaction.canSetActivityCode();
                this.canSetUUI = interaction.canSetUUI();
                this.canTransferToDestination = interaction.canTransferToDestination();
                this.canAddAgentNote = interaction.canAddAgentNote();
                this.canRefreshAgentNotes = interaction.canRefreshAgentNotes();
                this.canGetCallbackDestinations = interaction.canGetCallbackDestinations();
                this.canGetConsultDestinations = interaction.canGetConsultDestinations();
                this.canGetDispositionCodes = interaction.canGetDispositionCodes();
                this.canWrapupCall = interaction.canWrapup();
                this.canWrapupCallWithCode = interaction.canWrapupWithCode();
                this.canExtendWrapup = interaction.canExtendWrapup();
                this.canCreateCallback = interaction.canCreateCallback();
                this.canPreviewDialFreeForm = interaction.canPreviewDialFreeForm();
                this.canPreviewDial = interaction.canPreviewDial();
                this.canPreviewCancel = interaction.canPreviewCancel();
                this.canRedial = interaction.canRedial();
                this.canInitiateTransferToDestination = interaction.canInitiateTransferToDestination();
                this.canInitiateConferenceToDestination = interaction.canInitiateConferenceToDestination();
                this.canChangeConferenceOwner = interaction.canChangeConferenceOwner();
                this.canEndConference = interaction.canEndConference();
                this.canEndConsult = interaction.canEndConsult();
                this.canUpdateCustomerName = interaction.canUpdateCustomerName();
                this.canUpdateCustomerAddress = interaction.canUpdateCustomerAddress();
                this.canUpdateCustomerPhone = interaction.canUpdateCustomerPhone();
                this.canUpdateCustomerEmail = interaction.canUpdateCustomerEmail();
                this.canAddToDnc = interaction.canAddToDnc();
                this.canOpenMedia = interaction.canOpenMedia();
                this.canGetAutoPhrases = interaction.canGetAutoPhrases();
                this.canGetPagePushUrls = interaction.canGetPagePushUrls();
                this.canGetCustomerHistory = interaction.canGetCustomerHistory();
                this.canGetActivityCodes = interaction.canGetActivityCodes();
                this.activityCode = interaction.getActivityCode();
                if (this.activityCode != null) {
                    this.activityCodeNumber = this.activityCode.getNumber().toString();
                }
                this.address = interaction.getAddress();
                this.addressName = interaction.getAddressName();
                this.calledAddress = interaction.getCalledAddress();
                this.calledAddressName = interaction.getCalledAddressName();
                this.callingAddress = interaction.getCallingAddress();
                this.callingAddressName = interaction.getCallingAddressName();
                this.contactID = interaction.getContactId();
                this.contactType = interaction.getContactType();
                this.data = interaction.getData();
                this.id = interaction.getId();
                this.intrinsicsElements = this.buildIntrinsicsElmentList(interaction);
                this.mainContactID = interaction.getMainContactId();
                this.originalDestination = interaction.getOriginalDestination();
                this.resourceID = interaction.getResourceId();
                this.skillset = interaction.getSkillset();
                this.state = interaction.getState();
                this.stateReason = interaction.getStateReason();
                this.uui = interaction.getUUI();
                this.userID = interaction.getUserId();
                this.monitored = interaction.isMonitored();
                this.multimedia = interaction.isMultimedia();
                this.isConsult = interaction.isConsult();
                this.isConference = interaction.isConference();
                this.participationReason = interaction.getParticipationReason();
                this.remoteParticipants = interaction.getRemoteParticipants();
                this.screenPops = interaction.getScreenPops();
                this.customerDetails = interaction.getCustomerDetails();
                this.agentNotes = interaction.getAgentNotes();
                this.wrapupTimer = interaction.getWrapupTimer();
                this.previewTimer = interaction.getPreviewTimer();
                this.campaignName = interaction.getCampaignName();
                this.agentScriptUrl = interaction.getAgentScriptUrl();
                this.contactNumbers = interaction.getContactNumbers();
                this.callbackDestinationTypes = interaction.getCallbackDestinationTypes();
            }
            catch (ObjectInvalidException ex) {
                this.initializeToDefault();
            }
        }
    }

    private void initializeToDefault() {
        this.canAnswer = false;
        this.canCompleteConference = false;
        this.canCompleteTransfer = false;
        this.canEmergency = false;
        this.canEnd = false;
        this.canHold = false;
        this.canInitiateConference = false;
        this.canInitiateTransfer = false;
        this.canJoinConference = false;
        this.canPlayDTMF = false;
        this.canSetActivityCode = false;
        this.canSetUUI = false;
        this.canUnhold = false;
        this.canAddAgentNote = false;
        this.canRefreshAgentNotes = false;
        this.canGetCallbackDestinations = false;
        this.canGetConsultDestinations = false;
        this.canGetDispositionCodes = false;
        this.canWrapupCall = false;
        this.canWrapupCallWithCode = false;
        this.canExtendWrapup = false;
        this.canCreateCallback = false;
        this.canPreviewDialFreeForm = false;
        this.canPreviewDial = false;
        this.canPreviewCancel = false;
        this.canRedial = false;
        this.canInitiateTransferToDestination = false;
        this.canInitiateConferenceToDestination = false;
        this.canChangeConferenceOwner = false;
        this.canEndConference = false;
        this.canUpdateCustomerName = false;
        this.canUpdateCustomerAddress = false;
        this.canUpdateCustomerPhone = false;
        this.canUpdateCustomerEmail = false;
        this.canAddToDnc = false;
        this.activityCode = null;
        this.activityCodeNumber = null;
        this.address = "";
        this.addressName = "";
        this.calledAddress = "";
        this.calledAddressName = "";
        this.callingAddress = "";
        this.callingAddressName = "";
        this.contactID = "";
        this.contactType = ContactType.Unknown;
        this.data = null;
        this.id = "";
        this.intrinsicsElements = new LinkedList<IntrinsicElement>();
        this.mainContactID = "";
        this.originalDestination = "";
        this.resourceID = "";
        this.skillset = "";
        this.state = InteractionState.Unknown;
        this.stateReason = StateReason.Unknown;
        this.uui = "";
        this.userID = "";
        this.monitored = false;
        this.multimedia = false;
        this.isConference = false;
        this.isConsult = false;
        this.participationReason = StateReason.Unknown;
        this.remoteParticipants = new LinkedList<RemoteParticipantI>();
        this.customerDetails = null;
        this.agentNotes = new LinkedList<String>();
        this.contactNumbers = new LinkedList<ContactNumberI>();
        this.consultDestinationTypes = new LinkedList<DestinationType>();
        this.callbackDestinationTypes = new LinkedList<DestinationType>();
        this.wrapupTimer = 0;
        this.previewTimer = 0;
    }

    public InteractionData(String id, boolean deleted) {
        this.id = id;
        this.setDeleted(deleted);
    }

    @Override
    public List<Pair<String, String>> getProperties() {
        LinkedList<Pair<String, String>> properties = new LinkedList<Pair<String, String>>();
        properties.add(new Pair((Object)"ID", (Object)this.getId()));
        String actCode = "NONE";
        if (this.activityCode != null) {
            actCode = this.activityCode.getName() + ":" + this.activityCode.getNumber();
        }
        properties.add(new Pair((Object)"ActivityCode", (Object)actCode));
        properties.add(new Pair((Object)"Address", (Object)this.getAddress()));
        properties.add(new Pair((Object)"AddressName", (Object)this.getAddressName()));
        properties.add(new Pair((Object)"CalledAddress", (Object)this.getCalledAddress()));
        properties.add(new Pair((Object)"CalledAddressName", (Object)this.getCalledAddressName()));
        properties.add(new Pair((Object)"CallingAddress", (Object)this.getCalledAddress()));
        properties.add(new Pair((Object)"CallingAddressName", (Object)this.getCallingAddressName()));
        properties.add(new Pair((Object)"ContactId", (Object)this.getContactID()));
        properties.add(new Pair((Object)"ContactType", (Object)this.getContactType().name()));
        properties.add(new Pair((Object)"MainContactId", (Object)this.getMainContactID()));
        properties.add(new Pair((Object)"OriginalDestination", (Object)this.getOriginalDestination()));
        properties.add(new Pair((Object)"ResourceId", (Object)this.getResourceID()));
        properties.add(new Pair((Object)"Skillset", (Object)this.getSkillset()));
        properties.add(new Pair((Object)"UserId", (Object)this.getUserID()));
        properties.add(new Pair((Object)"isMonitored", (Object)Boolean.toString(this.isMonitored())));
        properties.add(new Pair((Object)"isMultimedia", (Object)Boolean.toString(this.isMultimedia())));
        properties.add(new Pair((Object)"State", (Object)this.getState().name()));
        properties.add(new Pair((Object)"StateReason", (Object)this.getStateReason().name()));
        properties.add(new Pair((Object)"ParticipationReason", (Object)this.getParticipationReasonString()));
        int count = 1;
        for (RemoteParticipantI participant : this.remoteParticipants) {
            properties.add(new Pair((Object)("particpant:" + count + ":Address"), (Object)participant.getAddress()));
            properties.add(new Pair((Object)("particpant:" + count + ":Reason"), (Object)participant.getReason().name()));
            properties.add(new Pair((Object)("particpant:" + count + ":State"), (Object)participant.getState().name()));
            ++count;
        }
        properties.add(new Pair((Object)"IsConsult", (Object)Boolean.toString(this.isConsult)));
        properties.add(new Pair((Object)"IsConference", (Object)Boolean.toString(this.isConference)));
        properties.add(new Pair((Object)"wrapupTimer", (Object)Integer.toString(this.getWrapupTimer())));
        properties.add(new Pair((Object)"previewTimer", (Object)Integer.toString(this.getPreviewTimer())));
        properties.add(new Pair((Object)"campaignName", (Object)this.getCampaignName()));
        properties.add(new Pair((Object)"agentScriptUrl", (Object)this.getAgentScriptUrl()));
        return properties;
    }

    @Override
    public List<Pair<String, Boolean>> getCaps() {
        LinkedList<Pair<String, Boolean>> caps = new LinkedList<Pair<String, Boolean>>();
        caps.add(new Pair((Object)"canAnswer", (Object)this.canAnswer()));
        caps.add(new Pair((Object)"canCompleteConference", (Object)this.canCompleteConference()));
        caps.add(new Pair((Object)"canCompleteTransfer", (Object)this.canCompleteTransfer()));
        caps.add(new Pair((Object)"canEmergency", (Object)this.canEmergency()));
        caps.add(new Pair((Object)"canEnd", (Object)this.canEnd()));
        caps.add(new Pair((Object)"canHold", (Object)this.canHold()));
        caps.add(new Pair((Object)"canInitiateConference", (Object)this.canInitiateConference()));
        caps.add(new Pair((Object)"canInitiateTransfer", (Object)this.canInitiateTransfer()));
        caps.add(new Pair((Object)"canJoinConference", (Object)this.canJoinConference()));
        caps.add(new Pair((Object)"canPlayDTMF", (Object)this.canPlayDTMF()));
        caps.add(new Pair((Object)"canSetActivityCode", (Object)this.canSetActivityCode()));
        caps.add(new Pair((Object)"canSetUUI", (Object)this.canSetUUI()));
        caps.add(new Pair((Object)"canUnhold", (Object)this.canUnhold()));
        caps.add(new Pair((Object)"canAddAgentNote", (Object)this.canAddAgentNote()));
        caps.add(new Pair((Object)"canRefreshAgentNotes", (Object)this.canRefreshAgentNotes()));
        caps.add(new Pair((Object)"canGetCallbackDestinations", (Object)this.canGetCallbackDestinations()));
        caps.add(new Pair((Object)"canGetConsultDestinations", (Object)this.canGetConsultDestinations()));
        caps.add(new Pair((Object)"canGetDispositionCodes", (Object)this.canGetDispositionCodes()));
        caps.add(new Pair((Object)"canWrapupCall", (Object)this.canWrapupCall()));
        caps.add(new Pair((Object)"canWrapupCallWithCode", (Object)this.canWrapupCallWithCode()));
        caps.add(new Pair((Object)"canExtendWrapup", (Object)this.canExtendWrapup()));
        caps.add(new Pair((Object)"canCreateCallback", (Object)this.canCreateCallback()));
        caps.add(new Pair((Object)"canEnterFreeFormNumber", (Object)this.canPreviewDialFreeForm()));
        caps.add(new Pair((Object)"canPreviewDial", (Object)this.canPreviewDial()));
        caps.add(new Pair((Object)"canPreviewCancel", (Object)this.canPreviewCancel()));
        caps.add(new Pair((Object)"canRedial", (Object)this.canRedial()));
        caps.add(new Pair((Object)"canInitiateTransferToDestination", (Object)this.canInitiateTransferToDestination()));
        caps.add(new Pair((Object)"canInitiateConferenceToDestination", (Object)this.canInitiateConferenceToDestination()));
        caps.add(new Pair((Object)"canChangeConferenceOwner", (Object)this.canChangeConferenceOwner()));
        caps.add(new Pair((Object)"canEndConference", (Object)this.canEndConference()));
        caps.add(new Pair((Object)"canUpdateCustomerName", (Object)this.canUpdateCustomerName()));
        caps.add(new Pair((Object)"canUpdateCustomerAddress", (Object)this.canUpdateCustomerAddress()));
        caps.add(new Pair((Object)"canUpdateCustomerPhone", (Object)this.canUpdateCustomerPhone()));
        caps.add(new Pair((Object)"canUpdateCustomerEmail", (Object)this.canUpdateCustomerEmail()));
        caps.add(new Pair((Object)"canAddToDnc", (Object)this.canAddToDnc()));
        return caps;
    }

    private List<IntrinsicElement> buildIntrinsicsElmentList(InteractionI interaction) {
        ArrayList<IntrinsicElement> l = new ArrayList<IntrinsicElement>();
        try {
            for (IntrinsicI i : interaction.getIntrinsics()) {
                l.add(new IntrinsicElement(i.getName(), i.getValue()));
            }
        }
        catch (ObjectInvalidException e) {
            return new ArrayList<IntrinsicElement>();
        }
        return l;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public boolean canAnswer() {
        return this.canAnswer;
    }

    public boolean canCompleteConference() {
        return this.canCompleteConference;
    }

    public boolean canCompleteTransfer() {
        return this.canCompleteTransfer;
    }

    public boolean canEmergency() {
        return this.canEmergency;
    }

    public boolean canEnd() {
        return this.canEnd;
    }

    public boolean canHold() {
        return this.canHold;
    }

    public boolean canInitiateConference() {
        return this.canInitiateConference;
    }

    public boolean canInitiateTransfer() {
        return this.canInitiateTransfer;
    }

    public boolean canJoinConference() {
        return this.canJoinConference;
    }

    public boolean canPlayDTMF() {
        return this.canPlayDTMF;
    }

    public boolean canSetActivityCode() {
        return this.canSetActivityCode;
    }

    @Override
    public boolean canSetUUI() {
        return this.canSetUUI;
    }

    public boolean canUnhold() {
        return this.canUnhold;
    }

    @Override
    public boolean canSetIntrinsic() {
        return this.contactType.equals((Object)ContactType.Voice);
    }

    public boolean canGetIntrinsic() {
        return this.contactType.equals((Object)ContactType.Voice);
    }

    @Override
    public boolean canGetUUI() {
        return this.contactType.equals((Object)ContactType.Voice);
    }

    @Override
    public boolean canGetData() {
        return this.contactType.equals((Object)ContactType.Voice);
    }

    @Override
    public boolean canGetCustomerDetails() {
        return true;
    }

    public ContactCenterCodeI getActivityCode() {
        return this.activityCode;
    }

    public String getAddress() {
        return this.address;
    }

    public String getAddressName() {
        return this.addressName;
    }

    public String getCalledAddress() {
        return this.calledAddress;
    }

    public String getCalledAddressName() {
        return this.calledAddressName;
    }

    public String getCallingAddress() {
        return this.callingAddress;
    }

    public String getCallingAddressName() {
        return this.callingAddressName;
    }

    public String getContactID() {
        return this.contactID;
    }

    public ContactType getContactType() {
        return this.contactType;
    }

    @Override
    public DataI getData() {
        return this.data;
    }

    @Override
    public List<IntrinsicElement> getIntrinsics() {
        return this.intrinsicsElements;
    }

    public String getMainContactID() {
        return this.mainContactID;
    }

    public String getOriginalDestination() {
        return this.originalDestination;
    }

    public String getResourceID() {
        return this.resourceID;
    }

    public String getSkillset() {
        return this.skillset;
    }

    public InteractionState getState() {
        return this.state;
    }

    public StateReason getStateReason() {
        return this.stateReason;
    }

    public String getCombinedState() {
        String combinedValue = this.state.toString();
        switch (this.state) {
            case Preview: 
            case Wrapup: {
                if (this.timeLeft <= 0) break;
                combinedValue = combinedValue + "(" + Integer.toString(this.timeLeft) + ")";
                break;
            }
        }
        return combinedValue;
    }

    @Override
    public String getUui() {
        return this.uui;
    }

    public String getUserID() {
        return this.userID;
    }

    public String getActivityCodeNumber() {
        return this.activityCodeNumber;
    }

    @Override
    public boolean canAddAgentNote() {
        return this.canAddAgentNote;
    }

    public boolean canRefreshAgentNotes() {
        return this.canRefreshAgentNotes;
    }

    public boolean canGetCallbackDestinations() {
        return this.canGetCallbackDestinations;
    }

    public boolean canGetConsultDestinations() {
        return this.canGetConsultDestinations;
    }

    public boolean canGetDispositionCodes() {
        return this.canGetDispositionCodes;
    }

    public boolean canGetActivityCodes() {
        return this.canGetActivityCodes;
    }

    public boolean canWrapupCall() {
        return this.canWrapupCall;
    }

    public boolean canWrapupCallWithCode() {
        return this.canWrapupCallWithCode;
    }

    public boolean canExtendWrapup() {
        return this.canExtendWrapup;
    }

    public boolean canCreateCallback() {
        return this.canCreateCallback;
    }

    public boolean canPreviewDialFreeForm() {
        return this.canPreviewDialFreeForm;
    }

    public boolean canPreviewDial() {
        return this.canPreviewDial;
    }

    public boolean canPreviewCancel() {
        return this.canPreviewCancel;
    }

    public boolean canRedial() {
        return this.canRedial;
    }

    public boolean canInitiateTransferToDestination() {
        return this.canInitiateTransferToDestination;
    }

    public boolean canInitiateConferenceToDestination() {
        return this.canInitiateConferenceToDestination;
    }

    public boolean canChangeConferenceOwner() {
        return this.canChangeConferenceOwner;
    }

    public boolean canEndConference() {
        return this.canEndConference;
    }

    public boolean canEndConsult() {
        return this.canEndConsult;
    }

    @Override
    public boolean canUpdateCustomerName() {
        return this.canUpdateCustomerName;
    }

    @Override
    public boolean canUpdateCustomerAddress() {
        return this.canUpdateCustomerAddress;
    }

    @Override
    public boolean canUpdateCustomerPhone() {
        return this.canUpdateCustomerPhone;
    }

    @Override
    public boolean canUpdateCustomerEmail() {
        return this.canUpdateCustomerEmail;
    }

    public boolean canAddToDnc() {
        return this.canAddToDnc;
    }

    public boolean canOpenMedia() {
        return this.canOpenMedia;
    }

    public boolean canGetAutoPhrases() {
        return this.canGetAutoPhrases;
    }

    public boolean canGetPagePushUrls() {
        return this.canGetPagePushUrls;
    }

    public boolean canGetCustomerHistory() {
        return this.canGetCustomerHistory;
    }

    public boolean isMonitored() {
        return this.monitored;
    }

    @Override
    public boolean isMultimedia() {
        return this.multimedia;
    }

    public boolean isConference() {
        return this.isConference;
    }

    public boolean isConsult() {
        return this.isConsult;
    }

    public StateReason getParticipationReason() {
        return this.participationReason;
    }

    public List<RemoteParticipantI> getRemoteParticipants() {
        return this.remoteParticipants;
    }

    @Override
    public CustomerDetailsI getCustomerDetails() {
        return this.customerDetails;
    }

    public List<ScreenPop> getScreenPops() {
        return this.screenPops;
    }

    @Override
    public List<String> getAgentNotes() {
        return this.agentNotes;
    }

    public int getPreviewTimer() {
        return this.previewTimer;
    }

    public int getWrapupTimer() {
        return this.wrapupTimer;
    }

    public String getCampaignName() {
        return this.campaignName;
    }

    public String getAgentScriptUrl() {
        return this.agentScriptUrl;
    }

    public List<ContactNumberI> getContactNumbers() {
        return this.contactNumbers;
    }

    public ContactNumberI getDefaultOrFirstContactNumber() {
        for (ContactNumberI number : this.getContactNumbers()) {
            if (!number.isDefault()) continue;
            return number;
        }
        return this.getContactNumbers().get(0);
    }

    public List<DestinationType> getConsultDestinationTypes() {
        return this.consultDestinationTypes;
    }

    public List<DestinationType> getCallbackDestinationTypes() {
        return this.callbackDestinationTypes;
    }

    public String getParticipationReasonString() {
        if (this.getParticipationReason() == null) {
            return StateReason.Unknown.name();
        }
        return this.getParticipationReason().name();
    }

    public void setTimeLeft(int timeLeft) {
        this.timeLeft = timeLeft;
    }

    public int getTimeLeft() {
        return this.timeLeft;
    }

    public CodeList getDispositionCodes() {
        return this.dispositionCodes;
    }

    public void setDispositionCodes(CodeList dispositionCodes) {
        this.dispositionCodes = dispositionCodes;
    }

    public CustomFieldList getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(CustomFieldList customFields) {
        this.customFields = customFields;
    }

    @Override
    public void update(Data newData) {
        InteractionData newInteractionData = (InteractionData)newData;
        this.canAnswer = newInteractionData.canAnswer();
        this.canCompleteConference = newInteractionData.canCompleteConference();
        this.canCompleteTransfer = newInteractionData.canCompleteTransfer();
        this.canEmergency = newInteractionData.canEmergency();
        this.canEnd = newInteractionData.canEnd();
        this.canHold = newInteractionData.canHold();
        this.canInitiateConference = newInteractionData.canInitiateConference();
        this.canInitiateTransfer = newInteractionData.canInitiateTransfer();
        this.canJoinConference = newInteractionData.canJoinConference();
        this.canPlayDTMF = newInteractionData.canPlayDTMF();
        this.canSetActivityCode = newInteractionData.canSetActivityCode();
        this.canSetUUI = newInteractionData.canSetUUI();
        this.canUnhold = newInteractionData.canUnhold();
        this.canAddAgentNote = newInteractionData.canAddAgentNote();
        this.canRefreshAgentNotes = newInteractionData.canRefreshAgentNotes();
        this.canGetCallbackDestinations = newInteractionData.canGetCallbackDestinations();
        this.canGetConsultDestinations = newInteractionData.canGetConsultDestinations();
        this.canGetDispositionCodes = newInteractionData.canGetDispositionCodes();
        this.canWrapupCall = newInteractionData.canWrapupCall();
        this.canWrapupCallWithCode = newInteractionData.canWrapupCallWithCode();
        this.canExtendWrapup = newInteractionData.canExtendWrapup();
        this.canCreateCallback = newInteractionData.canCreateCallback();
        this.canPreviewDialFreeForm = newInteractionData.canPreviewDialFreeForm();
        this.canPreviewDial = newInteractionData.canPreviewDial();
        this.canPreviewCancel = newInteractionData.canPreviewCancel();
        this.canRedial = newInteractionData.canRedial();
        this.canInitiateTransferToDestination = newInteractionData.canInitiateTransferToDestination();
        this.canInitiateConferenceToDestination = newInteractionData.canInitiateConferenceToDestination();
        this.canChangeConferenceOwner = newInteractionData.canChangeConferenceOwner();
        this.canEndConference = newInteractionData.canEndConference();
        this.canUpdateCustomerName = newInteractionData.canUpdateCustomerName();
        this.canUpdateCustomerAddress = newInteractionData.canUpdateCustomerAddress();
        this.canUpdateCustomerPhone = newInteractionData.canUpdateCustomerPhone();
        this.canUpdateCustomerEmail = newInteractionData.canUpdateCustomerEmail();
        this.canAddToDnc = newInteractionData.canAddToDnc();
        this.activityCode = newInteractionData.getActivityCode();
        this.activityCodeNumber = newInteractionData.getActivityCodeNumber();
        this.address = newInteractionData.getAddress();
        this.addressName = newInteractionData.getAddressName();
        this.calledAddress = newInteractionData.getCalledAddress();
        this.calledAddressName = newInteractionData.getCalledAddressName();
        this.callingAddress = newInteractionData.getCallingAddress();
        this.callingAddressName = newInteractionData.getCallingAddressName();
        this.contactID = newInteractionData.getContactID();
        this.contactType = newInteractionData.getContactType();
        this.data = newInteractionData.getData();
        this.id = newInteractionData.getId();
        this.intrinsicsElements = newInteractionData.getIntrinsics();
        this.mainContactID = newInteractionData.getMainContactID();
        this.originalDestination = newInteractionData.getOriginalDestination();
        this.resourceID = newInteractionData.getResourceID();
        this.skillset = newInteractionData.getSkillset();
        this.state = newInteractionData.getState();
        this.stateReason = newInteractionData.getStateReason();
        this.uui = newInteractionData.getUui();
        this.userID = newInteractionData.getUserID();
        this.monitored = newInteractionData.isMonitored();
        this.multimedia = newInteractionData.isMultimedia();
        this.participationReason = newInteractionData.getParticipationReason();
        this.remoteParticipants = newInteractionData.getRemoteParticipants();
        this.isConsult = newInteractionData.isConsult();
        this.isConference = newInteractionData.isConference();
        this.customerDetails = newInteractionData.getCustomerDetails();
        this.agentNotes = newInteractionData.getAgentNotes();
        this.wrapupTimer = newInteractionData.getWrapupTimer();
        this.previewTimer = newInteractionData.getPreviewTimer();
        this.campaignName = newInteractionData.getCampaignName();
        this.agentScriptUrl = newInteractionData.getAgentScriptUrl();
        this.contactNumbers = newInteractionData.getContactNumbers();
        this.consultDestinationTypes = newInteractionData.getConsultDestinationTypes();
        this.callbackDestinationTypes = newInteractionData.getCallbackDestinationTypes();
        this.timeLeft = newInteractionData.getTimeLeft();
        newInteractionData.getDispositionCodes();
    }
}

