/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ccs.javafxrefclient;

import com.avaya.ccs.api.ApprovalAuditInformationI;
import com.avaya.ccs.api.ApprovalInformationI;
import com.avaya.ccs.api.AutoPhrasesI;
import com.avaya.ccs.api.CodeListI;
import com.avaya.ccs.api.CustomFieldListI;
import com.avaya.ccs.api.CustomerHistoryI;
import com.avaya.ccs.api.DestinationListI;
import com.avaya.ccs.api.InteractionI;
import com.avaya.ccs.api.NotificationEventI;
import com.avaya.ccs.api.PagePushUrlListI;
import com.avaya.ccs.api.ResponseData;
import com.avaya.ccs.api.enums.CodeType;
import com.avaya.ccs.api.enums.ContactType;
import com.avaya.ccs.api.enums.InteractionState;
import com.avaya.ccs.api.enums.NotificationType;
import com.avaya.ccs.api.enums.StateReason;
import com.avaya.ccs.api.exceptions.ObjectInvalidException;
import com.avaya.ccs.core.ApprovalAuditInformation;
import com.avaya.ccs.core.ApprovalInformation;
import com.avaya.ccs.core.CustomerHistory;
import com.avaya.ccs.core.CustomerInteractionMediaList;
import com.avaya.ccs.javafxrefclient.InteractionData;
import com.avaya.ccs.javafxrefclient.InteractionDataGUI;
import com.avaya.ccs.javafxrefclient.InteractionExecutor;
import com.avaya.ccs.javafxrefclient.Logger;
import com.avaya.ccs.javafxrefclient.SupervisorDataGUI;
import com.avaya.ccs.javafxrefclient.WebchatForm;
import javafx.application.Platform;
import javafx.concurrent.Task;

public class InteractionEventTask
extends Task<Object> {
    private final NotificationEventI<InteractionI> interactionEvent;
    private final InteractionDataGUI gui;
    private final SupervisorDataGUI superGui;
    private static final Logger LOG = Logger.getLogger(InteractionEventTask.class);
    InteractionExecutor interactionExecutor;

    public InteractionEventTask(NotificationEventI<InteractionI> interactionEvent, InteractionDataGUI gui, SupervisorDataGUI gui2, InteractionExecutor interactionExecutor) {
        this.interactionEvent = interactionEvent;
        this.gui = gui;
        this.superGui = gui2;
        this.interactionExecutor = interactionExecutor;
        this.setupJavaFXApplicationSucceededHandler();
    }

    private void setupJavaFXApplicationSucceededHandler() {
        this.setOnSucceeded(t -> {
            block56: {
                String methodName = "succeededHandler() ";
                Object value = t.getSource().getValue();
                if (value == null) {
                    LOG.debug(methodName + "NULL", new Object[0]);
                } else if (value instanceof InteractionData) {
                    InteractionData newData = (InteractionData)value;
                    if (!newData.isDeleted()) {
                        LOG.info(methodName + "InteractionData:" + newData, new Object[0]);
                    } else {
                        LOG.info(methodName + "Deletion of InteractionData-ID:" + newData.getId(), new Object[0]);
                    }
                    this.gui.UpdateInteractionData(newData);
                    this.superGui.updateInteraction(newData);
                    if (newData.getState() == InteractionState.Initiated && newData.getContactType() == ContactType.EMail) {
                        this.interactionExecutor.openInteractionMedia(newData.getId());
                    }
                } else if (value instanceof CodeListI) {
                    CodeListI codes = (CodeListI)value;
                    LOG.info(methodName + "CodeListI:" + codes, new Object[0]);
                    this.gui.updateCodeSectionForm(codes);
                    InteractionI thisInteraction = (InteractionI)this.interactionEvent.getNotificationObject();
                    try {
                        if (thisInteraction.getContactType() == ContactType.EMail) {
                            if (codes.getCodeType() == CodeType.Activity) {
                                this.gui.getEmailFormForContact(thisInteraction.getId()).setActivityCodes(codes);
                            } else if (codes.getCodeType() == CodeType.Disposition) {
                                this.gui.getEmailFormForContact(thisInteraction.getId()).setDispositionCodes(codes);
                            }
                        } else if (thisInteraction.getContactType() == ContactType.Web_Communications) {
                            WebchatForm form = null;
                            form = thisInteraction.getStateReason() == StateReason.BargeIn || thisInteraction.getStateReason() == StateReason.Observe ? this.superGui.getWebChatFormForContact(thisInteraction.getId()) : this.gui.getWebChatFormForContact(thisInteraction.getId());
                            if (codes.getCodeType() == CodeType.Disposition) {
                                form.setDispositionCodes(codes);
                            } else if (codes.getCodeType() == CodeType.Activity) {
                                form.setActivityCodes(codes);
                            }
                        }
                    }
                    catch (ObjectInvalidException e) {
                        LOG.error(methodName, e);
                    }
                } else if (value instanceof DestinationListI) {
                    DestinationListI destinations = (DestinationListI)value;
                    LOG.info(methodName + "DestinationListI:" + destinations, new Object[0]);
                    InteractionI interaction = (InteractionI)this.interactionEvent.getNotificationObject();
                    try {
                        if (interaction.getContactType() == ContactType.EMail) {
                            if (interaction.getState() == InteractionState.Initiated) {
                                this.gui.getEmailFormForContact(interaction.getId()).setOriginators(destinations);
                            }
                            this.gui.getEmailFormForContact(interaction.getId()).getConsultForm().updateDestinationList(((InteractionI)this.interactionEvent.getNotificationObject()).getId(), destinations);
                            break block56;
                        }
                        if (interaction.getContactType() == ContactType.Web_Communications) {
                            this.gui.getWebChatFormForContact(interaction.getId()).getConsultForm().updateDestinationList(((InteractionI)this.interactionEvent.getNotificationObject()).getId(), destinations);
                            break block56;
                        }
                        this.gui.getConsultForm().updateDestinationList(((InteractionI)this.interactionEvent.getNotificationObject()).getId(), destinations);
                    }
                    catch (ObjectInvalidException e) {
                        LOG.error(methodName, e);
                    }
                } else if (value instanceof CustomerHistoryI) {
                    try {
                        CustomerHistory custHistory = (CustomerHistory)value;
                        LOG.info(methodName + "CustomerHistory:" + custHistory, new Object[0]);
                        InteractionI thisInteraction = (InteractionI)this.interactionEvent.getNotificationObject();
                        if (((InteractionI)this.interactionEvent.getNotificationObject()).getContactType() == ContactType.Web_Communications) {
                            this.gui.getWebChatFormForContact(thisInteraction.getId()).setCustomerHistory((CustomerHistoryI)custHistory);
                            this.gui.getWebChatFormForContact(((InteractionI)this.interactionEvent.getNotificationObject()).getId()).updateForm();
                        } else if (((InteractionI)this.interactionEvent.getNotificationObject()).getContactType() == ContactType.EMail && ((InteractionI)this.interactionEvent.getNotificationObject()).getContactType() == ContactType.EMail) {
                            this.gui.getEmailFormForContact(thisInteraction.getId()).setCustomerHistory((CustomerHistoryI)custHistory);
                            this.gui.getEmailFormForContact(((InteractionI)this.interactionEvent.getNotificationObject()).getId()).updateForm();
                        }
                    }
                    catch (ObjectInvalidException e) {
                        LOG.error(methodName, e);
                    }
                } else if (value instanceof CustomerInteractionMediaList) {
                    try {
                        if (((InteractionI)this.interactionEvent.getNotificationObject()).getContactType() == ContactType.EMail) {
                            this.gui.getEmailFormForContact(((InteractionI)this.interactionEvent.getNotificationObject()).getId()).setCustomerInteractionMediaList((CustomerInteractionMediaList)value);
                        } else if (((InteractionI)this.interactionEvent.getNotificationObject()).getContactType() == ContactType.Web_Communications) {
                            this.gui.getWebChatFormForContact(((InteractionI)this.interactionEvent.getNotificationObject()).getId()).setCustomerInteractionMediaList((CustomerInteractionMediaList)value);
                        }
                    }
                    catch (ObjectInvalidException e) {
                        LOG.error("Ex.", e);
                    }
                } else if (value instanceof CustomFieldListI) {
                    CustomFieldListI customFields = (CustomFieldListI)value;
                    LOG.info(methodName + "CustomFieldListI:" + customFields, new Object[0]);
                    this.gui.getSideBar().updateCustomFields(customFields);
                } else if (value instanceof PagePushUrlListI) {
                    this.gui.getWebChatFormForContact(((InteractionI)this.interactionEvent.getNotificationObject()).getId()).setPagePushUrls((PagePushUrlListI)value);
                } else if (value instanceof AutoPhrasesI) {
                    this.gui.getWebChatFormForContact(((InteractionI)this.interactionEvent.getNotificationObject()).getId()).setAutoPhrases((AutoPhrasesI)value);
                } else if (value instanceof ApprovalInformationI) {
                    ApprovalInformation approvalInfo = (ApprovalInformation)value;
                    try {
                        if (((InteractionI)this.interactionEvent.getNotificationObject()).getContactType() == ContactType.EMail) {
                            InteractionI thisInteraction = (InteractionI)this.interactionEvent.getNotificationObject();
                            this.gui.getEmailFormForContact(thisInteraction.getId()).setIsForAudit(approvalInfo);
                            this.gui.getEmailFormForContact(((InteractionI)this.interactionEvent.getNotificationObject()).getId()).updateForm();
                        }
                    }
                    catch (ObjectInvalidException e) {
                        LOG.error(methodName, e);
                    }
                } else if (value instanceof ApprovalAuditInformationI) {
                    ApprovalAuditInformation approvalAuditInfo = (ApprovalAuditInformation)value;
                    try {
                        if (((InteractionI)this.interactionEvent.getNotificationObject()).getContactType() == ContactType.EMail) {
                            InteractionI thisInteraction = (InteractionI)this.interactionEvent.getNotificationObject();
                            this.gui.getEmailFormForContact(thisInteraction.getId()).addApprovalId(approvalAuditInfo);
                            this.gui.getEmailFormForContact(((InteractionI)this.interactionEvent.getNotificationObject()).getId()).updateForm();
                        }
                    }
                    catch (ObjectInvalidException e) {
                        LOG.error(methodName, e);
                    }
                }
            }
        });
    }

    protected Object call() throws Exception {
        InteractionData data;
        block39: {
            String methodName = "call() ";
            data = null;
            NotificationType type = this.interactionEvent.getNotificationType();
            LOG.debug(methodName + "Type:" + type + " ID:" + ((InteractionI)this.interactionEvent.getNotificationObject()).getId(), new Object[0]);
            this.gui.redrawControls();
            block1 : switch (type) {
                case UPDATE: {
                    data = new InteractionData((InteractionI)this.interactionEvent.getNotificationObject());
                    switch (data.getState()) {
                        case Wrapup: {
                            if (data.getWrapupTimer() < 0) break block1;
                            LOG.debug(methodName + " create wrapup timer if not already running", new Object[0]);
                            InteractionExecutor.getTimers().startWrapUp(data.getWrapupTimer(), data.getId(), this.gui);
                            data.setTimeLeft(data.getWrapupTimer());
                            break block1;
                        }
                        case Active: {
                            if (((InteractionI)this.interactionEvent.getNotificationObject()).isMultimedia()) {
                                LOG.debug(methodName + " canOpenMedia: " + data.canOpenMedia(), new Object[0]);
                                if (data.canOpenMedia()) {
                                    this.interactionExecutor.openInteractionMedia(((InteractionI)this.interactionEvent.getNotificationObject()).getId());
                                }
                                String id = ((InteractionI)this.interactionEvent.getNotificationObject()).getId();
                                if (data.getContactType() == ContactType.Web_Communications) {
                                    WebchatForm form = null;
                                    form = data.getStateReason() == StateReason.BargeIn || data.getStateReason() == StateReason.Observe ? this.superGui.getWebChatFormForContact(id) : this.gui.getWebChatFormForContact(id);
                                    if (form == null) {
                                        LOG.debug(methodName + " no form found for id: " + id, new Object[0]);
                                        if (data.getStateReason() == StateReason.ConferenceComplete) {
                                            this.gui.createAndAddNewWebchatForm(data.getId());
                                            form = this.gui.getWebChatFormForContact(data.getId());
                                            LOG.debug("got the form? " + (form == null), new Object[0]);
                                            form.setInteractionData(data);
                                        }
                                    }
                                    LOG.info(methodName + "form interactionId: " + form.getInteractionId(), new Object[0]);
                                    try {
                                        if (form.isInteractionDataSet()) {
                                            form.updateInteractionData(data);
                                        } else {
                                            form.setInteractionData(data);
                                        }
                                    }
                                    catch (Exception e) {
                                        LOG.error(methodName, e);
                                    }
                                }
                            }
                            return data;
                        }
                        case Dropped: {
                            LOG.debug(methodName + " InteractionEventTask case Dropped", new Object[0]);
                            data = new InteractionData(((InteractionI)this.interactionEvent.getNotificationObject()).getId(), true);
                            InteractionExecutor.getTimers().stop(((InteractionI)this.interactionEvent.getNotificationObject()).getId());
                            break block1;
                        }
                        case Held: {
                            LOG.debug(methodName + " InteractionEventTask case Held", new Object[0]);
                            data = new InteractionData((InteractionI)this.interactionEvent.getNotificationObject());
                            WebchatForm form = this.gui.getWebChatFormForContact(((InteractionI)this.interactionEvent.getNotificationObject()).getId());
                            if (form != null) {
                                form.updateInteractionData(data);
                            }
                            InteractionExecutor.getTimers().stop(((InteractionI)this.interactionEvent.getNotificationObject()).getId());
                            break block1;
                        }
                    }
                    InteractionExecutor.getTimers().stop(((InteractionI)this.interactionEvent.getNotificationObject()).getId());
                    break;
                }
                case DELETE: {
                    if (((InteractionI)this.interactionEvent.getNotificationObject()).getStateReason().equals((Object)StateReason.ConferenceComplete) && ((InteractionI)this.interactionEvent.getNotificationObject()).getState().equals((Object)InteractionState.Dropped)) {
                        WebchatForm thisForm = this.gui.getWebChatFormForContact(((InteractionI)this.interactionEvent.getNotificationObject()).getId());
                        Platform.runLater(() -> thisForm.close());
                    } else if (((InteractionI)this.interactionEvent.getNotificationObject()).getStateReason() == StateReason.TransferComplete) {
                        LOG.debug("DELETE and TransferComplete: will close the form", new Object[0]);
                        WebchatForm thisForm = this.gui.getWebChatFormForContact(((InteractionI)this.interactionEvent.getNotificationObject()).getId());
                        Platform.runLater(() -> thisForm.close());
                    }
                    InteractionExecutor.getTimers().stop(((InteractionI)this.interactionEvent.getNotificationObject()).getId());
                    data = new InteractionData(((InteractionI)this.interactionEvent.getNotificationObject()).getId(), true);
                    break;
                }
                case ERROR: {
                    LOG.errorStatus(this.interactionEvent.getError());
                    break;
                }
                case NEW: {
                    data = new InteractionData((InteractionI)this.interactionEvent.getNotificationObject());
                    switch (data.getState()) {
                        case Preview: {
                            if (data.getPreviewTimer() >= 0) {
                                LOG.debug(methodName + "New interaction in preview state, start preview timer", new Object[0]);
                                InteractionExecutor.getTimers().startPreview(data.getPreviewTimer(), data.getId(), data.getDefaultOrFirstContactNumber(), this.gui);
                                data.setTimeLeft(data.getPreviewTimer());
                                break;
                            }
                            break block39;
                        }
                        case Active: {
                            if (data.getContactType() == ContactType.Web_Communications) {
                                if (data.getStateReason() == StateReason.Observe) {
                                    String id = ((InteractionI)this.interactionEvent.getNotificationObject()).getId();
                                    LOG.info("Observed Interaction. id: " + id, new Object[0]);
                                    WebchatForm form = null;
                                    if (data.getStateReason() == StateReason.BargeIn || data.getStateReason() == StateReason.Observe) {
                                        form = this.superGui.getWebChatFormForContact(id);
                                        if (form == null) {
                                            LOG.warn(methodName, "No form found");
                                        }
                                    } else {
                                        form = this.gui.getWebChatFormForContact(id);
                                    }
                                    form.setInteractionData(data);
                                    if (!data.canOpenMedia()) break block1;
                                    this.interactionExecutor.openInteractionMedia(((InteractionI)this.interactionEvent.getNotificationObject()).getId());
                                    break;
                                }
                                if (data.getStateReason().equals((Object)StateReason.TransferComplete)) {
                                    this.gui.createAndAddNewWebchatForm(data.getId());
                                    Thread.currentThread();
                                    Thread.sleep(300L);
                                    WebchatForm form = this.gui.getWebChatFormForContact(data.getId());
                                    form.setInteractionData(data);
                                    if (data.canOpenMedia()) {
                                        this.interactionExecutor.openInteractionMedia(data.getId());
                                    } else {
                                        break;
                                    }
                                } else {
                                    break;
                                }
                            } else {
                                break;
                            }
                        }
                    }
                    break;
                }
                case RESPONSE: {
                    ResponseData resp = this.interactionEvent.getResponseData();
                    return resp;
                }
                case UNKNOWN: {
                    data = new InteractionData((InteractionI)this.interactionEvent.getNotificationObject());
                }
            }
        }
        return data;
    }
}

