/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ccs.javafxrefclient;

import com.avaya.ccs.api.MonitoredInteractionI;
import com.avaya.ccs.api.MonitoredInteractionListenerI;
import com.avaya.ccs.api.MonitoredUserI;
import com.avaya.ccs.api.MonitoredUserListenerI;
import com.avaya.ccs.api.NotificationEventI;
import com.avaya.ccs.javafxrefclient.Executor;
import com.avaya.ccs.javafxrefclient.JavaFXRefClient;
import com.avaya.ccs.javafxrefclient.Logger;
import com.avaya.ccs.javafxrefclient.MonitoredInteractionEventTask;
import com.avaya.ccs.javafxrefclient.MonitoredUserEventTask;
import com.avaya.ccs.javafxrefclient.request.ForceLogoutRequest;
import com.avaya.ccs.javafxrefclient.request.ForceNotReadyRequest;
import com.avaya.ccs.javafxrefclient.request.ForceReadyRequest;
import com.avaya.ccs.javafxrefclient.request.MonitorInteractionsRequest;
import com.avaya.ccs.javafxrefclient.request.MonitorUsersRequest;
import com.avaya.ccs.javafxrefclient.request.UnMonitorInteractionsRequest;
import com.avaya.ccs.javafxrefclient.request.UnMonitorUsersRequest;

public class MonitoredExecutor
extends Executor
implements MonitoredUserListenerI,
MonitoredInteractionListenerI {
    private static final Logger LOG = Logger.getLogger(MonitoredExecutor.class);
    private final JavaFXRefClient gui;

    public MonitoredExecutor(JavaFXRefClient gui) {
        this.gui = gui;
    }

    public void monitorUsers(String userID) {
        String methodName = "monitorUsers() ";
        LOG.debug(methodName + "+ UserID:" + userID, new Object[0]);
        this.executeOutgoingRequest(new MonitorUsersRequest(this, userID));
        LOG.trace(methodName + "-", new Object[0]);
    }

    public void unMonitorUsers(String userID) {
        String methodName = "unMonitorUsers() ";
        LOG.debug(methodName + "+ UserID:" + userID, new Object[0]);
        this.executeOutgoingRequest(new UnMonitorUsersRequest(userID));
        LOG.trace(methodName + "-", new Object[0]);
    }

    public void monitorInteractions(String superID, String userID) {
        String methodName = "monitorInteractions() ";
        LOG.debug(methodName + "+ SupervisorID" + superID + "UserID:" + userID, new Object[0]);
        this.executeOutgoingRequest(new MonitorInteractionsRequest(this, superID, userID));
        LOG.trace(methodName + "-", new Object[0]);
    }

    public void unMonitorInteractions(String superID, String userID) {
        String methodName = "unMonitorInteractions() ";
        LOG.debug(methodName + "+ SupervisorID" + superID + "UserID:" + userID, new Object[0]);
        this.executeOutgoingRequest(new UnMonitorInteractionsRequest(superID, userID));
        LOG.trace(methodName + "-", new Object[0]);
    }

    public void forceReady(String superID, String userID) {
        String methodName = "forceReady() ";
        LOG.debug(methodName + "+ SupervisorID" + superID + "UserID:" + userID, new Object[0]);
        this.executeOutgoingRequest(new ForceReadyRequest(superID, userID));
        LOG.trace(methodName + "-", new Object[0]);
    }

    public void forceNotReady(String superID, String userID) {
        String methodName = "forceNotReady() ";
        LOG.debug(methodName + "+ SupervisorID" + superID + "UserID:" + userID, new Object[0]);
        this.executeOutgoingRequest(new ForceNotReadyRequest(superID, userID));
        LOG.trace(methodName + "-", new Object[0]);
    }

    public void forceLogout(String superID, String userID) {
        String methodName = "forceLogout() ";
        LOG.debug(methodName + "+ SupervisorID" + superID + "UserID:" + userID, new Object[0]);
        this.executeOutgoingRequest(new ForceLogoutRequest(superID, userID));
        LOG.trace(methodName + "-", new Object[0]);
    }

    public void onMonitoredUserEvent(NotificationEventI<MonitoredUserI> monitoredUser) {
        String methodName = "onMonitoredUserEvent() ";
        LOG.info(methodName + monitoredUser.getNotificationType() + " MonitoredUserI-ID:" + ((MonitoredUserI)monitoredUser.getNotificationObject()).getId(), new Object[0]);
        MonitoredUserEventTask t = new MonitoredUserEventTask(monitoredUser, this.gui.getSupervisorGUI());
        this.executeIncomingEvent(t);
    }

    public void onMonitoredInteractionEvent(NotificationEventI<MonitoredInteractionI> nei) {
        String methodName = "onMonitoredInteractionEvent() ";
        LOG.debug(methodName + nei.getNotificationType() + " MonitoredInteractionI-ID:" + ((MonitoredInteractionI)nei.getNotificationObject()).getId(), new Object[0]);
        MonitoredInteractionEventTask t = new MonitoredInteractionEventTask(nei, this.gui.getSupervisorGUI());
        this.executeIncomingEvent(t);
    }
}

