/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ccs.javafxrefclient;

import com.avaya.ccs.api.CodeListI;
import com.avaya.ccs.api.ContactCenterCodeI;
import com.avaya.ccs.javafxrefclient.InteractionExecutor;
import com.avaya.ccs.javafxrefclient.Logger;
import com.avaya.ccs.javafxrefclient.UserDataGUI;
import com.avaya.ccs.javafxrefclient.UserExecutor;
import java.util.Collection;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.stage.Stage;
import javafx.util.Callback;

public class CodeSelectionForm {
    private final Stage codeSelection = new Stage();
    private static final Logger LOG = Logger.getLogger(CodeSelectionForm.class);
    private final UserExecutor user;
    private final InteractionExecutor interactionExe;

    public CodeSelectionForm(UserExecutor user, InteractionExecutor interactionExe, String css) {
        this.user = user;
        this.interactionExe = interactionExe;
        BorderPane codeSelectionBorder = new BorderPane();
        Scene codeSelectionScene = new Scene((Parent)codeSelectionBorder, 300.0, 400.0);
        codeSelectionScene.getStylesheets().add((Object)css);
        this.codeSelection.setScene(codeSelectionScene);
        this.codeSelection.titleProperty().set((Object)"Code Selection");
    }

    public void show() {
        this.codeSelection.show();
    }

    public void updateCodeSectionForm(CodeListI codes, String currentSelectionID) {
        String methodName = "updateCodeSectionForm() ";
        LOG.trace(methodName + "ListType:" + codes.getCodeType() + " size " + codes.getCodes().size(), new Object[0]);
        BorderPane bp = (BorderPane)((Scene)this.codeSelection.sceneProperty().get()).getRoot();
        String title = "Unknown Code Type";
        switch (codes.getCodeType()) {
            case NRRC: {
                title = "Select Not Ready Reason Code";
                break;
            }
            case ACW: {
                title = "Select After Call Work Code";
                break;
            }
            case Activity: {
                title = "Select Activity Code";
                break;
            }
            case Disposition: {
                title = "Select Disposition Code";
                break;
            }
        }
        this.codeSelection.setTitle(title);
        ListView list = new ListView();
        ObservableList items = FXCollections.observableArrayList((Collection)codes.getCodes());
        list.setItems(items);
        list.setCellFactory((Callback)new Callback<ListView<ContactCenterCodeI>, ListCell<ContactCenterCodeI>>(){

            public ListCell<ContactCenterCodeI> call(ListView<ContactCenterCodeI> list) {
                return new UserDataGUI.CodeCell();
            }
        });
        final Button okButton = new Button("OK");
        okButton.setDisable(true);
        list.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<ContactCenterCodeI>(){

            public void changed(ObservableValue<? extends ContactCenterCodeI> observable, ContactCenterCodeI oldValue, ContactCenterCodeI newValue) {
                if (newValue != null) {
                    okButton.setDisable(false);
                }
            }
        });
        bp.setCenter((Node)list);
        okButton.getStyleClass().add((Object)"interactionButton");
        okButton.setOnAction(t -> {
            ContactCenterCodeI selectedCode = (ContactCenterCodeI)list.getSelectionModel().getSelectedItem();
            if (selectedCode == null) {
                LOG.info(methodName + "OKButton(): no value selected", new Object[0]);
                return;
            }
            switch (codes.getCodeType()) {
                case NRRC: {
                    LOG.info(methodName + "OKButton():Not Ready Reason Code:" + selectedCode, new Object[0]);
                    this.user.notReady(currentSelectionID, selectedCode.getNumber().toString());
                    break;
                }
                case ACW: {
                    LOG.info(methodName + "OKButton():After Call Work Code:" + selectedCode, new Object[0]);
                    this.user.ACW(currentSelectionID, selectedCode.getNumber().toString());
                    break;
                }
                case Activity: {
                    LOG.info(methodName + "OKButton():Activity Code:" + selectedCode, new Object[0]);
                    this.interactionExe.setActivityCode(currentSelectionID, selectedCode.getNumber().toString());
                    break;
                }
                case Disposition: {
                    LOG.info(methodName + "OKButton():Disposition Code:" + selectedCode, new Object[0]);
                    this.interactionExe.wrapUPWithCode(currentSelectionID, selectedCode);
                    break;
                }
            }
            this.codeSelection.close();
        });
        Button cancelButton = new Button("Cancel");
        cancelButton.getStyleClass().add((Object)"interactionButton");
        cancelButton.setOnAction(t -> {
            LOG.info("CancelButton()", new Object[0]);
            this.codeSelection.close();
        });
        Button clearButton = new Button("Clear");
        switch (codes.getCodeType()) {
            case NRRC: {
                clearButton.setDisable(true);
                break;
            }
            case ACW: {
                clearButton.setDisable(true);
                break;
            }
            case Activity: {
                clearButton.setDisable(false);
                break;
            }
            case Disposition: 
            case Unknown: {
                clearButton.setDisable(true);
            }
        }
        clearButton.getStyleClass().add((Object)"interactionButton");
        clearButton.setOnAction(t -> {
            LOG.info(methodName + "ClearButton(): only applicable to activity codes", new Object[0]);
            this.interactionExe.setActivityCode(currentSelectionID, null);
            this.codeSelection.close();
        });
        HBox hbuttonbox = new HBox();
        hbuttonbox.getChildren().addAll((Object[])new Node[]{okButton, cancelButton, clearButton});
        bp.setBottom((Node)hbuttonbox);
    }
}

