/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ccs.javafxrefclient;

import com.avaya.ccs.javafxrefclient.Data;
import com.avaya.ccs.javafxrefclient.GUIUtil;
import com.avaya.ccs.javafxrefclient.Logger;
import java.util.LinkedList;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ComboBox;
import javafx.scene.control.MenuItem;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import javafx.util.Pair;

public abstract class DetailsForm {
    private final Stage stage = new Stage();
    private final ComboBox<String> detailsSelection = new ComboBox();
    private final MenuItem menuItem;
    private final Logger LOG;
    private boolean firstShown = false;

    public DetailsForm(final Logger LOG, String title, String menu, String css) {
        this.LOG = LOG;
        this.stage.titleProperty().set((Object)title);
        this.menuItem = new MenuItem(menu);
        BorderPane userDetailsborder = new BorderPane();
        Scene userDetailsScene = new Scene((Parent)userDetailsborder);
        userDetailsScene.getStylesheets().add((Object)css);
        this.stage.setScene(userDetailsScene);
        this.detailsSelection.valueProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                String methodName = "detailsSelectionChanged() ";
                LOG.trace(methodName + "+", new Object[0]);
                DetailsForm.this.redrawDetailsForm();
                LOG.trace(methodName + "-", new Object[0]);
            }
        });
        userDetailsborder.setTop(this.detailsSelection);
        this.menuItem.setOnAction(t -> {
            this.stage.show();
            this.action();
        });
    }

    protected abstract void action();

    protected abstract ObservableList<Data> getItems();

    protected abstract Data getItem(String var1);

    protected abstract Data getDefault();

    public MenuItem getMenuItem() {
        return this.menuItem;
    }

    public void refresh() {
        this.refreshDetailsDisplayList();
        this.redrawDetailsForm();
        this.stage.sizeToScene();
    }

    protected void redrawDetailsForm() {
        BorderPane bp = (BorderPane)((Scene)this.stage.sceneProperty().get()).getRoot();
        LinkedList<Pair<String, String>> props = new LinkedList<Pair<String, String>>();
        LinkedList<Pair<String, Boolean>> caps = new LinkedList<Pair<String, Boolean>>();
        Data item = this.getCurrentDetailSelection();
        props.addAll(item.getProperties());
        caps.addAll(item.getCaps());
        bp.setLeft((Node)GUIUtil.properties(props));
        bp.setCenter((Node)GUIUtil.capabilities(caps));
        if (!this.firstShown) {
            this.firstShown = true;
            this.stage.sizeToScene();
            this.stage.centerOnScreen();
        }
    }

    protected void refreshDetailsDisplayList() {
        String methodName = "refreshDetailsDisplayList() ";
        this.LOG.trace(methodName + "+", new Object[0]);
        String currentSelection = (String)this.detailsSelection.getValue();
        if (currentSelection != null) {
            this.LOG.trace(methodName + "Current Selection:" + currentSelection, new Object[0]);
        } else {
            this.LOG.trace(methodName + "Current is null ", new Object[0]);
        }
        ObservableList<Data> items = this.getItems();
        boolean stillExists = false;
        for (Data item : items) {
            if (!item.getId().equals(currentSelection)) continue;
            stillExists = true;
        }
        this.LOG.trace(methodName + "clearing+", new Object[0]);
        this.detailsSelection.getItems().clear();
        this.LOG.trace(methodName + "clearing-", new Object[0]);
        for (Data item : items) {
            this.detailsSelection.getItems().add((Object)item.getId());
        }
        if (stillExists) {
            this.LOG.trace(methodName + "existing selection still exists:" + currentSelection, new Object[0]);
            this.detailsSelection.setValue((Object)currentSelection);
        } else if (items.size() > 0) {
            this.LOG.trace(methodName + "existing selection does not exists, setting to first element", new Object[0]);
            this.detailsSelection.setValue((Object)((Data)items.get(0)).getId());
        } else {
            this.LOG.trace(methodName + "list is empty", new Object[0]);
        }
        this.LOG.trace(methodName + "-", new Object[0]);
    }

    protected Data getCurrentDetailSelection() {
        String methodName = "getCurrentDetailSelection() ";
        String currentSelection = (String)this.detailsSelection.getValue();
        if (currentSelection != null) {
            this.LOG.trace(methodName + "current detail selection = " + currentSelection, new Object[0]);
            return this.getItem(currentSelection);
        }
        this.LOG.trace(methodName + "current detail selection is NULL, returning blank", new Object[0]);
        return this.getDefault();
    }
}

