/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ccs.javafxrefclient;

import com.avaya.ccs.api.NotificationEventI;
import com.avaya.ccs.api.ResourceI;
import com.avaya.ccs.api.ResourceListenerI;
import com.avaya.ccs.javafxrefclient.Executor;
import com.avaya.ccs.javafxrefclient.JavaFXRefClient;
import com.avaya.ccs.javafxrefclient.Logger;
import com.avaya.ccs.javafxrefclient.ResourceEventTask;
import com.avaya.ccs.javafxrefclient.request.CallSupervisorRequest;
import com.avaya.ccs.javafxrefclient.request.GetResourceDataRequest;
import com.avaya.ccs.javafxrefclient.request.OriginateVoiceCallRequest;

public class ResourceExecutor
extends Executor
implements ResourceListenerI {
    private static final Logger LOG = Logger.getLogger(ResourceExecutor.class);
    private final JavaFXRefClient gui;

    public ResourceExecutor(JavaFXRefClient gui) {
        this.gui = gui;
    }

    public void originateCall(String number, String resourceID) {
        String methodName = "originateCall() ";
        LOG.debug(methodName + "+ Number:" + number + " ResourceID:" + resourceID, new Object[0]);
        this.executeOutgoingRequest(new OriginateVoiceCallRequest(resourceID, number));
        LOG.trace(methodName + "-", new Object[0]);
    }

    public void callSupervisor(String resourceID) {
        String methodName = "callSupervisor() ";
        LOG.debug(methodName + "+ ResourceID:" + resourceID, new Object[0]);
        this.executeOutgoingRequest(new CallSupervisorRequest(resourceID));
        LOG.trace(methodName + "-", new Object[0]);
    }

    public void getResourceData() {
        String methodName = "getResourceData() ";
        LOG.debug(methodName + "+", new Object[0]);
        this.executeOutgoingRequest(new GetResourceDataRequest(this.gui.getResourceDataGUI()));
        LOG.trace(methodName + "-", new Object[0]);
    }

    public void onResourceEvent(NotificationEventI<ResourceI> nei) {
        String methodName = "onResourceEvent() ";
        LOG.info(methodName + nei.getNotificationType() + " ResourceI-ID:" + ((ResourceI)nei.getNotificationObject()).getId(), new Object[0]);
        ResourceEventTask t = new ResourceEventTask(nei, this.gui.getResourceDataGUI(), this.gui.getInteractionDataGUI());
        this.executeIncomingEvent(t);
    }
}

