/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ccs.javafxrefclient;

import com.avaya.ccs.javafxrefclient.Data;
import com.avaya.ccs.javafxrefclient.DetailsForm;
import com.avaya.ccs.javafxrefclient.Logger;
import java.util.ArrayList;
import java.util.List;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.TableView;

public abstract class TableDataGUI {
    private final Logger LOG;
    private final ObservableList<Data> items = FXCollections.observableArrayList();
    private final TableView<Data> itemSelection = new TableView();
    private DetailsForm detailsForm;

    public TableDataGUI(Logger LOG) {
        this.LOG = LOG;
        this.itemSelection.getSelectionModel().selectedItemProperty().addListener((obs, oldSelection, newSelection) -> {
            String methodName = "itemSelectionChanged() ";
            if (newSelection != null) {
                LOG.trace(methodName + "+", new Object[0]);
                this.redrawControls();
                LOG.trace(methodName + "-", new Object[0]);
            } else {
                LOG.trace(methodName + "selection is null", new Object[0]);
            }
        });
    }

    protected Data getCurrentItemSelection() {
        String methodName = "getCurrentItemSelection() ";
        Data currentSelection = (Data)this.getItemSelection().getSelectionModel().getSelectedItem();
        if (currentSelection != null) {
            this.LOG.trace(methodName + "returning non NULL", new Object[0]);
            return currentSelection;
        }
        this.LOG.trace(methodName + "returning NULL", new Object[0]);
        return null;
    }

    protected void setSelectionToFirstElement() {
        this.getItemSelection().getSelectionModel().selectFirst();
    }

    protected List<Data> getAllItems() {
        return this.getItemSelection().getItems();
    }

    protected List<Data> getUnselectedItems() {
        List<Data> allItems = this.getAllItems();
        ArrayList<Data> unselectedItems = new ArrayList<Data>();
        unselectedItems.addAll(allItems);
        Data currentSelection = (Data)this.getItemSelection().getSelectionModel().getSelectedItem();
        if (currentSelection != null) {
            unselectedItems.remove(currentSelection);
        }
        return unselectedItems;
    }

    public void update(ObservableList<Data> data) {
        String methodName = "update() ";
        this.LOG.trace(methodName + "new count =  " + data.size(), new Object[0]);
        this.items.clear();
        this.items.addAll(data);
        this.refreshListsAndRedraw();
    }

    public void update(Data data) {
        String methodName = "update() ";
        this.LOG.trace(methodName + "DataID:" + data.getId(), new Object[0]);
        Data itemFound = null;
        for (Data item : this.items) {
            if (!item.getId().equals(data.getId())) continue;
            itemFound = item;
            break;
        }
        if (itemFound != null) {
            this.LOG.trace(methodName + "existing entry found", new Object[0]);
            if (data.isDeleted()) {
                this.LOG.trace(methodName + "update is a deletion update, removing from list", new Object[0]);
                this.items.remove((Object)itemFound);
            } else {
                this.LOG.trace(methodName + "updating entry", new Object[0]);
                itemFound.update(data);
                this.itemSelection.refresh();
            }
        } else if (data.isDeleted()) {
            this.LOG.trace(methodName + "existing entry not found, but update is a delete so NOT adding", new Object[0]);
        } else {
            this.LOG.trace(methodName + "existing entry not found, adding", new Object[0]);
            this.items.add((Object)data);
        }
        this.refreshListsAndRedraw();
    }

    public void clearData() {
        this.items.clear();
        this.refreshListsAndRedraw();
    }

    protected void refreshListsAndRedraw() {
        this.getDetailsForm().refresh();
        if (!this.getItems().isEmpty() && this.getCurrentItemSelection() == null) {
            this.setSelectionToFirstElement();
        }
        this.redrawControls();
    }

    public Data getItem(String id) {
        String methodName = "getItem() ";
        this.LOG.trace(methodName + "ID:" + id, new Object[0]);
        for (Data item : this.items) {
            if (!item.getId().equals(id)) continue;
            this.LOG.trace(methodName + "item found", new Object[0]);
            return item;
        }
        return null;
    }

    public ObservableList<Data> getItems() {
        return this.items;
    }

    protected abstract void redrawControls();

    public DetailsForm getDetailsForm() {
        return this.detailsForm;
    }

    public void setDetailsForm(DetailsForm detailsForm) {
        this.detailsForm = detailsForm;
    }

    public TableView<Data> getItemSelection() {
        return this.itemSelection;
    }
}

