/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ccs.javafxrefclient;

import com.avaya.ccs.api.AutoPhrasesI;
import com.avaya.ccs.api.CodeListI;
import com.avaya.ccs.api.CustomerHistoryI;
import com.avaya.ccs.api.CustomerInteractionMediaItemI;
import com.avaya.ccs.api.PagePushUrlListI;
import com.avaya.ccs.api.enums.InteractionType;
import com.avaya.ccs.api.enums.StateReason;
import com.avaya.ccs.api.enums.WebChatMethod;
import com.avaya.ccs.core.CodeList;
import com.avaya.ccs.core.ContactCenterCode;
import com.avaya.ccs.core.CustomerHistoryItem;
import com.avaya.ccs.core.CustomerInteractionMediaList;
import com.avaya.ccs.core.Media;
import com.avaya.ccs.core.TranscriptMessage;
import com.avaya.ccs.core.WebChatMedia;
import com.avaya.ccs.javafxrefclient.ConsultForm;
import com.avaya.ccs.javafxrefclient.InteractionData;
import com.avaya.ccs.javafxrefclient.InteractionExecutor;
import com.avaya.ccs.javafxrefclient.Logger;
import com.avaya.ccs.javafxrefclient.MediaFormI;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Separator;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;

public class WebchatForm
implements MediaFormI {
    private final Stage stage = new Stage();
    private static final Logger LOG = Logger.getLogger(WebchatForm.class);
    private final InteractionExecutor interactionExe;
    private Scene webChatScene;
    private ScrollPane scrollPaneTab1;
    private ScrollPane scrollPaneTab2;
    private ConsultForm consultTransferForm;
    final Separator separator = new Separator();
    private TabPane tabPane;
    private Tab tab1;
    private Tab tab2;
    String interactionId;
    String agentLabel = "";
    String customerLabel = "";
    String consultedAgentLabel = "";
    String skillset;
    Label contactIdLbl;
    Label skillsetLbl;
    Label customerIsTypingLbl = new Label("");
    Label thirdPartyIsTypingLbl = new Label("");
    CheckBox sendTranscriptCB = new CheckBox("Email Transcript");
    TextArea transcriptTa;
    TextField inputMessageTf;
    TextArea whisperTranscriptTa;
    TextField whisperInputMessageTf;
    Button sendWhisperBtn;
    Button sendBtn;
    Button transferBtn;
    Label closingReasonLbl = new Label("Closing Reason");
    ObservableList<ContactCenterCode> closingReasonsOl = FXCollections.observableArrayList();
    ChoiceBox<ContactCenterCode> closingReasonCBox = new ChoiceBox();
    Button cancelBtn;
    Button closeBtn;
    TextArea closingAgentNoteTa;
    ObservableList<ContactCenterCode> activityCodesOl = FXCollections.observableArrayList();
    ChoiceBox<ContactCenterCode> activityCodesCBox = new ChoiceBox();
    Label activityCodesLbl = new Label("Activity Code");
    Button setActivityCodeBtn = new Button("Set");
    private Label ppushLbl;
    private Button ppushBtn;
    private ObservableList<String> ppushUrlsOl;
    private ChoiceBox<String> ppushUrlsCBox;
    private Label autoPhrasesLbl;
    private ChoiceBox<String> autoPhrasesCB;
    private ObservableList<String> autoPhrasesOl;
    private Button autoPhrasesBtn;
    CodeList dispositionCodes = new CodeList();
    private VBox mainContainerVBox = new VBox(5.0);
    private VBox tab2ContainerVBox = new VBox(5.0);
    InteractionData interactionData = null;
    WebChatMedia media;
    private String css;
    HBox completeConsultHbox;
    Button closeConsult;
    Button completeAsConference;
    Button completeAsTransfer;
    boolean isSupervised = false;
    private boolean isInteractionDataSet;
    private boolean agentIsTyping;
    private boolean customerIsTyping;
    private boolean thirdPartyIsTyping;
    private Label customerHistoryLbl = new Label("Customer History");
    private final ObservableList<CustomerHistoryItem> customerHistory = FXCollections.observableArrayList();
    private ListView<CustomerHistoryItem> customerHistoryListView = new ListView();
    private TextArea customerHistoryMediaItemTA = new TextArea();

    public WebchatForm(String interactionId, final InteractionExecutor interactionExe, String css) {
        LOG.info("WebchatForm constructor called. Id: " + interactionId, new Object[0]);
        this.interactionExe = interactionExe;
        this.css = css;
        this.interactionId = interactionId;
        this.tabPane = new TabPane();
        this.tabPane.setTabClosingPolicy(TabPane.TabClosingPolicy.UNAVAILABLE);
        this.tab1 = new Tab("Basic Webchat");
        this.tab2 = new Tab("More...");
        this.consultTransferForm = new ConsultForm(interactionExe, css, InteractionType.ChatInteraction);
        this.contactIdLbl = new Label("");
        this.skillsetLbl = new Label("Skillset: ");
        this.transcriptTa = new TextArea();
        this.transcriptTa.setPrefRowCount(10);
        this.transcriptTa.setEditable(false);
        this.whisperTranscriptTa = new TextArea();
        this.whisperTranscriptTa.setPrefRowCount(6);
        this.inputMessageTf = new TextField();
        this.inputMessageTf.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent ke) {
                if (ke.getCode().equals((Object)KeyCode.ENTER)) {
                    WebchatForm.this.sendBtn.fire();
                }
                WebchatForm.this.agentIsTyping = true;
            }
        });
        this.whisperInputMessageTf = new TextField();
        this.whisperInputMessageTf.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent ke) {
                if (ke.getCode().equals((Object)KeyCode.ENTER)) {
                    WebchatForm.this.sendWhisperBtn.fire();
                }
            }
        });
        this.sendBtn = new Button("Send");
        this.transferBtn = new Button("Transfer");
        HBox isTypingLabelsHBox = new HBox(5.0);
        isTypingLabelsHBox.getChildren().addAll((Object[])new Node[]{this.customerIsTypingLbl, this.thirdPartyIsTypingLbl});
        HBox sendRowHbox = new HBox(5.0);
        sendRowHbox.setPadding(new Insets(10.0));
        sendRowHbox.getChildren().addAll((Object[])new Node[]{this.sendBtn, this.transferBtn});
        HBox closingRowHBox = new HBox(5.0);
        closingRowHBox.setPadding(new Insets(10.0));
        this.closingReasonsOl = FXCollections.observableArrayList();
        this.closingReasonCBox = new ChoiceBox();
        this.closingReasonCBox.setPrefWidth(200.0);
        this.closingReasonCBox.setItems(this.closingReasonsOl);
        this.activityCodesCBox.setPrefWidth(200.0);
        this.activityCodesCBox.setItems(this.activityCodesOl);
        HBox activityCodesHbox = new HBox(5.0);
        activityCodesHbox.setPadding(new Insets(10.0));
        activityCodesHbox.getChildren().addAll((Object[])new Node[]{this.activityCodesLbl, this.activityCodesCBox, this.setActivityCodeBtn});
        this.cancelBtn = new Button("Cancel");
        this.closeBtn = new Button("Close");
        this.closingAgentNoteTa = new TextArea();
        Label closingAgentNoteLbl = new Label("Closing note:");
        this.closingAgentNoteTa.setPrefRowCount(2);
        closingRowHBox.getChildren().addAll((Object[])new Node[]{this.closeBtn, this.cancelBtn, this.closingReasonLbl, this.closingReasonCBox});
        this.mainContainerVBox.setPadding(new Insets(10.0));
        this.tab2ContainerVBox.setPadding(new Insets(10.0));
        Label consultLabel = new Label("Consult");
        this.sendWhisperBtn = new Button("Send Whisper");
        this.completeConsultHbox = new HBox(5.0);
        this.closeConsult = new Button("Close Consult");
        this.completeAsConference = new Button("Complete Conference");
        this.completeAsTransfer = new Button("Complete Transfer");
        this.completeConsultHbox.getChildren().addAll((Object[])new Node[]{this.closeConsult, this.completeAsConference, this.completeAsTransfer});
        HBox pagePushHbox = new HBox(5.0);
        pagePushHbox.setPadding(new Insets(10.0));
        this.ppushLbl = new Label("Page push url:");
        this.ppushUrlsOl = FXCollections.observableArrayList();
        this.ppushUrlsCBox = new ChoiceBox();
        this.ppushUrlsCBox.setPrefWidth(200.0);
        this.ppushUrlsCBox.setItems(this.ppushUrlsOl);
        this.ppushBtn = new Button("Send");
        pagePushHbox.getChildren().addAll((Object[])new Node[]{this.ppushLbl, this.ppushUrlsCBox, this.ppushBtn});
        this.mainContainerVBox.getChildren().add((Object)pagePushHbox);
        HBox autoPhrasesHbox = new HBox(5.0);
        autoPhrasesHbox.setPadding(new Insets(10.0));
        this.autoPhrasesLbl = new Label("Auto phrases:");
        this.autoPhrasesOl = FXCollections.observableArrayList();
        this.autoPhrasesCB = new ChoiceBox();
        this.autoPhrasesCB.setPrefWidth(200.0);
        this.autoPhrasesCB.setItems(this.autoPhrasesOl);
        this.autoPhrasesBtn = new Button("Select");
        autoPhrasesHbox.getChildren().addAll((Object[])new Node[]{this.autoPhrasesLbl, this.autoPhrasesCB, this.autoPhrasesBtn});
        this.mainContainerVBox.getChildren().add((Object)autoPhrasesHbox);
        this.customerHistoryListView.setItems(this.customerHistory);
        this.customerHistoryListView.setPrefHeight(250.0);
        this.customerHistoryMediaItemTA.setPrefSize(400.0, 400.0);
        this.customerHistoryMediaItemTA.setEditable(false);
        this.sendBtn.setOnAction(t -> {
            String message = this.inputMessageTf.getText();
            interactionExe.sendWebChatMessage(this.media.getId(), message, false);
            this.transcriptTa.setText(this.transcriptTa.getText() + "\n" + this.agentLabel + ": " + message);
            this.inputMessageTf.setText("");
        });
        this.ppushBtn.setOnAction(t -> {
            String url = (String)this.ppushUrlsCBox.getSelectionModel().getSelectedItem();
            if (url != "") {
                interactionExe.sendWebChatPagePush(this.media.getId(), url);
            }
            this.transcriptTa.setText(this.transcriptTa.getText() + "\n" + this.agentLabel + ": [Page push URL:" + url + "]");
            this.ppushUrlsCBox.getSelectionModel().clearSelection();
        });
        this.autoPhrasesBtn.setOnAction(t -> {
            String phrase = (String)this.autoPhrasesCB.getSelectionModel().getSelectedItem();
            if (phrase != "") {
                this.inputMessageTf.setText(phrase);
            }
        });
        this.setActivityCodeBtn.setOnAction(t -> interactionExe.setActivityCode(this.media.getId(), ((ContactCenterCode)this.activityCodesCBox.getSelectionModel().getSelectedItem()).getNumber()));
        this.closeBtn.setOnAction(t -> {
            if (this.closingReasonCBox.getValue() != null) {
                interactionExe.end(interactionId, ((ContactCenterCode)this.closingReasonCBox.getValue()).getNumber(), this.closingAgentNoteTa.getText(), this.sendTranscriptCB.isSelected());
            } else {
                interactionExe.end(interactionId);
            }
            Stage s = (Stage)this.webChatScene.getWindow();
            s.close();
        });
        this.customerHistoryListView.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent click) {
                LOG.debug("customerHistoryListView().handle() ID:" + WebchatForm.this.media.getId(), new Object[0]);
                if (click.getClickCount() == 2) {
                    String contactId = ((CustomerHistoryItem)WebchatForm.this.customerHistoryListView.getSelectionModel().getSelectedItem()).getContactId();
                    interactionExe.getCustomerInteractionMedia(WebchatForm.this.media.getId(), contactId);
                }
            }
        });
        this.transferBtn.setOnAction(t -> {
            this.consultTransferForm.initializeConsultForm(this.interactionData);
            this.consultTransferForm.setMediaForm(this);
            this.consultTransferForm.setAgentSignature("");
            interactionExe.getConsultDestinations(this.interactionData.getId());
            this.consultTransferForm.show();
        });
        this.sendWhisperBtn.setOnAction(t -> {
            String message = this.whisperInputMessageTf.getText();
            interactionExe.sendWebChatMessage(this.media.getId(), message, true);
            this.whisperTranscriptTa.setText(this.whisperTranscriptTa.getText() + "\n" + this.agentLabel + ": " + message);
            this.whisperInputMessageTf.setText("");
        });
        this.completeAsConference.setOnAction(t -> {
            LOG.debug("completeAsConference click", new Object[0]);
            interactionExe.completeConference(this.media.getId());
            this.closeBtn.setOnAction(t1 -> {
                interactionExe.endConference(this.media.getId());
                Stage s = (Stage)this.webChatScene.getWindow();
                s.close();
            });
        });
        this.completeAsTransfer.setOnAction(t -> {
            LOG.debug("completeAsTransfer click", new Object[0]);
            interactionExe.completeTransfer(this.media.getId());
        });
        this.closeConsult.setOnAction(t -> {
            interactionExe.endConsult(this.media.getId());
            this.disableControls(new Control[]{this.whisperInputMessageTf, this.whisperTranscriptTa, this.sendTranscriptCB, this.sendWhisperBtn, this.closeConsult, this.completeAsTransfer, this.completeAsConference});
        });
        this.mainContainerVBox.getChildren().addAll((Object[])new Node[]{this.contactIdLbl, this.skillsetLbl, this.transcriptTa, isTypingLabelsHBox, this.inputMessageTf, sendRowHbox, activityCodesHbox, closingRowHBox, closingAgentNoteLbl, this.closingAgentNoteTa, this.sendTranscriptCB, this.separator, consultLabel, this.whisperTranscriptTa, this.whisperInputMessageTf, this.sendWhisperBtn, this.completeConsultHbox});
        this.tab2ContainerVBox.getChildren().addAll((Object[])new Node[]{this.customerHistoryLbl, this.customerHistoryListView, this.customerHistoryMediaItemTA});
        this.scrollPaneTab1 = new ScrollPane();
        this.scrollPaneTab1.setVbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        this.scrollPaneTab1.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        this.scrollPaneTab1.setContent((Node)this.mainContainerVBox);
        this.scrollPaneTab1.setFitToWidth(true);
        this.scrollPaneTab2 = new ScrollPane();
        this.scrollPaneTab2.setVbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        this.scrollPaneTab2.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        this.scrollPaneTab2.setContent((Node)this.tab2ContainerVBox);
        this.scrollPaneTab2.setFitToWidth(true);
        this.tabPane.getTabs().addAll((Object[])new Tab[]{this.tab1, this.tab2});
        this.tab1.setContent((Node)this.scrollPaneTab1);
        this.tab2.setContent((Node)this.scrollPaneTab2);
        this.webChatScene = new Scene((Parent)this.tabPane, 500.0, 550.0);
        this.webChatScene.getStylesheets().add((Object)css);
        this.stage.setScene(this.webChatScene);
        this.stage.setTitle("Web Chat");
        this.disableControls(new Control[]{this.whisperInputMessageTf, this.whisperTranscriptTa, this.sendWhisperBtn, this.closeConsult, this.completeAsTransfer, this.completeAsConference});
        ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
        scheduler.scheduleAtFixedRate(new IsTypingScheduledMonitor(), 3L, 2L, TimeUnit.SECONDS);
        LOG.info("WebchatForm constructor done", new Object[0]);
    }

    public String getInteractionId() {
        return this.interactionId;
    }

    public void updateForm() {
        String methodName = "updateForm";
        LOG.debug(methodName + this.media.getMethod(), new Object[0]);
        if (this.media.getMethod() != null && this.media.getMethod().equals((Object)WebChatMethod.newMessage)) {
            if (this.media.getMessageType().equals((Object)"whisper")) {
                String currentText = this.whisperTranscriptTa.getText();
                this.whisperTranscriptTa.setText(currentText + "\n" + this.media.getDisplayName() + ": " + this.media.getMessage());
            } else {
                String currentText = this.transcriptTa.getText();
                this.transcriptTa.setText(currentText + "\n" + this.media.getDisplayName() + ": " + this.media.getMessage());
            }
        }
    }

    private String transcriptToText(String[] messages) {
        StringBuilder transcriptBuilder = new StringBuilder();
        for (String message : Arrays.asList(messages)) {
            transcriptBuilder.append(message + "\n");
        }
        return transcriptBuilder.toString();
    }

    public void show() {
        LOG.debug("show()", new Object[0]);
        this.stage.show();
    }

    public void setInteractionData(InteractionData interactionData) {
        LOG.debug("setInteractionData()", new Object[0]);
        this.interactionData = interactionData;
        this.contactIdLbl.setText("Interaction ID: " + this.interactionId);
        this.consultTransferForm.setInteractionMedia((Media)this.media);
        this.consultTransferForm.setCurrentInteractionId(interactionData.getId());
        this.updateInteractionData(interactionData);
        this.setInteractionDataSet(true);
    }

    public void setMedia(WebChatMedia media) {
        LOG.debug("setMedia media isNull: " + (media == null), new Object[0]);
        if (media != null) {
            this.media = media;
        }
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.interactionData.canGetAutoPhrases()) {
            this.interactionExe.getAutoPhrases(this.media.getId());
        }
        if (this.interactionData.canGetPagePushUrls()) {
            this.interactionExe.getPagePushUrls(this.media.getId());
        }
        if (this.interactionData.canGetDispositionCodes()) {
            this.interactionExe.getDispositionCodes(this.media.getId());
        }
        if (this.interactionData.canGetCustomerHistory()) {
            this.interactionExe.getCustomerHistory(this.media.getId());
        }
        this.interactionExe.getActivityCodes(this.media.getId());
        this.interactionExe.getCustomFields(this.media.getId());
        this.updateForm();
    }

    public void setCustomerHistory(CustomerHistoryI custHistory) {
        LOG.info("setCustomerHistory", new Object[0]);
        custHistory.getCustomerInteractions().forEach(item -> this.customerHistory.add(item));
    }

    public void setDispositionCodes(CodeListI codes) {
        LOG.debug("setDispositionCodes", new Object[0]);
        codes.getCodes().forEach(c -> this.dispositionCodes.addCodeToList(c));
        codes.getCodes().forEach(c -> {
            if (!this.closingReasonsOl.contains(c)) {
                this.closingReasonsOl.add((Object)((ContactCenterCode)c));
            }
        });
    }

    public void setActivityCodes(CodeListI codes) {
        LOG.debug("setActivityCodes", new Object[0]);
        codes.getCodes().forEach(c -> {
            if (!this.activityCodesOl.contains(c)) {
                this.activityCodesOl.add((Object)((ContactCenterCode)c));
            }
        });
    }

    public void setPagePushUrls(PagePushUrlListI urlList) {
        LOG.debug("setPagePushUrls", new Object[0]);
        urlList.getPagePushUrls().forEach(url -> {
            if (!this.ppushUrlsOl.contains((Object)url.getUrl())) {
                this.ppushUrlsOl.add((Object)url.getUrl());
            }
        });
    }

    public void setAutoPhrases(AutoPhrasesI phrases) {
        LOG.debug("setAutoPhrases", new Object[0]);
        phrases.getAutoPhrases().forEach(phrase -> {
            if (!this.autoPhrasesOl.contains((Object)phrase.getPhraseText())) {
                this.autoPhrasesOl.add((Object)phrase.getPhraseText());
            }
        });
    }

    public void setCustomerLabelText(String text) {
        this.customerIsTypingLbl.setText(text);
    }

    public void setThirdPartyLabelText(String text) {
        this.thirdPartyIsTypingLbl.setText(text);
    }

    public void updateMedia(WebChatMedia media) {
        LOG.debug("updateMedia media isNull: " + (media == null), new Object[0]);
        if (media.getAgentLabel() != null) {
            this.agentLabel = media.getAgentLabel();
        }
        if (media.getCustomerLabel() != null) {
            this.customerLabel = media.getCustomerLabel();
        }
        if (media.getMethod().equals((Object)WebChatMethod.isTyping)) {
            if (media.getSenderType().equals((Object)"customer")) {
                this.customerIsTyping = true;
            } else if (media.getSenderType().equals((Object)"agent")) {
                this.thirdPartyIsTyping = true;
            }
        } else if (media.getMethod().equals((Object)WebChatMethod.agentJoinRoom)) {
            if (media.getTranscript().getMessages().length > 0) {
                for (TranscriptMessage m : media.getTranscript().getMessages()) {
                    if (m.getType().equalsIgnoreCase("pagePush")) {
                        this.transcriptTa.setText(this.transcriptTa.getText() + "\n" + m.getDisplayName() + ": [Page push URL:" + m.getUrl() + "]");
                        continue;
                    }
                    this.transcriptTa.setText(this.transcriptTa.getText() + "\n" + m.getDisplayName() + ": " + m.getMessage());
                }
            }
        } else if (media.getMethod().equals((Object)WebChatMethod.pagePush)) {
            this.transcriptTa.setText(this.transcriptTa.getText() + "\n" + media.getDisplayName() + ": [Page push URL:" + media.getUrl() + "]");
        }
        this.media = media;
        this.updateForm();
    }

    public ConsultForm getConsultForm() {
        return this.consultTransferForm;
    }

    @Override
    public void close() {
        this.stage.close();
        Stage s = (Stage)this.webChatScene.getWindow();
        s.close();
    }

    @Override
    public void enableControls(Control[] controls) {
        LOG.debug("enableControls", new Object[0]);
        for (Control c : controls) {
            c.setDisable(false);
            c.setFocusTraversable(true);
        }
    }

    @Override
    public void disableControls(Control[] controls) {
        LOG.debug("disableControls", new Object[0]);
        for (Control c : controls) {
            c.setDisable(true);
            c.setFocusTraversable(false);
        }
    }

    public void updateInteractionData(InteractionData data) {
        this.interactionData = data;
        LOG.info("updateInteractionData called ", new Object[0]);
        if (!this.consultTransferForm.isMediaSet()) {
            this.consultTransferForm.setInteractionMedia((Media)this.media);
        }
        if (data.getStateReason() == StateReason.Observe) {
            this.sendBtn.setDisable(true);
            this.inputMessageTf.setDisable(true);
            this.whisperInputMessageTf.setDisable(false);
            this.sendWhisperBtn.setDisable(false);
        } else if (data.getStateReason() == StateReason.ConsultInitiated) {
            this.sendBtn.setDisable(true);
            this.inputMessageTf.setDisable(true);
            this.whisperInputMessageTf.setDisable(false);
            this.sendWhisperBtn.setDisable(false);
        } else {
            this.closeConsult.setDisable(!data.canEndConsult());
            this.sendWhisperBtn.setDisable(!data.canCompleteConference());
            this.completeAsConference.setDisable(!data.canCompleteConference());
            this.completeAsTransfer.setDisable(!data.canCompleteTransfer());
            this.sendWhisperBtn.setDisable(!data.canEndConsult());
            this.closeBtn.setDisable(!data.canEnd());
            this.whisperInputMessageTf.setDisable(!data.isConsult());
            this.whisperTranscriptTa.setDisable(!data.isConsult());
        }
    }

    public boolean isInteractionDataSet() {
        return this.isInteractionDataSet;
    }

    public void setInteractionDataSet(boolean isInteractionDataSet) {
        this.isInteractionDataSet = isInteractionDataSet;
    }

    public void setCustomerInteractionMediaList(CustomerInteractionMediaList value) {
        List items = value.getCustomerInteractionMediaItems();
        StringBuilder mediaSB = new StringBuilder();
        for (CustomerInteractionMediaItemI item : items) {
            mediaSB.append(item.toString() + "\n");
        }
        this.customerHistoryMediaItemTA.setText(mediaSB.toString());
    }

    public void goToWrapup() {
        LOG.debug("goToWrapup", new Object[0]);
        this.transcriptTa.appendText("\nThe customer has left the chat.");
        this.disableControls(new Control[]{this.inputMessageTf, this.sendBtn, this.transferBtn});
    }

    class IsTypingScheduledMonitor
    implements Runnable {
        IsTypingScheduledMonitor() {
        }

        @Override
        public void run() {
            if (WebchatForm.this.agentIsTyping) {
                WebchatForm.this.interactionExe.sendAgentIsTypingMessage(WebchatForm.this.interactionId);
                WebchatForm.this.agentIsTyping = false;
            }
            if (WebchatForm.this.customerIsTyping) {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        WebchatForm.this.setCustomerLabelText("Customer is typing...");
                    }
                });
                WebchatForm.this.customerIsTyping = false;
            } else {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        WebchatForm.this.setCustomerLabelText("");
                    }
                });
            }
            if (WebchatForm.this.thirdPartyIsTyping) {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        WebchatForm.this.setThirdPartyLabelText("Third party agent is typing...");
                    }
                });
                WebchatForm.this.thirdPartyIsTyping = false;
            } else {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        WebchatForm.this.setThirdPartyLabelText("");
                    }
                });
            }
        }
    }
}

