/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ccs.javafxrefclient;

import com.avaya.ccs.javafxrefclient.InteractionDataGUI;
import com.avaya.ccs.javafxrefclient.InteractionDataI;
import com.avaya.ccs.javafxrefclient.InteractionExecutor;
import com.avaya.ccs.javafxrefclient.Logger;
import java.util.Optional;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.Tab;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.text.Text;
import javafx.util.Callback;

public class AgentNotesTab {
    private final Tab tab;
    private final ObservableList<String> agentNotesList = FXCollections.observableArrayList();
    private TableView<String> agentNotesTable = new TableView();
    private final String BLANKAGENTNOTES = "no notes to display";
    private final InteractionExecutor interactionExe;
    private final InteractionDataGUI gui;
    private static final Logger LOG = Logger.getLogger(AgentNotesTab.class);

    public AgentNotesTab(InteractionExecutor interactionExe, InteractionDataGUI gui) {
        this.interactionExe = interactionExe;
        this.gui = gui;
        this.createAgentNotesTable();
        this.tab = new Tab();
        this.tab.setText("Agent Notes");
        this.tab.setClosable(false);
        BorderPane agentNotesPane = new BorderPane();
        agentNotesPane.setCenter(this.agentNotesTable);
        HBox buttons = new HBox();
        Button refresh = new Button("Refresh");
        refresh.getStyleClass().add((Object)"intrinsicButton");
        refresh.setOnAction(t -> {
            String id = gui.getCurrentItemSelection().getId();
            LOG.info("RefreshButton() ID:" + id, new Object[0]);
            interactionExe.refreshAgentNotes(id);
        });
        Button add = new Button("Add");
        add.getStyleClass().add((Object)"intrinsicButton");
        add.setOnAction(t -> {
            LOG.info("AddButton()", new Object[0]);
            this.addAgentNoteDialog();
        });
        buttons.getChildren().addAll((Object[])new Node[]{refresh, add});
        agentNotesPane.setBottom((Node)buttons);
        this.tab.setContent((Node)agentNotesPane);
        this.tab.setDisable(true);
    }

    private void createAgentNotesTable() {
        this.agentNotesTable.setEditable(false);
        this.agentNotesTable.setPlaceholder((Node)new Label("no notes to display"));
        TableColumn note = new TableColumn("Notes");
        note.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<String, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<String, String> p) {
                return new ReadOnlyObjectWrapper(p.getValue());
            }
        });
        note.setCellFactory((Callback)new Callback<TableColumn<String, String>, TableCell<String, String>>(){

            public TableCell<String, String> call(TableColumn<String, String> param) {
                TableCell<String, String> cell = new TableCell<String, String>(){
                    private Text text;

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (!this.isEmpty()) {
                            this.text = new Text(item);
                            this.text.wrappingWidthProperty().bind((ObservableValue)this.getTableColumn().widthProperty().subtract(2));
                            this.setGraphic((Node)this.text);
                        }
                    }
                };
                return cell;
            }
        });
        this.agentNotesTable.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        this.agentNotesTable.setItems(this.agentNotesList);
        this.agentNotesTable.getColumns().add((Object)note);
        this.agentNotesTable.setSelectionModel(null);
    }

    private void addAgentNoteDialog() {
        Dialog dialog = new Dialog();
        dialog.setTitle("Add Agent Note");
        ButtonType okButtonType = new ButtonType("Save", ButtonBar.ButtonData.OK_DONE);
        dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{okButtonType, ButtonType.CANCEL});
        GridPane grid = new GridPane();
        grid.getStyleClass().add((Object)"dialog");
        TextField noteTextField = new TextField();
        grid.add((Node)new Label("New Note:"), 0, 0);
        grid.add((Node)noteTextField, 1, 0);
        dialog.getDialogPane().setContent((Node)grid);
        dialog.setResultConverter(dialogButton -> {
            if (dialogButton == okButtonType) {
                return noteTextField.getText();
            }
            return null;
        });
        Platform.runLater(() -> noteTextField.requestFocus());
        Optional result = dialog.showAndWait();
        result.ifPresent(noteValue -> {
            String methodName = "addAgentNoteDialog() ";
            LOG.trace(methodName + "Note:" + noteValue, new Object[0]);
            this.interactionExe.addAgentNote(this.gui.getCurrentItemSelection().getId(), (String)noteValue);
        });
    }

    public Tab getTab() {
        return this.tab;
    }

    void update(InteractionDataI data) {
        this.tab.setDisable(!data.canAddAgentNote());
        this.agentNotesList.clear();
        this.agentNotesTable.refresh();
        this.agentNotesList.addAll(data.getAgentNotes());
    }
}

