/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ccs.javafxrefclient;

import com.avaya.ccs.api.DataI;
import com.avaya.ccs.javafxrefclient.BinDataTabBase;
import com.avaya.ccs.javafxrefclient.InteractionDataGUI;
import com.avaya.ccs.javafxrefclient.InteractionDataI;
import com.avaya.ccs.javafxrefclient.InteractionExecutor;
import com.avaya.ccs.javafxrefclient.Logger;
import java.util.Optional;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;

public class BinDataTab
extends BinDataTabBase {
    private final Button editString;
    private final Button deleteData;
    private final InteractionExecutor interactionExe;
    private final InteractionDataGUI gui;
    private static final String BLANKDATAMESSAGE = "no DATA to display, enter binary data as HEX pairs, ie: A1B2";
    private static final Logger LOG = Logger.getLogger(BinDataTab.class);

    public BinDataTab(InteractionExecutor interactionExe, InteractionDataGUI gui) {
        super(BLANKDATAMESSAGE);
        this.interactionExe = interactionExe;
        this.gui = gui;
        HBox buttons = new HBox();
        this.editString = new Button("Edit");
        this.editString.setDisable(true);
        this.editString.getStyleClass().add((Object)"intrinsicButton");
        this.editString.setOnAction(t -> {
            String text = this.dataEditor.getText();
            LOG.info(this.editString.getText() + ":" + text, new Object[0]);
            this.editDataDialog(text);
        });
        this.deleteData = new Button("Delete");
        this.deleteData.setDisable(true);
        this.deleteData.getStyleClass().add((Object)"intrinsicButton");
        this.deleteData.setOnAction(t -> {
            String id = gui.getCurrentItemSelection().getId();
            LOG.info("DeleteButton() ID:" + id, new Object[0]);
            interactionExe.deleteDATA(id);
        });
        buttons.getChildren().addAll((Object[])new Node[]{this.editString, this.deleteData});
        this.pane.setBottom((Node)buttons);
    }

    private void editDataDialog(String newStrData) {
        Dialog dialog = new Dialog();
        dialog.setTitle("Save Data");
        ButtonType saveButtonType = new ButtonType("Save", ButtonBar.ButtonData.OK_DONE);
        dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{saveButtonType, ButtonType.CANCEL});
        GridPane grid = new GridPane();
        grid.getStyleClass().add((Object)"dialog");
        TextField data = new TextField();
        data.setText(newStrData);
        grid.add((Node)new Label("DATA:"), 0, 0);
        grid.add((Node)data, 1, 0);
        dialog.getDialogPane().setContent((Node)grid);
        Platform.runLater(() -> data.requestFocus());
        dialog.setResultConverter(dialogButton -> {
            if (dialogButton == saveButtonType) {
                return data.getText();
            }
            return null;
        });
        Optional result = dialog.showAndWait();
        result.ifPresent(resultData -> {
            String methodName = "editDataDialog() ";
            String newBinValue = resultData.toUpperCase();
            if (BinDataTab.isStringHex(newBinValue)) {
                LOG.trace(methodName + "Updating DATA to:" + newBinValue, new Object[0]);
                this.interactionExe.setDATA(this.gui.getCurrentItemSelection().getId(), BinDataTab.hexStringToByteArray(newBinValue));
            } else {
                LOG.error(methodName + "data must represent HEX values and be a multiple of 2", new Object[0]);
            }
        });
    }

    @Override
    void update(InteractionDataI data) {
        boolean disable = !data.canGetData();
        this.dataEditor.setDisable(disable);
        this.tab.setDisable(disable);
        this.editString.setDisable(!data.canGetData());
        DataI dataInstance = data.getData();
        if (dataInstance != null) {
            this.deleteData.setDisable(false);
            switch (dataInstance.getFormat()) {
                case BIN: {
                    this.tab.setDisable(false);
                    this.dataEditor.setText(BinDataTab.bytesToHex(dataInstance.getBinaryData()));
                    break;
                }
                case KVP: {
                    this.tab.setDisable(true);
                    break;
                }
                case STR: {
                    this.tab.setDisable(true);
                    break;
                }
                case UNKNOWN: {
                    this.dataEditor.setText(this.getBlankdata());
                }
            }
        } else {
            this.deleteData.setDisable(true);
            this.dataEditor.setText(this.getBlankdata());
        }
    }
}

