/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ccs.javafxrefclient;

import com.avaya.ccs.api.DataI;
import com.avaya.ccs.javafxrefclient.BinDataTab;
import com.avaya.ccs.javafxrefclient.InteractionDataI;
import com.avaya.ccs.javafxrefclient.Logger;
import javafx.scene.Node;
import javafx.scene.control.Tab;
import javafx.scene.control.TextArea;
import javafx.scene.layout.BorderPane;

public class BinDataTabBase {
    protected static final char[] HEXARRAY = "0123456789ABCDEF".toCharArray();
    private static final Logger LOG = Logger.getLogger(BinDataTabBase.class);
    protected final Tab tab;
    protected final TextArea dataEditor = new TextArea();
    private String blankdata;
    protected final BorderPane pane;

    public BinDataTabBase(String blank) {
        this.dataEditor.getStyleClass().add((Object)"dataEditor");
        this.blankdata = blank;
        this.dataEditor.setText(this.blankdata);
        this.dataEditor.setEditable(false);
        this.tab = new Tab();
        this.tab.setText("Binary");
        this.tab.setClosable(false);
        this.tab.setContent((Node)this.dataEditor);
        this.tab.setDisable(true);
        this.pane = new BorderPane();
        this.pane.setCenter((Node)this.dataEditor);
        this.tab.setContent((Node)this.pane);
    }

    public Tab getTab() {
        return this.tab;
    }

    void update(InteractionDataI data) {
        boolean disable = !data.canGetData();
        this.dataEditor.setDisable(disable);
        this.tab.setDisable(disable);
        DataI dataInstance = data.getData();
        if (dataInstance != null) {
            switch (dataInstance.getFormat()) {
                case BIN: {
                    this.tab.setDisable(false);
                    this.dataEditor.setText(BinDataTab.bytesToHex(dataInstance.getBinaryData()));
                    break;
                }
                case KVP: {
                    this.tab.setDisable(true);
                    break;
                }
                case STR: {
                    this.tab.setDisable(true);
                    break;
                }
                case UNKNOWN: {
                    this.dataEditor.setText(this.getBlankdata());
                }
            }
        } else {
            this.dataEditor.setText(this.getBlankdata());
        }
    }

    public static boolean isStringHex(String toCheck) {
        String methodName = "isStringHex() ";
        if (toCheck.length() % 2 != 0) {
            LOG.error(methodName + "need 2 hex chars to match each byte ", new Object[0]);
            return false;
        }
        for (int i = 0; i < toCheck.length(); ++i) {
            boolean validChar = false;
            for (int j = 0; j < HEXARRAY.length; ++j) {
                if (toCheck.charAt(i) != HEXARRAY[j]) continue;
                validChar = true;
                break;
            }
            if (validChar) continue;
            LOG.error(methodName + "Found at least one invalid char:" + toCheck.charAt(i), new Object[0]);
            return false;
        }
        return true;
    }

    public static byte[] hexStringToByteArray(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }

    public static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEXARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEXARRAY[v & 0xF];
        }
        return new String(hexChars);
    }

    public String getBlankdata() {
        return this.blankdata;
    }
}

