/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ccs.javafxrefclient;

import com.avaya.ccs.api.ClientI;
import com.avaya.ccs.api.enums.NotificationType;
import com.avaya.ccs.javafxrefclient.ClientData;
import com.avaya.ccs.javafxrefclient.JavaFXRefClient;
import com.avaya.ccs.javafxrefclient.Logger;
import javafx.concurrent.Task;

public class ClientEventTask
extends Task<ClientData> {
    private final NotificationType type;
    private final ClientI client;
    private final JavaFXRefClient gui;
    private static final Logger LOG = Logger.getLogger(ClientEventTask.class);

    public ClientEventTask(NotificationType type, ClientI client, JavaFXRefClient gui) {
        this.type = type;
        this.client = client;
        this.gui = gui;
        this.setupJavaFXApplicationHandlers();
    }

    private void setupJavaFXApplicationHandlers() {
        this.setupJavaFXApplicationSucceededHandler();
        this.setupJavaFXApplicationFailureHandler();
    }

    private void setupJavaFXApplicationSucceededHandler() {
        this.setOnSucceeded(t -> {
            String methodName = "succeededHandler() ";
            ClientData value = (ClientData)t.getSource().valueProperty().getValue();
            if (value != null) {
                LOG.info(methodName + "ClientData:" + value, new Object[0]);
                this.gui.updateClientData(value);
            } else {
                LOG.debug(methodName + " NULL", new Object[0]);
            }
        });
    }

    private void setupJavaFXApplicationFailureHandler() {
        this.setOnFailed(t -> {
            String methodName = "failedHandler() ";
            LOG.trace(methodName, new Object[0]);
        });
    }

    protected ClientData call() throws Exception {
        String methodName = "call() ";
        LOG.debug(methodName + "Type:" + this.type, new Object[0]);
        switch (this.type) {
            case UPDATE: {
                break;
            }
            case DELETE: {
                break;
            }
            case ERROR: {
                break;
            }
            case NEW: {
                break;
            }
            case RESPONSE: {
                break;
            }
        }
        ClientData data = new ClientData(this.client);
        return data;
    }
}

