/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ccs.javafxrefclient;

import com.avaya.ccs.api.CustomFieldListI;
import com.avaya.ccs.javafxrefclient.AgentNotesTab;
import com.avaya.ccs.javafxrefclient.AttachedDataTab;
import com.avaya.ccs.javafxrefclient.CustomFieldsTab;
import com.avaya.ccs.javafxrefclient.CustomerDataPane;
import com.avaya.ccs.javafxrefclient.InteractionDataGUI;
import com.avaya.ccs.javafxrefclient.InteractionDataI;
import com.avaya.ccs.javafxrefclient.InteractionExecutor;
import com.avaya.ccs.javafxrefclient.IntrinsicsTab;
import com.avaya.ccs.javafxrefclient.UUITab;
import javafx.scene.control.TabPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;

public class SideBar {
    private final VBox sideBar = new VBox();
    private final IntrinsicsTab intrinsicsTab;
    private final UUITab uuiTab;
    private final AttachedDataTab dataTab;
    private final AgentNotesTab agentNotesTab;
    private final CustomFieldsTab customFieldsTab;
    private final CustomerDataPane customerDataPane;

    public SideBar(InteractionExecutor interactionExe, InteractionDataGUI gui) {
        this.sideBar.getStyleClass().add((Object)"sideBar");
        Text title = new Text("Customer Data");
        title.getStyleClass().add((Object)"title");
        this.sideBar.getChildren().add((Object)title);
        this.customerDataPane = new CustomerDataPane(interactionExe, gui);
        this.sideBar.getChildren().add((Object)this.customerDataPane.getPane());
        TabPane tabPane = new TabPane();
        this.intrinsicsTab = new IntrinsicsTab(interactionExe, gui);
        tabPane.getTabs().add((Object)this.intrinsicsTab.getTab());
        this.uuiTab = new UUITab(interactionExe, gui);
        tabPane.getTabs().add((Object)this.uuiTab.getTab());
        this.dataTab = new AttachedDataTab(interactionExe, gui);
        tabPane.getTabs().add((Object)this.dataTab.getTab());
        this.agentNotesTab = new AgentNotesTab(interactionExe, gui);
        tabPane.getTabs().add((Object)this.agentNotesTab.getTab());
        this.customFieldsTab = new CustomFieldsTab(interactionExe, gui);
        tabPane.getTabs().add((Object)this.customFieldsTab.getTab());
        this.sideBar.getChildren().add((Object)tabPane);
    }

    public VBox getSideBar() {
        return this.sideBar;
    }

    public void update(InteractionDataI data) {
        this.intrinsicsTab.update(data);
        this.uuiTab.update(data);
        this.dataTab.update(data);
        this.agentNotesTab.update(data);
        this.customerDataPane.update(data);
    }

    public void updateCustomFields(CustomFieldListI customFields) {
        this.customFieldsTab.update(customFields);
    }
}

