/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ccs.api.enums;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.HashMap;
import java.util.Map;

public enum UserState {
    Invalid,
    LoggedOut,
    Ready,
    ReadyAfterCall,
    ACWPending,
    ACW,
    NotReadyPending,
    NotReady,
    UsedByOtherClient,
    Unknown;

    static Map<String, UserState> stateMap;

    public boolean isLoggedIn() {
        return this == Ready || this == NotReady || this == NotReadyPending || this == ReadyAfterCall || this == ACW || this == ACWPending;
    }

    @JsonCreator
    static UserState get(String stateName) {
        UserState state = stateMap.get(stateName);
        if (state == null) {
            state = Unknown;
        }
        return state;
    }

    static {
        stateMap = new HashMap<String, UserState>();
        for (UserState state : UserState.values()) {
            stateMap.put(state.toString(), state);
        }
    }
}

