/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.discovery.jdk;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import org.apache.commons.discovery.jdk.JDKHooks;
import org.apache.commons.discovery.jdk.PsuedoSystemClassLoader;

class JDK12Hooks
extends JDKHooks {
    private static final ClassLoader systemClassLoader = JDK12Hooks.findSystemClassLoader();

    JDK12Hooks() {
    }

    public ClassLoader getThreadContextClassLoader() {
        ClassLoader classLoader;
        try {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        catch (SecurityException e) {
            classLoader = null;
        }
        return classLoader;
    }

    public ClassLoader getSystemClassLoader() {
        return systemClassLoader;
    }

    public Enumeration getResources(ClassLoader loader, String resourceName) throws IOException {
        final URL first = loader.getResource(resourceName);
        final Enumeration<URL> rest = loader.getResources(resourceName);
        return new Enumeration(){
            private boolean firstDone;
            private URL next;
            {
                this.firstDone = first == null;
                this.next = this.getNext();
            }

            public Object nextElement() {
                URL o = this.next;
                this.next = this.getNext();
                return o;
            }

            public boolean hasMoreElements() {
                return this.next != null;
            }

            private URL getNext() {
                URL n;
                if (!this.firstDone) {
                    this.firstDone = true;
                    n = first;
                } else {
                    n = null;
                    while (rest.hasMoreElements() && n == null) {
                        n = (URL)rest.nextElement();
                        if (first == null || n == null || !n.equals(first)) continue;
                        n = null;
                    }
                }
                return n;
            }
        };
    }

    private static ClassLoader findSystemClassLoader() {
        ClassLoader classLoader;
        try {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        catch (SecurityException e) {
            classLoader = null;
        }
        if (classLoader == null) {
            classLoader = new PsuedoSystemClassLoader();
        }
        return classLoader;
    }
}

