package test;

import java.rmi.RemoteException;

import javax.xml.rpc.ServiceException;

import org.oasis_open.docs.wsrf._2004._06.wsrf_WS_BaseFaults_1_2_draft_01_xsd.ExceptionInfo;

import com.nortel.www.soa.oi.OpenNetworking.SOAOI_OpenNetworkingLocator;
import com.nortel.www.soa.oi.OpenNetworking.types.CancelCDNLandingPadRequestType;
import com.nortel.www.soa.oi.OpenNetworking.types.ReserveCDNLandingPadRequestType;
import com.nortel.www.soa.oi.OpenNetworking.types.ReserveLandingPadResponseType;
import com.nortel.www.soa.oi.cct.types.AddressType;
import com.nortel.www.soa.oi.cct.types.Authentication;
import com.nortel.www.soa.oi.cct.types.AuthenticationLevel;
import com.nortel.www.soa.oi.cct.types.ContactGUID;
import com.nortel.www.soa.oi.cct.types.Intrinsic;
import com.nortel.www.soa.oi.cct.types.LandingPad;
import com.nortel.www.soa.oi.cct.types.Reason;
import com.nortel.www.soa.oi.cct.types.holders.ContactGUIDHolder;


public class OpenNetworkingClient {
	public static void main(String[] args) {
		try{
			
			// Validate that required program arguments have been supplied
			if(args == null || args.length < 2){
				System.out.println("The following Parameters must be provider");
				System.out.println("arg[0] String NetworkDialledAddressName eg. LandingPadAddressName");
				System.out.println("arg[1] String GUID eg. 1234");
				System.exit(1);
			}
			OpenNetworkingClient main = new OpenNetworkingClient();
			main.setup(args);
			
		}catch(Exception ex){
			ex.printStackTrace();
		}
	}
	
	private void setup(String[] args) throws ServiceException, ExceptionInfo, RemoteException{		

		// Get the service stub generated from the Web Service WSDL
		SOAOI_OpenNetworkingLocator locator = new SOAOI_OpenNetworkingLocator();
		com.nortel.www.soa.oi.OpenNetworking.OpenNetworking service = locator.getOpenNetworking();
		try{
			String NetworkDialledAddressName = args[0];
			
			// Note that attachedData and intrinsics are optional 
			// The attribute 'minOccurs' is set to 0 in the WSDL type definition
			String attachedData = "attachedData";
			Intrinsic[] intrinsics = new Intrinsic[]{new Intrinsic("theKey", "theValue", true)};
			
			Reason reasonCode = Reason.CONFERENCE_OPEN_NET_INIT;
			ContactGUID guid = new ContactGUID();
			guid.setGuid(args[1]);
			AddressType addressType = AddressType.LANDING_PAD;

			// This is the authentication object. 
			// The username is fixed to 'OpenWsUser'.
			// The password is defaulted to 'Password123'.
			// The domain defaults to 'localhost' but can be any String value. It is not used in this release.
			com.nortel.www.soa.oi.cct.types.Authentication authentication = 
				new Authentication("OpenWsUser", "Password123", "localhost");
			
			// Call operation to reserve a landing pad address
			ReserveCDNLandingPadRequestType reserveCDNLandingPadRequest = 
				new ReserveCDNLandingPadRequestType(guid, 
												    NetworkDialledAddressName,   
						                            attachedData, 
						                            intrinsics, 
						                            reasonCode, 
						                            authentication);			
			ReserveLandingPadResponseType  landingPadResponse = service.reserveCDNLandingPad(reserveCDNLandingPadRequest);
			
			String landingPadName = landingPadResponse.getLandingPadCDN().getName();
			System.out.println("LandingPad name = " + landingPadName);
			
			
			// Call operation to cancel the landing pad using the same authentication credentials as above.
			CancelCDNLandingPadRequestType cancelCDNLandingPadRequest = 
				new CancelCDNLandingPadRequestType(landingPadName, authentication);
			service.cancelCDNLandingPad(cancelCDNLandingPadRequest);
			
		}catch(Exception ex){
			ex.printStackTrace();
		}
	}	
}
