/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.corba;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.cxf.binding.corba.CorbaBindingException;
import org.apache.cxf.binding.corba.CorbaMessage;
import org.apache.cxf.binding.corba.CorbaStreamable;
import org.apache.cxf.binding.corba.CorbaTypeMap;
import org.apache.cxf.binding.corba.utils.CorbaAnyHelper;
import org.apache.cxf.binding.corba.utils.CorbaBindingHelper;
import org.apache.cxf.binding.corba.utils.OrbConfig;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.MessageObserver;
import org.apache.cxf.ws.addressing.AttributedURIType;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.omg.CORBA.Any;
import org.omg.CORBA.NVList;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.ServerRequest;
import org.omg.CORBA.portable.Streamable;

public class CorbaServerConduit
implements Conduit {
    private EndpointInfo endpointInfo;
    private EndpointReferenceType target;
    private ORB orb;
    private CorbaTypeMap typeMap;
    private Object targetObject;

    public CorbaServerConduit(EndpointInfo ei, EndpointReferenceType ref, Object targetObj, ORB o, OrbConfig config, CorbaTypeMap map) {
        this.endpointInfo = ei;
        this.target = this.getTargetReference(ref);
        this.orb = o == null ? CorbaBindingHelper.getDefaultORB(config) : o;
        this.typeMap = map;
        this.targetObject = targetObj;
    }

    public void prepare(Message message) throws IOException {
        message.put("orb", this.orb);
        message.put("endpoint", this.targetObject);
        message.setContent(OutputStream.class, new CorbaOutputStream(message));
        ((CorbaMessage)message).setCorbaTypeMap(this.typeMap);
    }

    public void close(Message message) throws IOException {
        this.buildRequestResult((CorbaMessage)message);
        message.getContent(OutputStream.class).close();
    }

    public EndpointReferenceType getTarget() {
        return this.target;
    }

    public Destination getBackChannel() {
        return null;
    }

    public void close() {
    }

    public void setMessageObserver(MessageObserver observer) {
    }

    public final EndpointReferenceType getTargetReference(EndpointReferenceType t) {
        EndpointReferenceType ref = null;
        if (null == t) {
            ref = new EndpointReferenceType();
            AttributedURIType address = new AttributedURIType();
            address.setValue(this.getAddress());
            ref.setAddress(address);
        } else {
            ref = t;
        }
        return ref;
    }

    public final String getAddress() {
        return this.endpointInfo.getAddress();
    }

    public void buildRequestResult(CorbaMessage msg) {
        Exchange exg = msg.getExchange();
        ServerRequest request = exg.get(ServerRequest.class);
        try {
            if (!exg.isOneWay()) {
                CorbaMessage inMsg = (CorbaMessage)msg.getExchange().getInMessage();
                NVList list = inMsg.getList();
                if (msg.getStreamableException() != null) {
                    Any exAny = CorbaAnyHelper.createAny(this.orb);
                    CorbaStreamable exception = msg.getStreamableException();
                    exAny.insert_Streamable((Streamable)exception);
                    request.set_exception(exAny);
                    if (msg.getExchange() != null) {
                        msg.getExchange().setOutFaultMessage(msg);
                    }
                } else {
                    CorbaStreamable resultValue;
                    CorbaStreamable[] arguments = msg.getStreamableArguments();
                    if (arguments != null) {
                        for (int i = 0; i < arguments.length; ++i) {
                            if (list.item(i).flags() == 1) continue;
                            arguments[i].getObject().setIntoAny(list.item(i).value(), arguments[i], true);
                        }
                    }
                    if ((resultValue = msg.getStreamableReturn()) != null) {
                        Any resultAny = CorbaAnyHelper.createAny(this.orb);
                        resultValue.getObject().setIntoAny(resultAny, resultValue, true);
                        request.set_result(resultAny);
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new CorbaBindingException("Exception during buildRequestResult", ex);
        }
    }

    private class CorbaOutputStream
    extends CachedOutputStream {
        CorbaOutputStream(Message m) {
        }

        public void doFlush() throws IOException {
        }

        public void doClose() throws IOException {
        }

        public void onWrite() throws IOException {
        }
    }
}

