/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import org.apache.cxf.jaxrs.ext.MappingsHandler;
import org.apache.cxf.jaxrs.ext.ParameterHandler;
import org.apache.cxf.jaxrs.ext.RequestHandler;
import org.apache.cxf.jaxrs.ext.ResponseHandler;
import org.apache.cxf.jaxrs.impl.RequestPreprocessor;
import org.apache.cxf.jaxrs.impl.WebApplicationExceptionMapper;
import org.apache.cxf.jaxrs.model.ProviderInfo;
import org.apache.cxf.jaxrs.provider.ActivationProvider;
import org.apache.cxf.jaxrs.provider.BinaryDataProvider;
import org.apache.cxf.jaxrs.provider.FormEncodingReaderProvider;
import org.apache.cxf.jaxrs.provider.JAXBElementProvider;
import org.apache.cxf.jaxrs.provider.JSONProvider;
import org.apache.cxf.jaxrs.provider.PrimitiveTextProvider;
import org.apache.cxf.jaxrs.provider.SourceProvider;
import org.apache.cxf.jaxrs.provider.StringProvider;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProviderFactory {
    private static final Map<String, ProviderFactory> FACTORIES = new HashMap<String, ProviderFactory>();
    private static final ProviderFactory DEFAULT_FACTORY = new ProviderFactory();
    private static final String SLASH = "/";
    private List<ProviderInfo<MessageBodyReader>> defaultMessageReaders = new ArrayList<ProviderInfo<MessageBodyReader>>();
    private List<ProviderInfo<MessageBodyWriter>> defaultMessageWriters = new ArrayList<ProviderInfo<MessageBodyWriter>>();
    private List<ProviderInfo<MessageBodyReader>> userMessageReaders = new ArrayList<ProviderInfo<MessageBodyReader>>(1);
    private List<ProviderInfo<MessageBodyWriter>> userMessageWriters = new ArrayList<ProviderInfo<MessageBodyWriter>>(1);
    private List<ProviderInfo<ContextResolver>> userContextResolvers = new ArrayList<ProviderInfo<ContextResolver>>(1);
    private List<ProviderInfo<ExceptionMapper>> defaultExceptionMappers = new ArrayList<ProviderInfo<ExceptionMapper>>(1);
    private List<ProviderInfo<ExceptionMapper>> userExceptionMappers = new ArrayList<ProviderInfo<ExceptionMapper>>(1);
    private List<ProviderInfo<RequestHandler>> requestHandlers = new ArrayList<ProviderInfo<RequestHandler>>(1);
    private List<ProviderInfo<ResponseHandler>> responseHandlers = new ArrayList<ProviderInfo<ResponseHandler>>(1);
    private List<ProviderInfo<ParameterHandler>> jaxrsParamHandlers = new ArrayList<ProviderInfo<ParameterHandler>>(1);
    private RequestPreprocessor requestPreprocessor;

    private ProviderFactory() {
        this.setProviders(this.defaultMessageReaders, this.defaultMessageWriters, this.userContextResolvers, this.requestHandlers, this.responseHandlers, this.defaultExceptionMappers, this.jaxrsParamHandlers, new JAXBElementProvider(), new JSONProvider(), new BinaryDataProvider(), new StringProvider(), new SourceProvider(), new FormEncodingReaderProvider(), new PrimitiveTextProvider(), new ActivationProvider(), new WebApplicationExceptionMapper(), new MappingsHandler());
    }

    public static ProviderFactory getInstance() {
        return ProviderFactory.getInstance(SLASH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProviderFactory getInstance(String baseAddress) {
        if (SLASH.equals(baseAddress)) {
            return DEFAULT_FACTORY;
        }
        ProviderFactory pf = null;
        Class<ProviderFactory> clazz = ProviderFactory.class;
        synchronized (ProviderFactory.class) {
            pf = FACTORIES.get(baseAddress);
            if (pf == null) {
                pf = new ProviderFactory();
                FACTORIES.put(baseAddress, pf);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return pf;
        }
    }

    public <T> ContextResolver<T> createContextResolver(Type contextType, Message m) {
        for (ProviderInfo<ContextResolver> cr : this.userContextResolvers) {
            Type[] types;
            for (Type t : types = cr.getProvider().getClass().getGenericInterfaces()) {
                if (!(t instanceof ParameterizedType)) continue;
                ParameterizedType pt = (ParameterizedType)t;
                Type[] args = pt.getActualTypeArguments();
                for (int i = 0; i < args.length; ++i) {
                    if (contextType != args[i]) continue;
                    InjectionUtils.injectContextFields(cr.getProvider(), cr, m);
                    InjectionUtils.injectContextMethods(cr.getProvider(), cr, m);
                    return cr.getProvider();
                }
            }
        }
        return null;
    }

    public <T> ExceptionMapper<T> createExceptionMapper(Class<?> exceptionType, Message m) {
        ExceptionMapper<T> mapper = ProviderFactory.doCreateExceptionMapper(this.userExceptionMappers, exceptionType, m);
        if (mapper != null) {
            return mapper;
        }
        return ProviderFactory.doCreateExceptionMapper(this.defaultExceptionMappers, exceptionType, m);
    }

    private static <T> ExceptionMapper<T> doCreateExceptionMapper(List<ProviderInfo<ExceptionMapper>> mappers, Class<?> exceptionType, Message m) {
        LinkedList<ExceptionMapper> candidates = new LinkedList<ExceptionMapper>();
        for (ProviderInfo<ExceptionMapper> em : mappers) {
            Type[] types;
            for (Type t : types = em.getProvider().getClass().getGenericInterfaces()) {
                if (!(t instanceof ParameterizedType)) continue;
                ParameterizedType pt = (ParameterizedType)t;
                Type[] args = pt.getActualTypeArguments();
                for (int i = 0; i < args.length; ++i) {
                    if (!((Class)args[i]).isAssignableFrom(exceptionType)) continue;
                    InjectionUtils.injectContextFields(em.getProvider(), em, m);
                    InjectionUtils.injectContextMethods(em.getProvider(), em, m);
                    candidates.add(em.getProvider());
                }
            }
        }
        if (candidates.size() == 0) {
            return null;
        }
        Collections.sort(candidates, new ExceptionMapperComparator());
        return (ExceptionMapper)candidates.get(0);
    }

    public <T> ParameterHandler<T> createParameterHandler(Class<?> paramType) {
        LinkedList<ParameterHandler> candidates = new LinkedList<ParameterHandler>();
        for (ProviderInfo<ParameterHandler> em : this.jaxrsParamHandlers) {
            Type[] types;
            for (Type t : types = em.getProvider().getClass().getGenericInterfaces()) {
                if (!(t instanceof ParameterizedType)) continue;
                ParameterizedType pt = (ParameterizedType)t;
                Type[] args = pt.getActualTypeArguments();
                for (int i = 0; i < args.length; ++i) {
                    if (!((Class)args[i]).isAssignableFrom(paramType)) continue;
                    candidates.add(em.getProvider());
                }
            }
        }
        if (candidates.size() == 0) {
            return null;
        }
        Collections.sort(candidates, new ParameterHandlerComparator());
        return (ParameterHandler)candidates.get(0);
    }

    public <T> MessageBodyReader<T> createMessageBodyReader(Class<T> bodyType, Type parameterType, Annotation[] parameterAnnotations, MediaType mediaType, Message m) {
        MessageBodyReader<T> mr = this.chooseMessageReader(this.userMessageReaders, bodyType, parameterType, parameterAnnotations, mediaType, m);
        if (mr == null) {
            mr = this.chooseMessageReader(this.defaultMessageReaders, bodyType, parameterType, parameterAnnotations, mediaType, m);
        }
        return mr;
    }

    public List<ProviderInfo<RequestHandler>> getRequestHandlers() {
        return Collections.unmodifiableList(this.requestHandlers);
    }

    public List<ProviderInfo<ResponseHandler>> getResponseHandlers() {
        return Collections.unmodifiableList(this.responseHandlers);
    }

    public <T> MessageBodyWriter<T> createMessageBodyWriter(Class<T> bodyType, Type parameterType, Annotation[] parameterAnnotations, MediaType mediaType, Message m) {
        MessageBodyWriter<T> mw = this.chooseMessageWriter(this.userMessageWriters, bodyType, parameterType, parameterAnnotations, mediaType, m);
        if (mw == null) {
            mw = this.chooseMessageWriter(this.defaultMessageWriters, bodyType, parameterType, parameterAnnotations, mediaType, m);
        }
        return mw;
    }

    private void setProviders(List<ProviderInfo<MessageBodyReader>> readers, List<ProviderInfo<MessageBodyWriter>> writers, List<ProviderInfo<ContextResolver>> resolvers, List<ProviderInfo<RequestHandler>> requestFilters, List<ProviderInfo<ResponseHandler>> responseFilters, List<ProviderInfo<ExceptionMapper>> excMappers, List<ProviderInfo<ParameterHandler>> paramHandlers, Object ... providers) {
        for (Object o : providers) {
            if (MessageBodyReader.class.isAssignableFrom(o.getClass())) {
                readers.add(new ProviderInfo<MessageBodyReader>((MessageBodyReader)o));
            }
            if (MessageBodyWriter.class.isAssignableFrom(o.getClass())) {
                writers.add(new ProviderInfo<MessageBodyWriter>((MessageBodyWriter)o));
            }
            if (ContextResolver.class.isAssignableFrom(o.getClass())) {
                resolvers.add(new ProviderInfo<ContextResolver>((ContextResolver)o));
            }
            if (RequestHandler.class.isAssignableFrom(o.getClass())) {
                requestFilters.add(new ProviderInfo<RequestHandler>((RequestHandler)o));
            }
            if (ResponseHandler.class.isAssignableFrom(o.getClass())) {
                responseFilters.add(new ProviderInfo<ResponseHandler>((ResponseHandler)o));
            }
            if (ExceptionMapper.class.isAssignableFrom(o.getClass())) {
                excMappers.add(new ProviderInfo<ExceptionMapper>((ExceptionMapper)o));
            }
            if (!ParameterHandler.class.isAssignableFrom(o.getClass())) continue;
            paramHandlers.add(new ProviderInfo<ParameterHandler>((ParameterHandler)o));
        }
        this.sortReaders(readers);
        this.sortWriters(writers);
        this.injectContexts(readers, writers, resolvers, requestFilters, responseFilters, excMappers);
    }

    void injectContexts(List<?> ... providerLists) {
        for (List<?> list : providerLists) {
            for (Object p : list) {
                ProviderInfo pi = (ProviderInfo)p;
                InjectionUtils.injectContextProxies(pi, pi.getProvider());
            }
        }
    }

    private void sortReaders(List<ProviderInfo<MessageBodyReader>> entityProviders) {
        Collections.sort(entityProviders, new MessageBodyReaderComparator());
    }

    private void sortWriters(List<ProviderInfo<MessageBodyWriter>> entityProviders) {
        Collections.sort(entityProviders, new MessageBodyWriterComparator());
    }

    private <T> MessageBodyReader<T> chooseMessageReader(List<ProviderInfo<MessageBodyReader>> readers, Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType, Message m) {
        for (ProviderInfo<MessageBodyReader> ep : readers) {
            InjectionUtils.injectContextFields(ep.getProvider(), ep, m);
            InjectionUtils.injectContextMethods(ep.getProvider(), ep, m);
            if (!this.matchesReaderCriterias(ep.getProvider(), type, genericType, annotations, mediaType)) continue;
            return ep.getProvider();
        }
        return null;
    }

    private <T> boolean matchesReaderCriterias(MessageBodyReader<T> ep, Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (!ep.isReadable(type, genericType, annotations)) {
            return false;
        }
        List<MediaType> supportedMediaTypes = JAXRSUtils.getProviderConsumeTypes(ep);
        List<MediaType> availableMimeTypes = JAXRSUtils.intersectMimeTypes(Collections.singletonList(mediaType), supportedMediaTypes);
        return availableMimeTypes.size() != 0;
    }

    private <T> MessageBodyWriter<T> chooseMessageWriter(List<ProviderInfo<MessageBodyWriter>> writers, Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType, Message m) {
        for (ProviderInfo<MessageBodyWriter> ep : writers) {
            InjectionUtils.injectContextFields(ep.getProvider(), ep, m);
            InjectionUtils.injectContextMethods(ep.getProvider(), ep, m);
            if (!this.matchesWriterCriterias(ep.getProvider(), type, genericType, annotations, mediaType)) continue;
            return ep.getProvider();
        }
        return null;
    }

    private <T> boolean matchesWriterCriterias(MessageBodyWriter<T> ep, Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (!ep.isWriteable(type, genericType, annotations)) {
            return false;
        }
        List<MediaType> supportedMediaTypes = JAXRSUtils.getProviderProduceTypes(ep);
        List<MediaType> availableMimeTypes = JAXRSUtils.intersectMimeTypes(Collections.singletonList(mediaType), supportedMediaTypes);
        return availableMimeTypes.size() != 0;
    }

    List<ProviderInfo<MessageBodyReader>> getDefaultMessageReaders() {
        return Collections.unmodifiableList(this.defaultMessageReaders);
    }

    List<ProviderInfo<MessageBodyWriter>> getDefaultMessageWriters() {
        return Collections.unmodifiableList(this.defaultMessageWriters);
    }

    List<ProviderInfo<MessageBodyReader>> getUserMessageReaders() {
        return Collections.unmodifiableList(this.userMessageReaders);
    }

    List<ProviderInfo<MessageBodyWriter>> getUserMessageWriters() {
        return Collections.unmodifiableList(this.userMessageWriters);
    }

    List<ProviderInfo<ContextResolver>> getUserContextResolvers() {
        return Collections.unmodifiableList(this.userContextResolvers);
    }

    public void registerUserProvider(Object provider) {
        this.setUserProviders(Collections.singletonList(provider));
    }

    public void setUserProviders(List<?> userProviders) {
        this.setProviders(this.userMessageReaders, this.userMessageWriters, this.userContextResolvers, this.requestHandlers, this.responseHandlers, this.userExceptionMappers, this.jaxrsParamHandlers, userProviders.toArray());
    }

    public void setRequestPreprocessor(RequestPreprocessor rp) {
        this.requestPreprocessor = rp;
    }

    public RequestPreprocessor getRequestPreprocessor() {
        return this.requestPreprocessor;
    }

    public void clearThreadLocalProxies() {
        this.clearProxies(this.defaultMessageReaders, this.defaultMessageWriters, this.userMessageReaders, this.userMessageWriters, this.userContextResolvers, this.requestHandlers, this.responseHandlers, this.userExceptionMappers);
    }

    void clearProxies(List<?> ... lists) {
        for (List<?> list : lists) {
            for (Object p : list) {
                ProviderInfo pi = (ProviderInfo)p;
                pi.clearThreadLocalProxies();
            }
        }
    }

    void clearProviders() {
        this.userMessageReaders.clear();
        this.userMessageWriters.clear();
        this.userContextResolvers.clear();
        this.userExceptionMappers.clear();
        this.requestHandlers.clear();
        this.responseHandlers.clear();
        this.jaxrsParamHandlers.clear();
    }

    public void setSchemaLocations(List<String> schemas) {
        this.setSchemasOnProviders(this.userMessageReaders, schemas);
        this.setSchemasOnProviders(this.defaultMessageReaders, schemas);
    }

    private void setSchemasOnProviders(List<ProviderInfo<MessageBodyReader>> providers, List<String> schemas) {
        for (ProviderInfo<MessageBodyReader> r : providers) {
            try {
                Method m = r.getProvider().getClass().getMethod("setSchemas", List.class);
                m.invoke((Object)r.getProvider(), schemas);
            }
            catch (Exception ex) {}
        }
    }

    private static int compareClasses(Class<?> cl1, Class<?> cl2) {
        Class<?> realClass2;
        Type[] types1 = cl1.getGenericInterfaces();
        Type[] types2 = cl2.getGenericInterfaces();
        Class<?> realClass1 = InjectionUtils.getActualType(types1[0]);
        if (realClass1 == (realClass2 = InjectionUtils.getActualType(types2[0]))) {
            return 0;
        }
        if (realClass1.isAssignableFrom(realClass2)) {
            return 1;
        }
        return -1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ParameterHandlerComparator
    implements Comparator<ParameterHandler<? extends Object>> {
        private ParameterHandlerComparator() {
        }

        @Override
        public int compare(ParameterHandler<? extends Object> em1, ParameterHandler<? extends Object> em2) {
            return ProviderFactory.compareClasses(em1.getClass(), em2.getClass());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExceptionMapperComparator
    implements Comparator<ExceptionMapper<? extends Throwable>> {
        private ExceptionMapperComparator() {
        }

        @Override
        public int compare(ExceptionMapper<? extends Throwable> em1, ExceptionMapper<? extends Throwable> em2) {
            return ProviderFactory.compareClasses(em1.getClass(), em2.getClass());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MessageBodyWriterComparator
    implements Comparator<ProviderInfo<MessageBodyWriter>> {
        private MessageBodyWriterComparator() {
        }

        @Override
        public int compare(ProviderInfo<MessageBodyWriter> p1, ProviderInfo<MessageBodyWriter> p2) {
            MessageBodyWriter e1 = p1.getProvider();
            MessageBodyWriter e2 = p2.getProvider();
            List<MediaType> types1 = JAXRSUtils.sortMediaTypes(JAXRSUtils.getProviderProduceTypes(e1));
            List<MediaType> types2 = JAXRSUtils.sortMediaTypes(JAXRSUtils.getProviderProduceTypes(e2));
            return JAXRSUtils.compareSortedMediaTypes(types1, types2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MessageBodyReaderComparator
    implements Comparator<ProviderInfo<MessageBodyReader>> {
        private MessageBodyReaderComparator() {
        }

        @Override
        public int compare(ProviderInfo<MessageBodyReader> p1, ProviderInfo<MessageBodyReader> p2) {
            MessageBodyReader e1 = p1.getProvider();
            MessageBodyReader e2 = p2.getProvider();
            List<MediaType> types1 = JAXRSUtils.getProviderConsumeTypes(e1);
            types1 = JAXRSUtils.sortMediaTypes(types1);
            List<MediaType> types2 = JAXRSUtils.getProviderConsumeTypes(e2);
            types2 = JAXRSUtils.sortMediaTypes(types2);
            return JAXRSUtils.compareSortedMediaTypes(types1, types2);
        }
    }
}

