/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.java2wsdl.processor;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingType;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.bus.spring.BusApplicationContext;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.service.ServiceBuilder;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.tools.common.Processor;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.java2wsdl.generator.AbstractGenerator;
import org.apache.cxf.tools.java2wsdl.generator.WSDLGeneratorFactory;
import org.apache.cxf.tools.java2wsdl.generator.wsdl11.FaultBeanGenerator;
import org.apache.cxf.tools.java2wsdl.generator.wsdl11.WrapperBeanGenerator;
import org.apache.cxf.tools.java2wsdl.processor.internal.ServiceBuilderFactory;
import org.apache.cxf.tools.util.AnnotationUtil;
import org.apache.cxf.wsdl.WSDLConstants;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaToWSDLProcessor
implements Processor {
    private static final Logger LOG = LogUtils.getL7dLogger(JavaToWSDLProcessor.class);
    private static final String DEFAULT_ADDRESS = "http://localhost:9090/hello";
    private static final String JAVA_CLASS_PATH = "java.class.path";
    private ToolContext context;
    private final List<AbstractGenerator> generators = new ArrayList<AbstractGenerator>();
    private ApplicationContext applicationContext;

    private void customize(ServiceInfo service) {
        if (this.context.containsKey("tns")) {
            String ns = (String)this.context.get("tns");
            service.setTargetNamespace(ns);
        }
        if (this.context.containsKey("port")) {
            String portName = (String)this.context.get("port");
            EndpointInfo einfo = service.getEndpoints().iterator().next();
            QName qn = new QName(einfo.getName().getNamespaceURI(), portName);
            einfo.setName(qn);
        }
        if (this.context.containsKey("servicename")) {
            String svName = this.getServiceName();
            service.setName(new QName(service.getName().getNamespaceURI(), svName));
        }
        EndpointInfo endpointInfo = service.getEndpoints().iterator().next();
        String address = "http://localhost:9090/" + endpointInfo.getName().getLocalPart();
        if (this.context.get("address") != null) {
            address = (String)this.context.get("address");
        }
        endpointInfo.setAddress(address);
        this.context.put("address", address);
    }

    public static ApplicationContext getApplicationContext(Bus bus, List<String> additionalFilePathnames) {
        BusApplicationContext busApplicationContext = bus.getExtension(BusApplicationContext.class);
        GenericApplicationContext appContext = new GenericApplicationContext((ApplicationContext)busApplicationContext);
        XmlBeanDefinitionReader reader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)appContext);
        reader.loadBeanDefinitions((Resource)new ClassPathResource("META-INF/cxf/java2wsbeans.xml"));
        for (String pathname : additionalFilePathnames) {
            try {
                reader.loadBeanDefinitions((Resource)new FileSystemResource(pathname));
            }
            catch (BeanDefinitionStoreException bdse) {
                throw new ToolException("Unable to open bean definition file " + pathname, bdse.getCause());
            }
        }
        return appContext;
    }

    @Override
    public void process() throws ToolException {
        String oldClassPath = System.getProperty(JAVA_CLASS_PATH);
        LOG.log(Level.FINE, "OLD_CP", oldClassPath);
        if (this.context.get("classpath") != null) {
            String newCp = (String)this.context.get("classpath");
            System.setProperty(JAVA_CLASS_PATH, newCp + File.pathSeparator + oldClassPath);
            LOG.log(Level.FINE, "NEW_CP", newCp);
        }
        ServiceBuilder builder = this.getServiceBuilder();
        ServiceInfo service = builder.createService();
        this.customize(service);
        File wsdlFile = this.getOutputFile(builder.getOutputFile(), service.getName().getLocalPart() + ".wsdl");
        File outputDir = this.getOutputDir(wsdlFile);
        if (this.context.containsKey("wsdl")) {
            this.generators.add(this.getWSDLGenerator(wsdlFile));
        }
        if (this.context.containsKey("wrapperbean")) {
            this.generators.add(this.getWrapperBeanGenerator());
            this.generators.add(this.getFaultBeanGenerator());
        }
        this.generate(service, outputDir);
        ArrayList<ServiceInfo> serviceList = new ArrayList<ServiceInfo>();
        serviceList.add(service);
        this.context.put("serviceList", serviceList);
        System.setProperty(JAVA_CLASS_PATH, oldClassPath);
        LOG.log(Level.FINE, "RESUME_CP", oldClassPath);
    }

    private AbstractGenerator getWrapperBeanGenerator() {
        WrapperBeanGenerator generator = new WrapperBeanGenerator();
        generator.setOutputBase(this.getSourceDir());
        generator.setCompileToDir(this.getClassesDir());
        return generator;
    }

    private AbstractGenerator getFaultBeanGenerator() {
        FaultBeanGenerator generator = new FaultBeanGenerator();
        generator.setOutputBase(this.getSourceDir());
        generator.setCompileToDir(this.getClassesDir());
        return generator;
    }

    private AbstractGenerator getWSDLGenerator(File wsdlFile) {
        WSDLGeneratorFactory factory = new WSDLGeneratorFactory();
        factory.setWSDLVersion(this.getWSDLVersion());
        AbstractGenerator generator = factory.newGenerator();
        generator.setAllowImports(this.context.containsKey("createxsdimports"));
        generator.setOutputBase(wsdlFile);
        return generator;
    }

    public void generate(ServiceInfo service, File output) throws ToolException {
        for (AbstractGenerator generator : this.generators) {
            generator.setServiceModel(service);
            generator.setBus(this.getBus());
            generator.generate(output);
        }
    }

    public ServiceBuilder getServiceBuilder() throws ToolException {
        Object beanFilesParameter = this.context.get("beans");
        ArrayList<String> beanDefinitions = new ArrayList<String>();
        if (beanFilesParameter != null) {
            if (beanFilesParameter instanceof String) {
                beanDefinitions.add((String)beanFilesParameter);
            } else if (beanFilesParameter instanceof List) {
                beanDefinitions.addAll((List)beanFilesParameter);
            }
        }
        this.applicationContext = JavaToWSDLProcessor.getApplicationContext(this.getBus(), beanDefinitions);
        ServiceBuilderFactory builderFactory = ServiceBuilderFactory.getInstance();
        Class<?> clz = this.getServiceClass();
        this.context.put(Class.class, clz);
        if (clz.isInterface()) {
            this.context.put("genFromSEI", Boolean.TRUE);
            this.context.put("seiClass", clz.getName());
        } else {
            this.context.put("implClass", clz.getName());
            if (clz.getInterfaces().length == 1) {
                this.context.put("seiClass", clz.getInterfaces()[0].getName());
            }
            this.context.put("genFromSEI", Boolean.FALSE);
        }
        builderFactory.setServiceClass(clz);
        builderFactory.setDatabindingName(this.getDataBindingName());
        ServiceBuilder builder = builderFactory.newBuilder(this.applicationContext);
        builder.validate();
        if (this.context.get("address") != null) {
            String address = (String)this.context.get("address");
            builder.setAddress(address);
        } else {
            builder.setAddress(DEFAULT_ADDRESS);
        }
        builder.setTransportId(this.getTransportId());
        builder.setBus(this.getBus());
        builder.setBindingId(this.getBindingId());
        return builder;
    }

    protected String getTransportId() {
        if (this.isSOAP12()) {
            return "http://schemas.xmlsoap.org/wsdl/soap12/";
        }
        return "http://schemas.xmlsoap.org/wsdl/soap/";
    }

    protected String getBindingId() {
        if (this.isSOAP12()) {
            return "http://schemas.xmlsoap.org/wsdl/soap12/";
        }
        return "http://schemas.xmlsoap.org/wsdl/soap/";
    }

    protected boolean isSOAP12() {
        if (!this.context.optionSet("soap12")) {
            BindingType bType = this.getServiceClass().getAnnotation(BindingType.class);
            if (bType != null) {
                return "http://www.w3.org/2003/05/soap/bindings/HTTP/".equals(bType.value());
            }
            return false;
        }
        return true;
    }

    protected File getOutputDir(File wsdlLocation) {
        String dir = (String)this.context.get("outputdir");
        if (dir == null) {
            dir = wsdlLocation == null || wsdlLocation.getParentFile() == null || !wsdlLocation.getParentFile().exists() ? "./" : wsdlLocation.getParent();
        }
        return new File(dir);
    }

    protected File getOutputFile(File nameFromClz, String defaultOutputFile) {
        File result;
        String output = (String)this.context.get("outputfile");
        String dir = (String)this.context.get("outputdir");
        if (dir == null) {
            dir = "./";
        }
        if (output != null) {
            result = new File(output);
            if (!result.isAbsolute()) {
                result = new File(new File(dir), output);
            }
        } else {
            result = new File(new File(dir), defaultOutputFile);
        }
        if (nameFromClz != null) {
            result = nameFromClz;
        }
        if (result.exists() && !result.renameTo(new File(result.getParent(), result.getName()))) {
            throw new ToolException(new Message("OUTFILE_EXISTS", LOG, new Object[0]));
        }
        return result;
    }

    public Class<?> getServiceClass() {
        return AnnotationUtil.loadClass((String)this.context.get("classname"), Thread.currentThread().getContextClassLoader());
    }

    public WSDLConstants.WSDLVersion getWSDLVersion() {
        String version = (String)this.context.get("wsdlversion");
        WSDLConstants.WSDLVersion wsVersion = WSDLConstants.getVersion(version);
        if (wsVersion == WSDLConstants.WSDLVersion.UNKNOWN) {
            wsVersion = WSDLConstants.WSDLVersion.WSDL11;
        }
        return wsVersion;
    }

    public String getServiceName() {
        return (String)this.context.get("servicename");
    }

    File getSourceDir() {
        String dir = (String)this.context.get("sourcedir");
        if (StringUtils.isEmpty(dir)) {
            return null;
        }
        return new File(dir);
    }

    File getClassesDir() {
        String dir = (String)this.context.get("classdir");
        if (StringUtils.isEmpty(dir)) {
            return null;
        }
        return new File(dir);
    }

    public Bus getBus() {
        return BusFactory.getDefaultBus();
    }

    @Override
    public void setEnvironment(ToolContext env) {
        this.context = env;
    }

    public ToolContext getEnvironment() {
        return this.context;
    }

    public String getDataBindingName() {
        String databindingName = (String)this.context.get("databinding");
        if (databindingName == null) {
            databindingName = "jaxb";
        }
        return databindingName;
    }
}

